/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1

Rectangle
{
	id: popup

	property bool doAnimations: true

	property alias fontSize: infoText.font.pixelSize

	//private properties and signals
	Item
	{
		id: p

		visible: false

		property variant queue: new Array()

		function displayPopupInformation()
		{
			//if we use remainingWords directly, no changes get applied using pop() method, so this is workaround
			var tmp = queue

			//we dont want to override messages (must wait to previous message finish)
			if (!timer.running && popup.opacity==0 && tmp.length > 0)
			{
				var textToShow = tmp[0][0]
				var interval = parseInt(tmp[0][1])
				tmp.shift()
				queue = tmp

				if (interval > 0)
				{
					timer.interval = interval
					timer.start()
				}
				infoText.text = textToShow
				popup.opacity = 1
			}
		}
	}

	//must be positive number (0 means to never hide unless hideTextNow() is called)
	function showText(text, intervalOPTIONAL)
	{
		if (text)
		{
			var tmp = new Array(2)
			tmp[0] = text

			if (typeof intervalOPTIONAL != "undefined")
			{
				intervalOPTIONAL = parseInt(intervalOPTIONAL)
				if (intervalOPTIONAL < 0)
					intervalOPTIONAL = 3
			}
			else
				intervalOPTIONAL = 3
			intervalOPTIONAL *= 1000
			tmp[1] = intervalOPTIONAL

			var q = p.queue
			q.push(tmp)
			p.queue = q
			p.displayPopupInformation()
			return true
		}
		return false
	}

	function hideTextNow()
	{
		opacity = 0
		timer.stop()
	}

	function clearQueue()
	{
		p.queue = new Array()
	}

	width: parent.width
	height: infoText.height + 10
	radius: 7
	color: "#99000000"
	anchors.top: parent.top
	anchors.horizontalCenter: parent.horizontalCenter
	z: 10000
	opacity: 0

	onOpacityChanged: if (opacity == 0) p.displayPopupInformation()

	Behavior on opacity
	{
		NumberAnimation { duration: (doAnimations ? 500 : 0); easing.type: Easing.InOutQuad }
	}

	Text
	{
		id: infoText
		text: qsTr("Some info")
		anchors.verticalCenter: parent.verticalCenter
		anchors.horizontalCenter: parent.horizontalCenter
		color: "#ffffff"
		font.bold: true
		font.pointSize: 20
		horizontalAlignment: Text.AlignHCenter
	}

	Timer
	{
		id: timer
		interval: 3000
		running: false
		repeat: false
		triggeredOnStart: false
		onRunningChanged: if (!running) popup.opacity = 0
	}

	MouseArea
	{
		id: mouseArea

		anchors.fill: parent

		onReleased: popup.hideTextNow()
	}
}
