/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import "ComponentCreator.js" as CC

Rectangle
{
	id: languageRectangle

	property bool selectable: true

	property bool doAnimations: true
	smooth: true

	signal selectedValueChanged(string value)

	Item
	{
		id: priv
		property string selectedValue: ""
		onSelectedValueChanged:
		{
			languageRectangle.selectedValueChanged(selectedValue)
			var childs = languages.children
			//WARNING: this can make problems if it is changed dynamically (during runtime)
			if (selectable)
				for (var i=0; i<childs.length; i++)
					childs[i].enabled = childs[i].text != selectedValue
		}
	}

	function addText(text)
	{
		//initialization will be done only once (for same component init is skipped)
		CC.initializeComponent("Button", false)

		var obj = CC.createObject(languages, {"text": text,
											  "width": function(){return scrollArea.contentWidth},
											  "smooth": function(){return languageRectangle.smooth},
											  "doAnimations": function(){return languageRectangle.doAnimations}})
		obj.mouseArea.onReleasedState.connect(function()
		{
			priv.selectedValue = text
		})
	}

	function removeText(text)
	{
		var childs = languages.children
		for (var i=childs.length - 1; i>=0; i--)
		{
			var tmpChild = childs[i]
			if (tmpChild.text == text)
			{
				if (tmpChild.text == priv.selectedValue)
					priv.selectedValue = ""
				tmpChild.destroy()
			}
		}
	}

	function setSelectedValue(value)
	{
		priv.selectedValue = value
	}

	function getSelectedValue()
	{
		return priv.selectedValue
	}

	function clear()
	{
		priv.selectedValue = ""
		var childs = languages.children
		for (var i=childs.length - 1; i>=0; i--)
			childs[i].destroy()
	}

	color: "#444444"
	width: 50
	height: 250

	radius: 15

	Flickable
	{
		id: scrollArea
		anchors.fill: parent
		anchors.margins: 5

		flickableDirection: Flickable.VerticalFlick

		clip: true

		contentWidth: languageRectangle.width - scrollArea.anchors.margins * 2
		contentHeight: languages.height
		Column
		{
			id: languages
			spacing: 5
		}
	}
}
