/**
Copyright (c) 2012, DRAX <drax@drax.biz>
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the FreeBSD Project.
*/

// import QtQuick 1.0 // to target S60 5th Edition or Maemo 5
import QtQuick 1.1
import crosswords.AudioPlayer 1.0

Rectangle
{
	id: button

	property AudioPlayer customSound

    property alias text: text.text
    property alias mouseArea: mouseArea
    property alias buttonColor: gradientstop2.color
    property alias fontColor: text.color
	property int fontSize: 32
	property int minWidth: 0
	property int minHeight: 0

	//this is needed for ButtonCheckbox
	property alias textHorizontalAlignment: text.horizontalAlignment
	property alias textAnchors: text.anchors

	//TODO: this should be connected to main.doAnimations (not sure is it working) - same applies to smooth
	property bool doAnimations: true

    onEnabledChanged:
    {
        if (enabled)
        {
            opacity = 1
        }
        else
        {
            opacity = 0.5
		}
	}

    Behavior on opacity
    {
        NumberAnimation
        {
            property: "opacity"
			duration: (doAnimations ? 200 : 0)
            easing.type: Easing.InOutQuad
        }
    }

    width: 220
    height: 70
	radius: 15
	smooth: true

	Behavior on width
	{
		NumberAnimation { duration: (doAnimations ? 200 : 0); easing.type: Easing.InOutQuad }
	}
	Behavior on height
	{
		NumberAnimation { duration: (doAnimations ? 200 : 0); easing.type: Easing.InOutQuad }
	}

    gradient: Gradient {
        GradientStop {
            id: gradientstop1
            position: 0
            color: "#5c5c5c"
        }

        GradientStop {
            id: gradientstop2
            position: 1
            color: "#000000"
        }
    }

    Text {
        id: text
        color: "#ffffff"
		text: qsTr("text")
		smooth: parent.smooth
        font.bold: true
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
        anchors.fill: parent
		font.pixelSize: (text.text.indexOf("\n") >= 0 ? button.fontSize * 2 / 3 : button.fontSize)
	}

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        //this is workaround, use this instead "pressed" in JavaScript
		signal onPressedState(variant mouse)
		//it is bug in Qt 1.8.1, which overlaps with "pressed" (which is bool)
		onPressed: onPressedState(mouse)

		//this is not needed, but it is easier to work with
		signal onReleasedState(variant mouse)
		onReleased:
		{
			if (customSound && customSound.isPlayable())
				customSound.play()
			else
				playClick()
			onReleasedState(mouse)
		}

		signal onPressAndHoldState(variant mouse)
		onPressAndHold: onPressAndHoldState(mouse)
		signal onPositionChangedState(variant mouse)
		onPositionChanged: onPositionChangedState(mouse)
	}

    states: [
        State {
            name: "pressed"
            //this is instead onReleased and onPressed in mouse_area
            when: mouseArea.pressed

            PropertyChanges {
                target: gradientstop1
                position: 0
                color: "#9e9e9e"
            }
        }
    ]
}
