/*
 *  File:       cloud.h
 *  Summary:    Functions related to clouds.
 *  Written by: Brent Ross
 *
 *  Modified for Crawl Reference by $Author$ on $Date$
 */


#ifndef CLOUD_H
#define CLOUD_H

#include "externs.h"
#include "travel.h"

enum fog_machine_type
{
    FM_GEYSER,
    FM_SPREAD,
    FM_BROWNIAN,
    NUM_FOG_MACHINE_TYPES
};

struct fog_machine_data
{
    fog_machine_type fm_type;
    cloud_type       cl_type;
    int              size;
    int              power;
};

cloud_type random_smoke_type();

cloud_type cloud_type_at(const coord_def &pos);

void delete_cloud( int cloud );
void move_cloud( int cloud, const coord_def& newpos );

void check_place_cloud( cloud_type cl_type, const coord_def& p, int lifetime,
                        kill_category whose, int spread_rate = -1 );
void check_place_cloud( cloud_type cl_type, const coord_def& p, int lifetime,
                        killer_type killer, int spread_rate = -1 );
void check_place_cloud( cloud_type cl_type, const coord_def& p, int lifetime,
                        kill_category whose, killer_type killer,
                        int spread_rate = -1 );
void place_cloud( cloud_type cl_type, const coord_def& ctarget,
                  int cl_range, kill_category whose, int spread_rate = -1 );
void place_cloud( cloud_type cl_type, const coord_def& ctarget,
                  int cl_range, killer_type killer, int spread_rate = -1 );
void place_cloud( cloud_type cl_type, const coord_def& ctarget,
                  int cl_range, kill_category whose, killer_type killer,
                  int spread_rate = -1 );

void manage_clouds(void);

bool is_opaque_cloud(unsigned char cloud_idx);
int steam_cloud_damage(const cloud_struct &cloud);
int steam_cloud_damage(int decay);

cloud_type beam2cloud(beam_type flavour);
beam_type cloud2beam(cloud_type flavour);

int  max_cloud_damage(cloud_type cl_type, int power = -1);
void in_a_cloud(void);

std::string cloud_name(cloud_type type);

bool is_damaging_cloud(cloud_type type, bool temp = false);
bool is_harmless_cloud(cloud_type type);

// fog generator
void place_fog_machine(fog_machine_type fm_type, cloud_type cl_type,
                       int x, int y, int size, int power);

void place_fog_machine(fog_machine_data data, int x, int y);

bool valid_fog_machine_data(fog_machine_data data);

int              num_fogs_for_place(int level_number = -1,
                                const level_id &place = level_id::current());
fog_machine_data random_fog_for_place(int level_number = -1,
                                const level_id &place = level_id::current());

int              fogs_pan_number(int level_number = -1);
fog_machine_data fogs_pan_type(int level_number = -1);

int              fogs_abyss_number(int level_number = -1);
fog_machine_data fogs_abyss_type(int level_number = -1);

int              fogs_lab_number(int level_number = -1);
fog_machine_data fogs_lab_type(int level_number = -1);

#endif
