	typedef struct
	{
		void *label; /* opcode label */
		u16  mask;   /* mask on opcode */
		u16  match;  /* what to match after masking */
	} opcode_struct;

	opcode_struct c68k_opcode_jump_table[] =
	{
		{&&op_1010             , 0xf000, 0xa000},
		{&&op_1111             , 0xf000, 0xf000},
		{&&op_moveq_32         , 0xf100, 0x7000},
		{&&op_bra_8            , 0xff00, 0x6000},
		{&&op_bsr_8            , 0xff00, 0x6100},
		{&&op_bhi_8            , 0xff00, 0x6200},
		{&&op_bls_8            , 0xff00, 0x6300},
		{&&op_bcc_8            , 0xff00, 0x6400},
		{&&op_bcs_8            , 0xff00, 0x6500},
		{&&op_bne_8            , 0xff00, 0x6600},
		{&&op_beq_8            , 0xff00, 0x6700},
		{&&op_bvc_8            , 0xff00, 0x6800},
		{&&op_bvs_8            , 0xff00, 0x6900},
		{&&op_bpl_8            , 0xff00, 0x6a00},
		{&&op_bmi_8            , 0xff00, 0x6b00},
		{&&op_bge_8            , 0xff00, 0x6c00},
		{&&op_blt_8            , 0xff00, 0x6d00},
		{&&op_bgt_8            , 0xff00, 0x6e00},
		{&&op_ble_8            , 0xff00, 0x6f00},
		{&&op_btst_32_r_d      , 0xf1f8, 0x0100},
		{&&op_movep_16_er      , 0xf1f8, 0x0108},
		{&&op_btst_8_r_ai      , 0xf1f8, 0x0110},
		{&&op_btst_8_r_pi      , 0xf1f8, 0x0118},
		{&&op_btst_8_r_pd      , 0xf1f8, 0x0120},
		{&&op_btst_8_r_di      , 0xf1f8, 0x0128},
		{&&op_btst_8_r_ix      , 0xf1f8, 0x0130},
		{&&op_bchg_32_r_d      , 0xf1f8, 0x0140},
		{&&op_movep_32_er      , 0xf1f8, 0x0148},
		{&&op_bchg_8_r_ai      , 0xf1f8, 0x0150},
		{&&op_bchg_8_r_pi      , 0xf1f8, 0x0158},
		{&&op_bchg_8_r_pd      , 0xf1f8, 0x0160},
		{&&op_bchg_8_r_di      , 0xf1f8, 0x0168},
		{&&op_bchg_8_r_ix      , 0xf1f8, 0x0170},
		{&&op_bclr_32_r_d      , 0xf1f8, 0x0180},
		{&&op_movep_16_re      , 0xf1f8, 0x0188},
		{&&op_bclr_8_r_ai      , 0xf1f8, 0x0190},
		{&&op_bclr_8_r_pi      , 0xf1f8, 0x0198},
		{&&op_bclr_8_r_pd      , 0xf1f8, 0x01a0},
		{&&op_bclr_8_r_di      , 0xf1f8, 0x01a8},
		{&&op_bclr_8_r_ix      , 0xf1f8, 0x01b0},
		{&&op_bset_32_r_d      , 0xf1f8, 0x01c0},
		{&&op_movep_32_re      , 0xf1f8, 0x01c8},
		{&&op_bset_8_r_ai      , 0xf1f8, 0x01d0},
		{&&op_bset_8_r_pi      , 0xf1f8, 0x01d8},
		{&&op_bset_8_r_pd      , 0xf1f8, 0x01e0},
		{&&op_bset_8_r_di      , 0xf1f8, 0x01e8},
		{&&op_bset_8_r_ix      , 0xf1f8, 0x01f0},
		{&&op_move_8_d_d       , 0xf1f8, 0x1000},
		{&&op_move_8_d_ai      , 0xf1f8, 0x1010},
		{&&op_move_8_d_pi      , 0xf1f8, 0x1018},
		{&&op_move_8_d_pd      , 0xf1f8, 0x1020},
		{&&op_move_8_d_di      , 0xf1f8, 0x1028},
		{&&op_move_8_d_ix      , 0xf1f8, 0x1030},
		{&&op_move_8_ai_d      , 0xf1f8, 0x1080},
		{&&op_move_8_ai_ai     , 0xf1f8, 0x1090},
		{&&op_move_8_ai_pi     , 0xf1f8, 0x1098},
		{&&op_move_8_ai_pd     , 0xf1f8, 0x10a0},
		{&&op_move_8_ai_di     , 0xf1f8, 0x10a8},
		{&&op_move_8_ai_ix     , 0xf1f8, 0x10b0},
		{&&op_move_8_pi_d      , 0xf1f8, 0x10c0},
		{&&op_move_8_pi_ai     , 0xf1f8, 0x10d0},
		{&&op_move_8_pi_pi     , 0xf1f8, 0x10d8},
		{&&op_move_8_pi_pd     , 0xf1f8, 0x10e0},
		{&&op_move_8_pi_di     , 0xf1f8, 0x10e8},
		{&&op_move_8_pi_ix     , 0xf1f8, 0x10f0},
		{&&op_move_8_pd_d      , 0xf1f8, 0x1100},
		{&&op_move_8_pd_ai     , 0xf1f8, 0x1110},
		{&&op_move_8_pd_pi     , 0xf1f8, 0x1118},
		{&&op_move_8_pd_pd     , 0xf1f8, 0x1120},
		{&&op_move_8_pd_di     , 0xf1f8, 0x1128},
		{&&op_move_8_pd_ix     , 0xf1f8, 0x1130},
		{&&op_move_8_di_d      , 0xf1f8, 0x1140},
		{&&op_move_8_di_ai     , 0xf1f8, 0x1150},
		{&&op_move_8_di_pi     , 0xf1f8, 0x1158},
		{&&op_move_8_di_pd     , 0xf1f8, 0x1160},
		{&&op_move_8_di_di     , 0xf1f8, 0x1168},
		{&&op_move_8_di_ix     , 0xf1f8, 0x1170},
		{&&op_move_8_ix_d      , 0xf1f8, 0x1180},
		{&&op_move_8_ix_ai     , 0xf1f8, 0x1190},
		{&&op_move_8_ix_pi     , 0xf1f8, 0x1198},
		{&&op_move_8_ix_pd     , 0xf1f8, 0x11a0},
		{&&op_move_8_ix_di     , 0xf1f8, 0x11a8},
		{&&op_move_8_ix_ix     , 0xf1f8, 0x11b0},
		{&&op_move_32_d_d      , 0xf1f8, 0x2000},
		{&&op_move_32_d_a      , 0xf1f8, 0x2008},
		{&&op_move_32_d_ai     , 0xf1f8, 0x2010},
		{&&op_move_32_d_pi     , 0xf1f8, 0x2018},
		{&&op_move_32_d_pd     , 0xf1f8, 0x2020},
		{&&op_move_32_d_di     , 0xf1f8, 0x2028},
		{&&op_move_32_d_ix     , 0xf1f8, 0x2030},
		{&&op_movea_32_d       , 0xf1f8, 0x2040},
		{&&op_movea_32_a       , 0xf1f8, 0x2048},
		{&&op_movea_32_ai      , 0xf1f8, 0x2050},
		{&&op_movea_32_pi      , 0xf1f8, 0x2058},
		{&&op_movea_32_pd      , 0xf1f8, 0x2060},
		{&&op_movea_32_di      , 0xf1f8, 0x2068},
		{&&op_movea_32_ix      , 0xf1f8, 0x2070},
		{&&op_move_32_ai_d     , 0xf1f8, 0x2080},
		{&&op_move_32_ai_a     , 0xf1f8, 0x2088},
		{&&op_move_32_ai_ai    , 0xf1f8, 0x2090},
		{&&op_move_32_ai_pi    , 0xf1f8, 0x2098},
		{&&op_move_32_ai_pd    , 0xf1f8, 0x20a0},
		{&&op_move_32_ai_di    , 0xf1f8, 0x20a8},
		{&&op_move_32_ai_ix    , 0xf1f8, 0x20b0},
		{&&op_move_32_pi_d     , 0xf1f8, 0x20c0},
		{&&op_move_32_pi_a     , 0xf1f8, 0x20c8},
		{&&op_move_32_pi_ai    , 0xf1f8, 0x20d0},
		{&&op_move_32_pi_pi    , 0xf1f8, 0x20d8},
		{&&op_move_32_pi_pd    , 0xf1f8, 0x20e0},
		{&&op_move_32_pi_di    , 0xf1f8, 0x20e8},
		{&&op_move_32_pi_ix    , 0xf1f8, 0x20f0},
		{&&op_move_32_pd_d     , 0xf1f8, 0x2100},
		{&&op_move_32_pd_a     , 0xf1f8, 0x2108},
		{&&op_move_32_pd_ai    , 0xf1f8, 0x2110},
		{&&op_move_32_pd_pi    , 0xf1f8, 0x2118},
		{&&op_move_32_pd_pd    , 0xf1f8, 0x2120},
		{&&op_move_32_pd_di    , 0xf1f8, 0x2128},
		{&&op_move_32_pd_ix    , 0xf1f8, 0x2130},
		{&&op_move_32_di_d     , 0xf1f8, 0x2140},
		{&&op_move_32_di_a     , 0xf1f8, 0x2148},
		{&&op_move_32_di_ai    , 0xf1f8, 0x2150},
		{&&op_move_32_di_pi    , 0xf1f8, 0x2158},
		{&&op_move_32_di_pd    , 0xf1f8, 0x2160},
		{&&op_move_32_di_di    , 0xf1f8, 0x2168},
		{&&op_move_32_di_ix    , 0xf1f8, 0x2170},
		{&&op_move_32_ix_d     , 0xf1f8, 0x2180},
		{&&op_move_32_ix_a     , 0xf1f8, 0x2188},
		{&&op_move_32_ix_ai    , 0xf1f8, 0x2190},
		{&&op_move_32_ix_pi    , 0xf1f8, 0x2198},
		{&&op_move_32_ix_pd    , 0xf1f8, 0x21a0},
		{&&op_move_32_ix_di    , 0xf1f8, 0x21a8},
		{&&op_move_32_ix_ix    , 0xf1f8, 0x21b0},
		{&&op_move_16_d_d      , 0xf1f8, 0x3000},
		{&&op_move_16_d_a      , 0xf1f8, 0x3008},
		{&&op_move_16_d_ai     , 0xf1f8, 0x3010},
		{&&op_move_16_d_pi     , 0xf1f8, 0x3018},
		{&&op_move_16_d_pd     , 0xf1f8, 0x3020},
		{&&op_move_16_d_di     , 0xf1f8, 0x3028},
		{&&op_move_16_d_ix     , 0xf1f8, 0x3030},
		{&&op_movea_16_d       , 0xf1f8, 0x3040},
		{&&op_movea_16_a       , 0xf1f8, 0x3048},
		{&&op_movea_16_ai      , 0xf1f8, 0x3050},
		{&&op_movea_16_pi      , 0xf1f8, 0x3058},
		{&&op_movea_16_pd      , 0xf1f8, 0x3060},
		{&&op_movea_16_di      , 0xf1f8, 0x3068},
		{&&op_movea_16_ix      , 0xf1f8, 0x3070},
		{&&op_move_16_ai_d     , 0xf1f8, 0x3080},
		{&&op_move_16_ai_a     , 0xf1f8, 0x3088},
		{&&op_move_16_ai_ai    , 0xf1f8, 0x3090},
		{&&op_move_16_ai_pi    , 0xf1f8, 0x3098},
		{&&op_move_16_ai_pd    , 0xf1f8, 0x30a0},
		{&&op_move_16_ai_di    , 0xf1f8, 0x30a8},
		{&&op_move_16_ai_ix    , 0xf1f8, 0x30b0},
		{&&op_move_16_pi_d     , 0xf1f8, 0x30c0},
		{&&op_move_16_pi_a     , 0xf1f8, 0x30c8},
		{&&op_move_16_pi_ai    , 0xf1f8, 0x30d0},
		{&&op_move_16_pi_pi    , 0xf1f8, 0x30d8},
		{&&op_move_16_pi_pd    , 0xf1f8, 0x30e0},
		{&&op_move_16_pi_di    , 0xf1f8, 0x30e8},
		{&&op_move_16_pi_ix    , 0xf1f8, 0x30f0},
		{&&op_move_16_pd_d     , 0xf1f8, 0x3100},
		{&&op_move_16_pd_a     , 0xf1f8, 0x3108},
		{&&op_move_16_pd_ai    , 0xf1f8, 0x3110},
		{&&op_move_16_pd_pi    , 0xf1f8, 0x3118},
		{&&op_move_16_pd_pd    , 0xf1f8, 0x3120},
		{&&op_move_16_pd_di    , 0xf1f8, 0x3128},
		{&&op_move_16_pd_ix    , 0xf1f8, 0x3130},
		{&&op_move_16_di_d     , 0xf1f8, 0x3140},
		{&&op_move_16_di_a     , 0xf1f8, 0x3148},
		{&&op_move_16_di_ai    , 0xf1f8, 0x3150},
		{&&op_move_16_di_pi    , 0xf1f8, 0x3158},
		{&&op_move_16_di_pd    , 0xf1f8, 0x3160},
		{&&op_move_16_di_di    , 0xf1f8, 0x3168},
		{&&op_move_16_di_ix    , 0xf1f8, 0x3170},
		{&&op_move_16_ix_d     , 0xf1f8, 0x3180},
		{&&op_move_16_ix_a     , 0xf1f8, 0x3188},
		{&&op_move_16_ix_ai    , 0xf1f8, 0x3190},
		{&&op_move_16_ix_pi    , 0xf1f8, 0x3198},
		{&&op_move_16_ix_pd    , 0xf1f8, 0x31a0},
		{&&op_move_16_ix_di    , 0xf1f8, 0x31a8},
		{&&op_move_16_ix_ix    , 0xf1f8, 0x31b0},
		{&&op_chk_16_d         , 0xf1f8, 0x4180},
		{&&op_chk_16_ai        , 0xf1f8, 0x4190},
		{&&op_chk_16_pi        , 0xf1f8, 0x4198},
		{&&op_chk_16_pd        , 0xf1f8, 0x41a0},
		{&&op_chk_16_di        , 0xf1f8, 0x41a8},
		{&&op_chk_16_ix        , 0xf1f8, 0x41b0},
		{&&op_lea_32_ai        , 0xf1f8, 0x41d0},
		{&&op_lea_32_di        , 0xf1f8, 0x41e8},
		{&&op_lea_32_ix        , 0xf1f8, 0x41f0},
		{&&op_addq_8_d         , 0xf1f8, 0x5000},
		{&&op_addq_8_ai        , 0xf1f8, 0x5010},
		{&&op_addq_8_pi        , 0xf1f8, 0x5018},
		{&&op_addq_8_pd        , 0xf1f8, 0x5020},
		{&&op_addq_8_di        , 0xf1f8, 0x5028},
		{&&op_addq_8_ix        , 0xf1f8, 0x5030},
		{&&op_addq_16_d        , 0xf1f8, 0x5040},
		{&&op_addq_16_a        , 0xf1f8, 0x5048},
		{&&op_addq_16_ai       , 0xf1f8, 0x5050},
		{&&op_addq_16_pi       , 0xf1f8, 0x5058},
		{&&op_addq_16_pd       , 0xf1f8, 0x5060},
		{&&op_addq_16_di       , 0xf1f8, 0x5068},
		{&&op_addq_16_ix       , 0xf1f8, 0x5070},
		{&&op_addq_32_d        , 0xf1f8, 0x5080},
		{&&op_addq_32_a        , 0xf1f8, 0x5088},
		{&&op_addq_32_ai       , 0xf1f8, 0x5090},
		{&&op_addq_32_pi       , 0xf1f8, 0x5098},
		{&&op_addq_32_pd       , 0xf1f8, 0x50a0},
		{&&op_addq_32_di       , 0xf1f8, 0x50a8},
		{&&op_addq_32_ix       , 0xf1f8, 0x50b0},
		{&&op_subq_8_d         , 0xf1f8, 0x5100},
		{&&op_subq_8_ai        , 0xf1f8, 0x5110},
		{&&op_subq_8_pi        , 0xf1f8, 0x5118},
		{&&op_subq_8_pd        , 0xf1f8, 0x5120},
		{&&op_subq_8_di        , 0xf1f8, 0x5128},
		{&&op_subq_8_ix        , 0xf1f8, 0x5130},
		{&&op_subq_16_d        , 0xf1f8, 0x5140},
		{&&op_subq_16_a        , 0xf1f8, 0x5148},
		{&&op_subq_16_ai       , 0xf1f8, 0x5150},
		{&&op_subq_16_pi       , 0xf1f8, 0x5158},
		{&&op_subq_16_pd       , 0xf1f8, 0x5160},
		{&&op_subq_16_di       , 0xf1f8, 0x5168},
		{&&op_subq_16_ix       , 0xf1f8, 0x5170},
		{&&op_subq_32_d        , 0xf1f8, 0x5180},
		{&&op_subq_32_a        , 0xf1f8, 0x5188},
		{&&op_subq_32_ai       , 0xf1f8, 0x5190},
		{&&op_subq_32_pi       , 0xf1f8, 0x5198},
		{&&op_subq_32_pd       , 0xf1f8, 0x51a0},
		{&&op_subq_32_di       , 0xf1f8, 0x51a8},
		{&&op_subq_32_ix       , 0xf1f8, 0x51b0},
		{&&op_or_8_er_d        , 0xf1f8, 0x8000},
		{&&op_or_8_er_ai       , 0xf1f8, 0x8010},
		{&&op_or_8_er_pi       , 0xf1f8, 0x8018},
		{&&op_or_8_er_pd       , 0xf1f8, 0x8020},
		{&&op_or_8_er_di       , 0xf1f8, 0x8028},
		{&&op_or_8_er_ix       , 0xf1f8, 0x8030},
		{&&op_or_16_er_d       , 0xf1f8, 0x8040},
		{&&op_or_16_er_ai      , 0xf1f8, 0x8050},
		{&&op_or_16_er_pi      , 0xf1f8, 0x8058},
		{&&op_or_16_er_pd      , 0xf1f8, 0x8060},
		{&&op_or_16_er_di      , 0xf1f8, 0x8068},
		{&&op_or_16_er_ix      , 0xf1f8, 0x8070},
		{&&op_or_32_er_d       , 0xf1f8, 0x8080},
		{&&op_or_32_er_ai      , 0xf1f8, 0x8090},
		{&&op_or_32_er_pi      , 0xf1f8, 0x8098},
		{&&op_or_32_er_pd      , 0xf1f8, 0x80a0},
		{&&op_or_32_er_di      , 0xf1f8, 0x80a8},
		{&&op_or_32_er_ix      , 0xf1f8, 0x80b0},
		{&&op_divu_16_d        , 0xf1f8, 0x80c0},
		{&&op_divu_16_ai       , 0xf1f8, 0x80d0},
		{&&op_divu_16_pi       , 0xf1f8, 0x80d8},
		{&&op_divu_16_pd       , 0xf1f8, 0x80e0},
		{&&op_divu_16_di       , 0xf1f8, 0x80e8},
		{&&op_divu_16_ix       , 0xf1f8, 0x80f0},
		{&&op_sbcd_8_rr        , 0xf1f8, 0x8100},
		{&&op_sbcd_8_mm        , 0xf1f8, 0x8108},
		{&&op_or_8_re_ai       , 0xf1f8, 0x8110},
		{&&op_or_8_re_pi       , 0xf1f8, 0x8118},
		{&&op_or_8_re_pd       , 0xf1f8, 0x8120},
		{&&op_or_8_re_di       , 0xf1f8, 0x8128},
		{&&op_or_8_re_ix       , 0xf1f8, 0x8130},
		{&&op_or_16_re_ai      , 0xf1f8, 0x8150},
		{&&op_or_16_re_pi      , 0xf1f8, 0x8158},
		{&&op_or_16_re_pd      , 0xf1f8, 0x8160},
		{&&op_or_16_re_di      , 0xf1f8, 0x8168},
		{&&op_or_16_re_ix      , 0xf1f8, 0x8170},
		{&&op_or_32_re_ai      , 0xf1f8, 0x8190},
		{&&op_or_32_re_pi      , 0xf1f8, 0x8198},
		{&&op_or_32_re_pd      , 0xf1f8, 0x81a0},
		{&&op_or_32_re_di      , 0xf1f8, 0x81a8},
		{&&op_or_32_re_ix      , 0xf1f8, 0x81b0},
		{&&op_divs_16_d        , 0xf1f8, 0x81c0},
		{&&op_divs_16_ai       , 0xf1f8, 0x81d0},
		{&&op_divs_16_pi       , 0xf1f8, 0x81d8},
		{&&op_divs_16_pd       , 0xf1f8, 0x81e0},
		{&&op_divs_16_di       , 0xf1f8, 0x81e8},
		{&&op_divs_16_ix       , 0xf1f8, 0x81f0},
		{&&op_sub_8_er_d       , 0xf1f8, 0x9000},
		{&&op_sub_8_er_ai      , 0xf1f8, 0x9010},
		{&&op_sub_8_er_pi      , 0xf1f8, 0x9018},
		{&&op_sub_8_er_pd      , 0xf1f8, 0x9020},
		{&&op_sub_8_er_di      , 0xf1f8, 0x9028},
		{&&op_sub_8_er_ix      , 0xf1f8, 0x9030},
		{&&op_sub_16_er_d      , 0xf1f8, 0x9040},
		{&&op_sub_16_er_a      , 0xf1f8, 0x9048},
		{&&op_sub_16_er_ai     , 0xf1f8, 0x9050},
		{&&op_sub_16_er_pi     , 0xf1f8, 0x9058},
		{&&op_sub_16_er_pd     , 0xf1f8, 0x9060},
		{&&op_sub_16_er_di     , 0xf1f8, 0x9068},
		{&&op_sub_16_er_ix     , 0xf1f8, 0x9070},
		{&&op_sub_32_er_d      , 0xf1f8, 0x9080},
		{&&op_sub_32_er_a      , 0xf1f8, 0x9088},
		{&&op_sub_32_er_ai     , 0xf1f8, 0x9090},
		{&&op_sub_32_er_pi     , 0xf1f8, 0x9098},
		{&&op_sub_32_er_pd     , 0xf1f8, 0x90a0},
		{&&op_sub_32_er_di     , 0xf1f8, 0x90a8},
		{&&op_sub_32_er_ix     , 0xf1f8, 0x90b0},
		{&&op_suba_16_d        , 0xf1f8, 0x90c0},
		{&&op_suba_16_a        , 0xf1f8, 0x90c8},
		{&&op_suba_16_ai       , 0xf1f8, 0x90d0},
		{&&op_suba_16_pi       , 0xf1f8, 0x90d8},
		{&&op_suba_16_pd       , 0xf1f8, 0x90e0},
		{&&op_suba_16_di       , 0xf1f8, 0x90e8},
		{&&op_suba_16_ix       , 0xf1f8, 0x90f0},
		{&&op_subx_8_rr        , 0xf1f8, 0x9100},
		{&&op_subx_8_mm        , 0xf1f8, 0x9108},
		{&&op_sub_8_re_ai      , 0xf1f8, 0x9110},
		{&&op_sub_8_re_pi      , 0xf1f8, 0x9118},
		{&&op_sub_8_re_pd      , 0xf1f8, 0x9120},
		{&&op_sub_8_re_di      , 0xf1f8, 0x9128},
		{&&op_sub_8_re_ix      , 0xf1f8, 0x9130},
		{&&op_subx_16_rr       , 0xf1f8, 0x9140},
		{&&op_subx_16_mm       , 0xf1f8, 0x9148},
		{&&op_sub_16_re_ai     , 0xf1f8, 0x9150},
		{&&op_sub_16_re_pi     , 0xf1f8, 0x9158},
		{&&op_sub_16_re_pd     , 0xf1f8, 0x9160},
		{&&op_sub_16_re_di     , 0xf1f8, 0x9168},
		{&&op_sub_16_re_ix     , 0xf1f8, 0x9170},
		{&&op_subx_32_rr       , 0xf1f8, 0x9180},
		{&&op_subx_32_mm       , 0xf1f8, 0x9188},
		{&&op_sub_32_re_ai     , 0xf1f8, 0x9190},
		{&&op_sub_32_re_pi     , 0xf1f8, 0x9198},
		{&&op_sub_32_re_pd     , 0xf1f8, 0x91a0},
		{&&op_sub_32_re_di     , 0xf1f8, 0x91a8},
		{&&op_sub_32_re_ix     , 0xf1f8, 0x91b0},
		{&&op_suba_32_d        , 0xf1f8, 0x91c0},
		{&&op_suba_32_a        , 0xf1f8, 0x91c8},
		{&&op_suba_32_ai       , 0xf1f8, 0x91d0},
		{&&op_suba_32_pi       , 0xf1f8, 0x91d8},
		{&&op_suba_32_pd       , 0xf1f8, 0x91e0},
		{&&op_suba_32_di       , 0xf1f8, 0x91e8},
		{&&op_suba_32_ix       , 0xf1f8, 0x91f0},
		{&&op_cmp_8_d          , 0xf1f8, 0xb000},
		{&&op_cmp_8_ai         , 0xf1f8, 0xb010},
		{&&op_cmp_8_pi         , 0xf1f8, 0xb018},
		{&&op_cmp_8_pd         , 0xf1f8, 0xb020},
		{&&op_cmp_8_di         , 0xf1f8, 0xb028},
		{&&op_cmp_8_ix         , 0xf1f8, 0xb030},
		{&&op_cmp_16_d         , 0xf1f8, 0xb040},
		{&&op_cmp_16_a         , 0xf1f8, 0xb048},
		{&&op_cmp_16_ai        , 0xf1f8, 0xb050},
		{&&op_cmp_16_pi        , 0xf1f8, 0xb058},
		{&&op_cmp_16_pd        , 0xf1f8, 0xb060},
		{&&op_cmp_16_di        , 0xf1f8, 0xb068},
		{&&op_cmp_16_ix        , 0xf1f8, 0xb070},
		{&&op_cmp_32_d         , 0xf1f8, 0xb080},
		{&&op_cmp_32_a         , 0xf1f8, 0xb088},
		{&&op_cmp_32_ai        , 0xf1f8, 0xb090},
		{&&op_cmp_32_pi        , 0xf1f8, 0xb098},
		{&&op_cmp_32_pd        , 0xf1f8, 0xb0a0},
		{&&op_cmp_32_di        , 0xf1f8, 0xb0a8},
		{&&op_cmp_32_ix        , 0xf1f8, 0xb0b0},
		{&&op_cmpa_16_d        , 0xf1f8, 0xb0c0},
		{&&op_cmpa_16_a        , 0xf1f8, 0xb0c8},
		{&&op_cmpa_16_ai       , 0xf1f8, 0xb0d0},
		{&&op_cmpa_16_pi       , 0xf1f8, 0xb0d8},
		{&&op_cmpa_16_pd       , 0xf1f8, 0xb0e0},
		{&&op_cmpa_16_di       , 0xf1f8, 0xb0e8},
		{&&op_cmpa_16_ix       , 0xf1f8, 0xb0f0},
		{&&op_eor_8_d          , 0xf1f8, 0xb100},
		{&&op_cmpm_8           , 0xf1f8, 0xb108},
		{&&op_eor_8_ai         , 0xf1f8, 0xb110},
		{&&op_eor_8_pi         , 0xf1f8, 0xb118},
		{&&op_eor_8_pd         , 0xf1f8, 0xb120},
		{&&op_eor_8_di         , 0xf1f8, 0xb128},
		{&&op_eor_8_ix         , 0xf1f8, 0xb130},
		{&&op_eor_16_d         , 0xf1f8, 0xb140},
		{&&op_cmpm_16          , 0xf1f8, 0xb148},
		{&&op_eor_16_ai        , 0xf1f8, 0xb150},
		{&&op_eor_16_pi        , 0xf1f8, 0xb158},
		{&&op_eor_16_pd        , 0xf1f8, 0xb160},
		{&&op_eor_16_di        , 0xf1f8, 0xb168},
		{&&op_eor_16_ix        , 0xf1f8, 0xb170},
		{&&op_eor_32_d         , 0xf1f8, 0xb180},
		{&&op_cmpm_32          , 0xf1f8, 0xb188},
		{&&op_eor_32_ai        , 0xf1f8, 0xb190},
		{&&op_eor_32_pi        , 0xf1f8, 0xb198},
		{&&op_eor_32_pd        , 0xf1f8, 0xb1a0},
		{&&op_eor_32_di        , 0xf1f8, 0xb1a8},
		{&&op_eor_32_ix        , 0xf1f8, 0xb1b0},
		{&&op_cmpa_32_d        , 0xf1f8, 0xb1c0},
		{&&op_cmpa_32_a        , 0xf1f8, 0xb1c8},
		{&&op_cmpa_32_ai       , 0xf1f8, 0xb1d0},
		{&&op_cmpa_32_pi       , 0xf1f8, 0xb1d8},
		{&&op_cmpa_32_pd       , 0xf1f8, 0xb1e0},
		{&&op_cmpa_32_di       , 0xf1f8, 0xb1e8},
		{&&op_cmpa_32_ix       , 0xf1f8, 0xb1f0},
		{&&op_and_8_er_d       , 0xf1f8, 0xc000},
		{&&op_and_8_er_ai      , 0xf1f8, 0xc010},
		{&&op_and_8_er_pi      , 0xf1f8, 0xc018},
		{&&op_and_8_er_pd      , 0xf1f8, 0xc020},
		{&&op_and_8_er_di      , 0xf1f8, 0xc028},
		{&&op_and_8_er_ix      , 0xf1f8, 0xc030},
		{&&op_and_16_er_d      , 0xf1f8, 0xc040},
		{&&op_and_16_er_ai     , 0xf1f8, 0xc050},
		{&&op_and_16_er_pi     , 0xf1f8, 0xc058},
		{&&op_and_16_er_pd     , 0xf1f8, 0xc060},
		{&&op_and_16_er_di     , 0xf1f8, 0xc068},
		{&&op_and_16_er_ix     , 0xf1f8, 0xc070},
		{&&op_and_32_er_d      , 0xf1f8, 0xc080},
		{&&op_and_32_er_ai     , 0xf1f8, 0xc090},
		{&&op_and_32_er_pi     , 0xf1f8, 0xc098},
		{&&op_and_32_er_pd     , 0xf1f8, 0xc0a0},
		{&&op_and_32_er_di     , 0xf1f8, 0xc0a8},
		{&&op_and_32_er_ix     , 0xf1f8, 0xc0b0},
		{&&op_mulu_16_d        , 0xf1f8, 0xc0c0},
		{&&op_mulu_16_ai       , 0xf1f8, 0xc0d0},
		{&&op_mulu_16_pi       , 0xf1f8, 0xc0d8},
		{&&op_mulu_16_pd       , 0xf1f8, 0xc0e0},
		{&&op_mulu_16_di       , 0xf1f8, 0xc0e8},
		{&&op_mulu_16_ix       , 0xf1f8, 0xc0f0},
		{&&op_abcd_8_rr        , 0xf1f8, 0xc100},
		{&&op_abcd_8_mm        , 0xf1f8, 0xc108},
		{&&op_and_8_re_ai      , 0xf1f8, 0xc110},
		{&&op_and_8_re_pi      , 0xf1f8, 0xc118},
		{&&op_and_8_re_pd      , 0xf1f8, 0xc120},
		{&&op_and_8_re_di      , 0xf1f8, 0xc128},
		{&&op_and_8_re_ix      , 0xf1f8, 0xc130},
		{&&op_exg_32_dd        , 0xf1f8, 0xc140},
		{&&op_exg_32_aa        , 0xf1f8, 0xc148},
		{&&op_and_16_re_ai     , 0xf1f8, 0xc150},
		{&&op_and_16_re_pi     , 0xf1f8, 0xc158},
		{&&op_and_16_re_pd     , 0xf1f8, 0xc160},
		{&&op_and_16_re_di     , 0xf1f8, 0xc168},
		{&&op_and_16_re_ix     , 0xf1f8, 0xc170},
		{&&op_exg_32_da        , 0xf1f8, 0xc188},
		{&&op_and_32_re_ai     , 0xf1f8, 0xc190},
		{&&op_and_32_re_pi     , 0xf1f8, 0xc198},
		{&&op_and_32_re_pd     , 0xf1f8, 0xc1a0},
		{&&op_and_32_re_di     , 0xf1f8, 0xc1a8},
		{&&op_and_32_re_ix     , 0xf1f8, 0xc1b0},
		{&&op_muls_16_d        , 0xf1f8, 0xc1c0},
		{&&op_muls_16_ai       , 0xf1f8, 0xc1d0},
		{&&op_muls_16_pi       , 0xf1f8, 0xc1d8},
		{&&op_muls_16_pd       , 0xf1f8, 0xc1e0},
		{&&op_muls_16_di       , 0xf1f8, 0xc1e8},
		{&&op_muls_16_ix       , 0xf1f8, 0xc1f0},
		{&&op_add_8_er_d       , 0xf1f8, 0xd000},
		{&&op_add_8_er_ai      , 0xf1f8, 0xd010},
		{&&op_add_8_er_pi      , 0xf1f8, 0xd018},
		{&&op_add_8_er_pd      , 0xf1f8, 0xd020},
		{&&op_add_8_er_di      , 0xf1f8, 0xd028},
		{&&op_add_8_er_ix      , 0xf1f8, 0xd030},
		{&&op_add_16_er_d      , 0xf1f8, 0xd040},
		{&&op_add_16_er_a      , 0xf1f8, 0xd048},
		{&&op_add_16_er_ai     , 0xf1f8, 0xd050},
		{&&op_add_16_er_pi     , 0xf1f8, 0xd058},
		{&&op_add_16_er_pd     , 0xf1f8, 0xd060},
		{&&op_add_16_er_di     , 0xf1f8, 0xd068},
		{&&op_add_16_er_ix     , 0xf1f8, 0xd070},
		{&&op_add_32_er_d      , 0xf1f8, 0xd080},
		{&&op_add_32_er_a      , 0xf1f8, 0xd088},
		{&&op_add_32_er_ai     , 0xf1f8, 0xd090},
		{&&op_add_32_er_pi     , 0xf1f8, 0xd098},
		{&&op_add_32_er_pd     , 0xf1f8, 0xd0a0},
		{&&op_add_32_er_di     , 0xf1f8, 0xd0a8},
		{&&op_add_32_er_ix     , 0xf1f8, 0xd0b0},
		{&&op_adda_16_d        , 0xf1f8, 0xd0c0},
		{&&op_adda_16_a        , 0xf1f8, 0xd0c8},
		{&&op_adda_16_ai       , 0xf1f8, 0xd0d0},
		{&&op_adda_16_pi       , 0xf1f8, 0xd0d8},
		{&&op_adda_16_pd       , 0xf1f8, 0xd0e0},
		{&&op_adda_16_di       , 0xf1f8, 0xd0e8},
		{&&op_adda_16_ix       , 0xf1f8, 0xd0f0},
		{&&op_addx_8_rr        , 0xf1f8, 0xd100},
		{&&op_addx_8_mm        , 0xf1f8, 0xd108},
		{&&op_add_8_re_ai      , 0xf1f8, 0xd110},
		{&&op_add_8_re_pi      , 0xf1f8, 0xd118},
		{&&op_add_8_re_pd      , 0xf1f8, 0xd120},
		{&&op_add_8_re_di      , 0xf1f8, 0xd128},
		{&&op_add_8_re_ix      , 0xf1f8, 0xd130},
		{&&op_addx_16_rr       , 0xf1f8, 0xd140},
		{&&op_addx_16_mm       , 0xf1f8, 0xd148},
		{&&op_add_16_re_ai     , 0xf1f8, 0xd150},
		{&&op_add_16_re_pi     , 0xf1f8, 0xd158},
		{&&op_add_16_re_pd     , 0xf1f8, 0xd160},
		{&&op_add_16_re_di     , 0xf1f8, 0xd168},
		{&&op_add_16_re_ix     , 0xf1f8, 0xd170},
		{&&op_addx_32_rr       , 0xf1f8, 0xd180},
		{&&op_addx_32_mm       , 0xf1f8, 0xd188},
		{&&op_add_32_re_ai     , 0xf1f8, 0xd190},
		{&&op_add_32_re_pi     , 0xf1f8, 0xd198},
		{&&op_add_32_re_pd     , 0xf1f8, 0xd1a0},
		{&&op_add_32_re_di     , 0xf1f8, 0xd1a8},
		{&&op_add_32_re_ix     , 0xf1f8, 0xd1b0},
		{&&op_adda_32_d        , 0xf1f8, 0xd1c0},
		{&&op_adda_32_a        , 0xf1f8, 0xd1c8},
		{&&op_adda_32_ai       , 0xf1f8, 0xd1d0},
		{&&op_adda_32_pi       , 0xf1f8, 0xd1d8},
		{&&op_adda_32_pd       , 0xf1f8, 0xd1e0},
		{&&op_adda_32_di       , 0xf1f8, 0xd1e8},
		{&&op_adda_32_ix       , 0xf1f8, 0xd1f0},
		{&&op_asr_8_s          , 0xf1f8, 0xe000},
		{&&op_lsr_8_s          , 0xf1f8, 0xe008},
		{&&op_roxr_8_s         , 0xf1f8, 0xe010},
		{&&op_ror_8_s          , 0xf1f8, 0xe018},
		{&&op_asr_8_r          , 0xf1f8, 0xe020},
		{&&op_lsr_8_r          , 0xf1f8, 0xe028},
		{&&op_roxr_8_r         , 0xf1f8, 0xe030},
		{&&op_ror_8_r          , 0xf1f8, 0xe038},
		{&&op_asr_16_s         , 0xf1f8, 0xe040},
		{&&op_lsr_16_s         , 0xf1f8, 0xe048},
		{&&op_roxr_16_s        , 0xf1f8, 0xe050},
		{&&op_ror_16_s         , 0xf1f8, 0xe058},
		{&&op_asr_16_r         , 0xf1f8, 0xe060},
		{&&op_lsr_16_r         , 0xf1f8, 0xe068},
		{&&op_roxr_16_r        , 0xf1f8, 0xe070},
		{&&op_ror_16_r         , 0xf1f8, 0xe078},
		{&&op_asr_32_s         , 0xf1f8, 0xe080},
		{&&op_lsr_32_s         , 0xf1f8, 0xe088},
		{&&op_roxr_32_s        , 0xf1f8, 0xe090},
		{&&op_ror_32_s         , 0xf1f8, 0xe098},
		{&&op_asr_32_r         , 0xf1f8, 0xe0a0},
		{&&op_lsr_32_r         , 0xf1f8, 0xe0a8},
		{&&op_roxr_32_r        , 0xf1f8, 0xe0b0},
		{&&op_ror_32_r         , 0xf1f8, 0xe0b8},
		{&&op_asl_8_s          , 0xf1f8, 0xe100},
		{&&op_lsl_8_s          , 0xf1f8, 0xe108},
		{&&op_roxl_8_s         , 0xf1f8, 0xe110},
		{&&op_rol_8_s          , 0xf1f8, 0xe118},
		{&&op_asl_8_r          , 0xf1f8, 0xe120},
		{&&op_lsl_8_r          , 0xf1f8, 0xe128},
		{&&op_roxl_8_r         , 0xf1f8, 0xe130},
		{&&op_rol_8_r          , 0xf1f8, 0xe138},
		{&&op_asl_16_s         , 0xf1f8, 0xe140},
		{&&op_lsl_16_s         , 0xf1f8, 0xe148},
		{&&op_roxl_16_s        , 0xf1f8, 0xe150},
		{&&op_rol_16_s         , 0xf1f8, 0xe158},
		{&&op_asl_16_r         , 0xf1f8, 0xe160},
		{&&op_lsl_16_r         , 0xf1f8, 0xe168},
		{&&op_roxl_16_r        , 0xf1f8, 0xe170},
		{&&op_rol_16_r         , 0xf1f8, 0xe178},
		{&&op_asl_32_s         , 0xf1f8, 0xe180},
		{&&op_lsl_32_s         , 0xf1f8, 0xe188},
		{&&op_roxl_32_s        , 0xf1f8, 0xe190},
		{&&op_rol_32_s         , 0xf1f8, 0xe198},
		{&&op_asl_32_r         , 0xf1f8, 0xe1a0},
		{&&op_lsl_32_r         , 0xf1f8, 0xe1a8},
		{&&op_roxl_32_r        , 0xf1f8, 0xe1b0},
		{&&op_rol_32_r         , 0xf1f8, 0xe1b8},
		{&&op_trap             , 0xfff0, 0x4e40},
		{&&op_btst_8_r_pi7     , 0xf1ff, 0x011f},
		{&&op_btst_8_r_pd7     , 0xf1ff, 0x0127},
		{&&op_btst_8_r_aw      , 0xf1ff, 0x0138},
		{&&op_btst_8_r_al      , 0xf1ff, 0x0139},
		{&&op_btst_8_r_pcdi    , 0xf1ff, 0x013a},
		{&&op_btst_8_r_pcix    , 0xf1ff, 0x013b},
		{&&op_btst_8_r_i       , 0xf1ff, 0x013c},
		{&&op_bchg_8_r_pi7     , 0xf1ff, 0x015f},
		{&&op_bchg_8_r_pd7     , 0xf1ff, 0x0167},
		{&&op_bchg_8_r_aw      , 0xf1ff, 0x0178},
		{&&op_bchg_8_r_al      , 0xf1ff, 0x0179},
		{&&op_bclr_8_r_pi7     , 0xf1ff, 0x019f},
		{&&op_bclr_8_r_pd7     , 0xf1ff, 0x01a7},
		{&&op_bclr_8_r_aw      , 0xf1ff, 0x01b8},
		{&&op_bclr_8_r_al      , 0xf1ff, 0x01b9},
		{&&op_bset_8_r_pi7     , 0xf1ff, 0x01df},
		{&&op_bset_8_r_pd7     , 0xf1ff, 0x01e7},
		{&&op_bset_8_r_aw      , 0xf1ff, 0x01f8},
		{&&op_bset_8_r_al      , 0xf1ff, 0x01f9},
		{&&op_move_8_d_pi7     , 0xf1ff, 0x101f},
		{&&op_move_8_d_pd7     , 0xf1ff, 0x1027},
		{&&op_move_8_d_aw      , 0xf1ff, 0x1038},
		{&&op_move_8_d_al      , 0xf1ff, 0x1039},
		{&&op_move_8_d_pcdi    , 0xf1ff, 0x103a},
		{&&op_move_8_d_pcix    , 0xf1ff, 0x103b},
		{&&op_move_8_d_i       , 0xf1ff, 0x103c},
		{&&op_move_8_ai_pi7    , 0xf1ff, 0x109f},
		{&&op_move_8_ai_pd7    , 0xf1ff, 0x10a7},
		{&&op_move_8_ai_aw     , 0xf1ff, 0x10b8},
		{&&op_move_8_ai_al     , 0xf1ff, 0x10b9},
		{&&op_move_8_ai_pcdi   , 0xf1ff, 0x10ba},
		{&&op_move_8_ai_pcix   , 0xf1ff, 0x10bb},
		{&&op_move_8_ai_i      , 0xf1ff, 0x10bc},
		{&&op_move_8_pi_pi7    , 0xf1ff, 0x10df},
		{&&op_move_8_pi_pd7    , 0xf1ff, 0x10e7},
		{&&op_move_8_pi_aw     , 0xf1ff, 0x10f8},
		{&&op_move_8_pi_al     , 0xf1ff, 0x10f9},
		{&&op_move_8_pi_pcdi   , 0xf1ff, 0x10fa},
		{&&op_move_8_pi_pcix   , 0xf1ff, 0x10fb},
		{&&op_move_8_pi_i      , 0xf1ff, 0x10fc},
		{&&op_move_8_pd_pi7    , 0xf1ff, 0x111f},
		{&&op_move_8_pd_pd7    , 0xf1ff, 0x1127},
		{&&op_move_8_pd_aw     , 0xf1ff, 0x1138},
		{&&op_move_8_pd_al     , 0xf1ff, 0x1139},
		{&&op_move_8_pd_pcdi   , 0xf1ff, 0x113a},
		{&&op_move_8_pd_pcix   , 0xf1ff, 0x113b},
		{&&op_move_8_pd_i      , 0xf1ff, 0x113c},
		{&&op_move_8_di_pi7    , 0xf1ff, 0x115f},
		{&&op_move_8_di_pd7    , 0xf1ff, 0x1167},
		{&&op_move_8_di_aw     , 0xf1ff, 0x1178},
		{&&op_move_8_di_al     , 0xf1ff, 0x1179},
		{&&op_move_8_di_pcdi   , 0xf1ff, 0x117a},
		{&&op_move_8_di_pcix   , 0xf1ff, 0x117b},
		{&&op_move_8_di_i      , 0xf1ff, 0x117c},
		{&&op_move_8_ix_pi7    , 0xf1ff, 0x119f},
		{&&op_move_8_ix_pd7    , 0xf1ff, 0x11a7},
		{&&op_move_8_ix_aw     , 0xf1ff, 0x11b8},
		{&&op_move_8_ix_al     , 0xf1ff, 0x11b9},
		{&&op_move_8_ix_pcdi   , 0xf1ff, 0x11ba},
		{&&op_move_8_ix_pcix   , 0xf1ff, 0x11bb},
		{&&op_move_8_ix_i      , 0xf1ff, 0x11bc},
		{&&op_move_32_d_aw     , 0xf1ff, 0x2038},
		{&&op_move_32_d_al     , 0xf1ff, 0x2039},
		{&&op_move_32_d_pcdi   , 0xf1ff, 0x203a},
		{&&op_move_32_d_pcix   , 0xf1ff, 0x203b},
		{&&op_move_32_d_i      , 0xf1ff, 0x203c},
		{&&op_movea_32_aw      , 0xf1ff, 0x2078},
		{&&op_movea_32_al      , 0xf1ff, 0x2079},
		{&&op_movea_32_pcdi    , 0xf1ff, 0x207a},
		{&&op_movea_32_pcix    , 0xf1ff, 0x207b},
		{&&op_movea_32_i       , 0xf1ff, 0x207c},
		{&&op_move_32_ai_aw    , 0xf1ff, 0x20b8},
		{&&op_move_32_ai_al    , 0xf1ff, 0x20b9},
		{&&op_move_32_ai_pcdi  , 0xf1ff, 0x20ba},
		{&&op_move_32_ai_pcix  , 0xf1ff, 0x20bb},
		{&&op_move_32_ai_i     , 0xf1ff, 0x20bc},
		{&&op_move_32_pi_aw    , 0xf1ff, 0x20f8},
		{&&op_move_32_pi_al    , 0xf1ff, 0x20f9},
		{&&op_move_32_pi_pcdi  , 0xf1ff, 0x20fa},
		{&&op_move_32_pi_pcix  , 0xf1ff, 0x20fb},
		{&&op_move_32_pi_i     , 0xf1ff, 0x20fc},
		{&&op_move_32_pd_aw    , 0xf1ff, 0x2138},
		{&&op_move_32_pd_al    , 0xf1ff, 0x2139},
		{&&op_move_32_pd_pcdi  , 0xf1ff, 0x213a},
		{&&op_move_32_pd_pcix  , 0xf1ff, 0x213b},
		{&&op_move_32_pd_i     , 0xf1ff, 0x213c},
		{&&op_move_32_di_aw    , 0xf1ff, 0x2178},
		{&&op_move_32_di_al    , 0xf1ff, 0x2179},
		{&&op_move_32_di_pcdi  , 0xf1ff, 0x217a},
		{&&op_move_32_di_pcix  , 0xf1ff, 0x217b},
		{&&op_move_32_di_i     , 0xf1ff, 0x217c},
		{&&op_move_32_ix_aw    , 0xf1ff, 0x21b8},
		{&&op_move_32_ix_al    , 0xf1ff, 0x21b9},
		{&&op_move_32_ix_pcdi  , 0xf1ff, 0x21ba},
		{&&op_move_32_ix_pcix  , 0xf1ff, 0x21bb},
		{&&op_move_32_ix_i     , 0xf1ff, 0x21bc},
		{&&op_move_16_d_aw     , 0xf1ff, 0x3038},
		{&&op_move_16_d_al     , 0xf1ff, 0x3039},
		{&&op_move_16_d_pcdi   , 0xf1ff, 0x303a},
		{&&op_move_16_d_pcix   , 0xf1ff, 0x303b},
		{&&op_move_16_d_i      , 0xf1ff, 0x303c},
		{&&op_movea_16_aw      , 0xf1ff, 0x3078},
		{&&op_movea_16_al      , 0xf1ff, 0x3079},
		{&&op_movea_16_pcdi    , 0xf1ff, 0x307a},
		{&&op_movea_16_pcix    , 0xf1ff, 0x307b},
		{&&op_movea_16_i       , 0xf1ff, 0x307c},
		{&&op_move_16_ai_aw    , 0xf1ff, 0x30b8},
		{&&op_move_16_ai_al    , 0xf1ff, 0x30b9},
		{&&op_move_16_ai_pcdi  , 0xf1ff, 0x30ba},
		{&&op_move_16_ai_pcix  , 0xf1ff, 0x30bb},
		{&&op_move_16_ai_i     , 0xf1ff, 0x30bc},
		{&&op_move_16_pi_aw    , 0xf1ff, 0x30f8},
		{&&op_move_16_pi_al    , 0xf1ff, 0x30f9},
		{&&op_move_16_pi_pcdi  , 0xf1ff, 0x30fa},
		{&&op_move_16_pi_pcix  , 0xf1ff, 0x30fb},
		{&&op_move_16_pi_i     , 0xf1ff, 0x30fc},
		{&&op_move_16_pd_aw    , 0xf1ff, 0x3138},
		{&&op_move_16_pd_al    , 0xf1ff, 0x3139},
		{&&op_move_16_pd_pcdi  , 0xf1ff, 0x313a},
		{&&op_move_16_pd_pcix  , 0xf1ff, 0x313b},
		{&&op_move_16_pd_i     , 0xf1ff, 0x313c},
		{&&op_move_16_di_aw    , 0xf1ff, 0x3178},
		{&&op_move_16_di_al    , 0xf1ff, 0x3179},
		{&&op_move_16_di_pcdi  , 0xf1ff, 0x317a},
		{&&op_move_16_di_pcix  , 0xf1ff, 0x317b},
		{&&op_move_16_di_i     , 0xf1ff, 0x317c},
		{&&op_move_16_ix_aw    , 0xf1ff, 0x31b8},
		{&&op_move_16_ix_al    , 0xf1ff, 0x31b9},
		{&&op_move_16_ix_pcdi  , 0xf1ff, 0x31ba},
		{&&op_move_16_ix_pcix  , 0xf1ff, 0x31bb},
		{&&op_move_16_ix_i     , 0xf1ff, 0x31bc},
		{&&op_chk_16_aw        , 0xf1ff, 0x41b8},
		{&&op_chk_16_al        , 0xf1ff, 0x41b9},
		{&&op_chk_16_pcdi      , 0xf1ff, 0x41ba},
		{&&op_chk_16_pcix      , 0xf1ff, 0x41bb},
		{&&op_chk_16_i         , 0xf1ff, 0x41bc},
		{&&op_lea_32_aw        , 0xf1ff, 0x41f8},
		{&&op_lea_32_al        , 0xf1ff, 0x41f9},
		{&&op_lea_32_pcdi      , 0xf1ff, 0x41fa},
		{&&op_lea_32_pcix      , 0xf1ff, 0x41fb},
		{&&op_addq_8_pi7       , 0xf1ff, 0x501f},
		{&&op_addq_8_pd7       , 0xf1ff, 0x5027},
		{&&op_addq_8_aw        , 0xf1ff, 0x5038},
		{&&op_addq_8_al        , 0xf1ff, 0x5039},
		{&&op_addq_16_aw       , 0xf1ff, 0x5078},
		{&&op_addq_16_al       , 0xf1ff, 0x5079},
		{&&op_addq_32_aw       , 0xf1ff, 0x50b8},
		{&&op_addq_32_al       , 0xf1ff, 0x50b9},
		{&&op_subq_8_pi7       , 0xf1ff, 0x511f},
		{&&op_subq_8_pd7       , 0xf1ff, 0x5127},
		{&&op_subq_8_aw        , 0xf1ff, 0x5138},
		{&&op_subq_8_al        , 0xf1ff, 0x5139},
		{&&op_subq_16_aw       , 0xf1ff, 0x5178},
		{&&op_subq_16_al       , 0xf1ff, 0x5179},
		{&&op_subq_32_aw       , 0xf1ff, 0x51b8},
		{&&op_subq_32_al       , 0xf1ff, 0x51b9},
		{&&op_or_8_er_pi7      , 0xf1ff, 0x801f},
		{&&op_or_8_er_pd7      , 0xf1ff, 0x8027},
		{&&op_or_8_er_aw       , 0xf1ff, 0x8038},
		{&&op_or_8_er_al       , 0xf1ff, 0x8039},
		{&&op_or_8_er_pcdi     , 0xf1ff, 0x803a},
		{&&op_or_8_er_pcix     , 0xf1ff, 0x803b},
		{&&op_or_8_er_i        , 0xf1ff, 0x803c},
		{&&op_or_16_er_aw      , 0xf1ff, 0x8078},
		{&&op_or_16_er_al      , 0xf1ff, 0x8079},
		{&&op_or_16_er_pcdi    , 0xf1ff, 0x807a},
		{&&op_or_16_er_pcix    , 0xf1ff, 0x807b},
		{&&op_or_16_er_i       , 0xf1ff, 0x807c},
		{&&op_or_32_er_aw      , 0xf1ff, 0x80b8},
		{&&op_or_32_er_al      , 0xf1ff, 0x80b9},
		{&&op_or_32_er_pcdi    , 0xf1ff, 0x80ba},
		{&&op_or_32_er_pcix    , 0xf1ff, 0x80bb},
		{&&op_or_32_er_i       , 0xf1ff, 0x80bc},
		{&&op_divu_16_aw       , 0xf1ff, 0x80f8},
		{&&op_divu_16_al       , 0xf1ff, 0x80f9},
		{&&op_divu_16_pcdi     , 0xf1ff, 0x80fa},
		{&&op_divu_16_pcix     , 0xf1ff, 0x80fb},
		{&&op_divu_16_i        , 0xf1ff, 0x80fc},
		{&&op_sbcd_8_mm_ay7    , 0xf1ff, 0x810f},
		{&&op_or_8_re_pi7      , 0xf1ff, 0x811f},
		{&&op_or_8_re_pd7      , 0xf1ff, 0x8127},
		{&&op_or_8_re_aw       , 0xf1ff, 0x8138},
		{&&op_or_8_re_al       , 0xf1ff, 0x8139},
		{&&op_or_16_re_aw      , 0xf1ff, 0x8178},
		{&&op_or_16_re_al      , 0xf1ff, 0x8179},
		{&&op_or_32_re_aw      , 0xf1ff, 0x81b8},
		{&&op_or_32_re_al      , 0xf1ff, 0x81b9},
		{&&op_divs_16_aw       , 0xf1ff, 0x81f8},
		{&&op_divs_16_al       , 0xf1ff, 0x81f9},
		{&&op_divs_16_pcdi     , 0xf1ff, 0x81fa},
		{&&op_divs_16_pcix     , 0xf1ff, 0x81fb},
		{&&op_divs_16_i        , 0xf1ff, 0x81fc},
		{&&op_sub_8_er_pi7     , 0xf1ff, 0x901f},
		{&&op_sub_8_er_pd7     , 0xf1ff, 0x9027},
		{&&op_sub_8_er_aw      , 0xf1ff, 0x9038},
		{&&op_sub_8_er_al      , 0xf1ff, 0x9039},
		{&&op_sub_8_er_pcdi    , 0xf1ff, 0x903a},
		{&&op_sub_8_er_pcix    , 0xf1ff, 0x903b},
		{&&op_sub_8_er_i       , 0xf1ff, 0x903c},
		{&&op_sub_16_er_aw     , 0xf1ff, 0x9078},
		{&&op_sub_16_er_al     , 0xf1ff, 0x9079},
		{&&op_sub_16_er_pcdi   , 0xf1ff, 0x907a},
		{&&op_sub_16_er_pcix   , 0xf1ff, 0x907b},
		{&&op_sub_16_er_i      , 0xf1ff, 0x907c},
		{&&op_sub_32_er_aw     , 0xf1ff, 0x90b8},
		{&&op_sub_32_er_al     , 0xf1ff, 0x90b9},
		{&&op_sub_32_er_pcdi   , 0xf1ff, 0x90ba},
		{&&op_sub_32_er_pcix   , 0xf1ff, 0x90bb},
		{&&op_sub_32_er_i      , 0xf1ff, 0x90bc},
		{&&op_suba_16_aw       , 0xf1ff, 0x90f8},
		{&&op_suba_16_al       , 0xf1ff, 0x90f9},
		{&&op_suba_16_pcdi     , 0xf1ff, 0x90fa},
		{&&op_suba_16_pcix     , 0xf1ff, 0x90fb},
		{&&op_suba_16_i        , 0xf1ff, 0x90fc},
		{&&op_subx_8_mm_ay7    , 0xf1ff, 0x910f},
		{&&op_sub_8_re_pi7     , 0xf1ff, 0x911f},
		{&&op_sub_8_re_pd7     , 0xf1ff, 0x9127},
		{&&op_sub_8_re_aw      , 0xf1ff, 0x9138},
		{&&op_sub_8_re_al      , 0xf1ff, 0x9139},
		{&&op_sub_16_re_aw     , 0xf1ff, 0x9178},
		{&&op_sub_16_re_al     , 0xf1ff, 0x9179},
		{&&op_sub_32_re_aw     , 0xf1ff, 0x91b8},
		{&&op_sub_32_re_al     , 0xf1ff, 0x91b9},
		{&&op_suba_32_aw       , 0xf1ff, 0x91f8},
		{&&op_suba_32_al       , 0xf1ff, 0x91f9},
		{&&op_suba_32_pcdi     , 0xf1ff, 0x91fa},
		{&&op_suba_32_pcix     , 0xf1ff, 0x91fb},
		{&&op_suba_32_i        , 0xf1ff, 0x91fc},
		{&&op_cmp_8_pi7        , 0xf1ff, 0xb01f},
		{&&op_cmp_8_pd7        , 0xf1ff, 0xb027},
		{&&op_cmp_8_aw         , 0xf1ff, 0xb038},
		{&&op_cmp_8_al         , 0xf1ff, 0xb039},
		{&&op_cmp_8_pcdi       , 0xf1ff, 0xb03a},
		{&&op_cmp_8_pcix       , 0xf1ff, 0xb03b},
		{&&op_cmp_8_i          , 0xf1ff, 0xb03c},
		{&&op_cmp_16_aw        , 0xf1ff, 0xb078},
		{&&op_cmp_16_al        , 0xf1ff, 0xb079},
		{&&op_cmp_16_pcdi      , 0xf1ff, 0xb07a},
		{&&op_cmp_16_pcix      , 0xf1ff, 0xb07b},
		{&&op_cmp_16_i         , 0xf1ff, 0xb07c},
		{&&op_cmp_32_aw        , 0xf1ff, 0xb0b8},
		{&&op_cmp_32_al        , 0xf1ff, 0xb0b9},
		{&&op_cmp_32_pcdi      , 0xf1ff, 0xb0ba},
		{&&op_cmp_32_pcix      , 0xf1ff, 0xb0bb},
		{&&op_cmp_32_i         , 0xf1ff, 0xb0bc},
		{&&op_cmpa_16_aw       , 0xf1ff, 0xb0f8},
		{&&op_cmpa_16_al       , 0xf1ff, 0xb0f9},
		{&&op_cmpa_16_pcdi     , 0xf1ff, 0xb0fa},
		{&&op_cmpa_16_pcix     , 0xf1ff, 0xb0fb},
		{&&op_cmpa_16_i        , 0xf1ff, 0xb0fc},
		{&&op_cmpm_8_ay7       , 0xf1ff, 0xb10f},
		{&&op_eor_8_pi7        , 0xf1ff, 0xb11f},
		{&&op_eor_8_pd7        , 0xf1ff, 0xb127},
		{&&op_eor_8_aw         , 0xf1ff, 0xb138},
		{&&op_eor_8_al         , 0xf1ff, 0xb139},
		{&&op_eor_16_aw        , 0xf1ff, 0xb178},
		{&&op_eor_16_al        , 0xf1ff, 0xb179},
		{&&op_eor_32_aw        , 0xf1ff, 0xb1b8},
		{&&op_eor_32_al        , 0xf1ff, 0xb1b9},
		{&&op_cmpa_32_aw       , 0xf1ff, 0xb1f8},
		{&&op_cmpa_32_al       , 0xf1ff, 0xb1f9},
		{&&op_cmpa_32_pcdi     , 0xf1ff, 0xb1fa},
		{&&op_cmpa_32_pcix     , 0xf1ff, 0xb1fb},
		{&&op_cmpa_32_i        , 0xf1ff, 0xb1fc},
		{&&op_and_8_er_pi7     , 0xf1ff, 0xc01f},
		{&&op_and_8_er_pd7     , 0xf1ff, 0xc027},
		{&&op_and_8_er_aw      , 0xf1ff, 0xc038},
		{&&op_and_8_er_al      , 0xf1ff, 0xc039},
		{&&op_and_8_er_pcdi    , 0xf1ff, 0xc03a},
		{&&op_and_8_er_pcix    , 0xf1ff, 0xc03b},
		{&&op_and_8_er_i       , 0xf1ff, 0xc03c},
		{&&op_and_16_er_aw     , 0xf1ff, 0xc078},
		{&&op_and_16_er_al     , 0xf1ff, 0xc079},
		{&&op_and_16_er_pcdi   , 0xf1ff, 0xc07a},
		{&&op_and_16_er_pcix   , 0xf1ff, 0xc07b},
		{&&op_and_16_er_i      , 0xf1ff, 0xc07c},
		{&&op_and_32_er_aw     , 0xf1ff, 0xc0b8},
		{&&op_and_32_er_al     , 0xf1ff, 0xc0b9},
		{&&op_and_32_er_pcdi   , 0xf1ff, 0xc0ba},
		{&&op_and_32_er_pcix   , 0xf1ff, 0xc0bb},
		{&&op_and_32_er_i      , 0xf1ff, 0xc0bc},
		{&&op_mulu_16_aw       , 0xf1ff, 0xc0f8},
		{&&op_mulu_16_al       , 0xf1ff, 0xc0f9},
		{&&op_mulu_16_pcdi     , 0xf1ff, 0xc0fa},
		{&&op_mulu_16_pcix     , 0xf1ff, 0xc0fb},
		{&&op_mulu_16_i        , 0xf1ff, 0xc0fc},
		{&&op_abcd_8_mm_ay7    , 0xf1ff, 0xc10f},
		{&&op_and_8_re_pi7     , 0xf1ff, 0xc11f},
		{&&op_and_8_re_pd7     , 0xf1ff, 0xc127},
		{&&op_and_8_re_aw      , 0xf1ff, 0xc138},
		{&&op_and_8_re_al      , 0xf1ff, 0xc139},
		{&&op_and_16_re_aw     , 0xf1ff, 0xc178},
		{&&op_and_16_re_al     , 0xf1ff, 0xc179},
		{&&op_and_32_re_aw     , 0xf1ff, 0xc1b8},
		{&&op_and_32_re_al     , 0xf1ff, 0xc1b9},
		{&&op_muls_16_aw       , 0xf1ff, 0xc1f8},
		{&&op_muls_16_al       , 0xf1ff, 0xc1f9},
		{&&op_muls_16_pcdi     , 0xf1ff, 0xc1fa},
		{&&op_muls_16_pcix     , 0xf1ff, 0xc1fb},
		{&&op_muls_16_i        , 0xf1ff, 0xc1fc},
		{&&op_add_8_er_pi7     , 0xf1ff, 0xd01f},
		{&&op_add_8_er_pd7     , 0xf1ff, 0xd027},
		{&&op_add_8_er_aw      , 0xf1ff, 0xd038},
		{&&op_add_8_er_al      , 0xf1ff, 0xd039},
		{&&op_add_8_er_pcdi    , 0xf1ff, 0xd03a},
		{&&op_add_8_er_pcix    , 0xf1ff, 0xd03b},
		{&&op_add_8_er_i       , 0xf1ff, 0xd03c},
		{&&op_add_16_er_aw     , 0xf1ff, 0xd078},
		{&&op_add_16_er_al     , 0xf1ff, 0xd079},
		{&&op_add_16_er_pcdi   , 0xf1ff, 0xd07a},
		{&&op_add_16_er_pcix   , 0xf1ff, 0xd07b},
		{&&op_add_16_er_i      , 0xf1ff, 0xd07c},
		{&&op_add_32_er_aw     , 0xf1ff, 0xd0b8},
		{&&op_add_32_er_al     , 0xf1ff, 0xd0b9},
		{&&op_add_32_er_pcdi   , 0xf1ff, 0xd0ba},
		{&&op_add_32_er_pcix   , 0xf1ff, 0xd0bb},
		{&&op_add_32_er_i      , 0xf1ff, 0xd0bc},
		{&&op_adda_16_aw       , 0xf1ff, 0xd0f8},
		{&&op_adda_16_al       , 0xf1ff, 0xd0f9},
		{&&op_adda_16_pcdi     , 0xf1ff, 0xd0fa},
		{&&op_adda_16_pcix     , 0xf1ff, 0xd0fb},
		{&&op_adda_16_i        , 0xf1ff, 0xd0fc},
		{&&op_addx_8_mm_ay7    , 0xf1ff, 0xd10f},
		{&&op_add_8_re_pi7     , 0xf1ff, 0xd11f},
		{&&op_add_8_re_pd7     , 0xf1ff, 0xd127},
		{&&op_add_8_re_aw      , 0xf1ff, 0xd138},
		{&&op_add_8_re_al      , 0xf1ff, 0xd139},
		{&&op_add_16_re_aw     , 0xf1ff, 0xd178},
		{&&op_add_16_re_al     , 0xf1ff, 0xd179},
		{&&op_add_32_re_aw     , 0xf1ff, 0xd1b8},
		{&&op_add_32_re_al     , 0xf1ff, 0xd1b9},
		{&&op_adda_32_aw       , 0xf1ff, 0xd1f8},
		{&&op_adda_32_al       , 0xf1ff, 0xd1f9},
		{&&op_adda_32_pcdi     , 0xf1ff, 0xd1fa},
		{&&op_adda_32_pcix     , 0xf1ff, 0xd1fb},
		{&&op_adda_32_i        , 0xf1ff, 0xd1fc},
		{&&op_ori_8_d          , 0xfff8, 0x0000},
		{&&op_ori_8_ai         , 0xfff8, 0x0010},
		{&&op_ori_8_pi         , 0xfff8, 0x0018},
		{&&op_ori_8_pd         , 0xfff8, 0x0020},
		{&&op_ori_8_di         , 0xfff8, 0x0028},
		{&&op_ori_8_ix         , 0xfff8, 0x0030},
		{&&op_ori_16_d         , 0xfff8, 0x0040},
		{&&op_ori_16_ai        , 0xfff8, 0x0050},
		{&&op_ori_16_pi        , 0xfff8, 0x0058},
		{&&op_ori_16_pd        , 0xfff8, 0x0060},
		{&&op_ori_16_di        , 0xfff8, 0x0068},
		{&&op_ori_16_ix        , 0xfff8, 0x0070},
		{&&op_ori_32_d         , 0xfff8, 0x0080},
		{&&op_ori_32_ai        , 0xfff8, 0x0090},
		{&&op_ori_32_pi        , 0xfff8, 0x0098},
		{&&op_ori_32_pd        , 0xfff8, 0x00a0},
		{&&op_ori_32_di        , 0xfff8, 0x00a8},
		{&&op_ori_32_ix        , 0xfff8, 0x00b0},
		{&&op_andi_8_d         , 0xfff8, 0x0200},
		{&&op_andi_8_ai        , 0xfff8, 0x0210},
		{&&op_andi_8_pi        , 0xfff8, 0x0218},
		{&&op_andi_8_pd        , 0xfff8, 0x0220},
		{&&op_andi_8_di        , 0xfff8, 0x0228},
		{&&op_andi_8_ix        , 0xfff8, 0x0230},
		{&&op_andi_16_d        , 0xfff8, 0x0240},
		{&&op_andi_16_ai       , 0xfff8, 0x0250},
		{&&op_andi_16_pi       , 0xfff8, 0x0258},
		{&&op_andi_16_pd       , 0xfff8, 0x0260},
		{&&op_andi_16_di       , 0xfff8, 0x0268},
		{&&op_andi_16_ix       , 0xfff8, 0x0270},
		{&&op_andi_32_d        , 0xfff8, 0x0280},
		{&&op_andi_32_ai       , 0xfff8, 0x0290},
		{&&op_andi_32_pi       , 0xfff8, 0x0298},
		{&&op_andi_32_pd       , 0xfff8, 0x02a0},
		{&&op_andi_32_di       , 0xfff8, 0x02a8},
		{&&op_andi_32_ix       , 0xfff8, 0x02b0},
		{&&op_subi_8_d         , 0xfff8, 0x0400},
		{&&op_subi_8_ai        , 0xfff8, 0x0410},
		{&&op_subi_8_pi        , 0xfff8, 0x0418},
		{&&op_subi_8_pd        , 0xfff8, 0x0420},
		{&&op_subi_8_di        , 0xfff8, 0x0428},
		{&&op_subi_8_ix        , 0xfff8, 0x0430},
		{&&op_subi_16_d        , 0xfff8, 0x0440},
		{&&op_subi_16_ai       , 0xfff8, 0x0450},
		{&&op_subi_16_pi       , 0xfff8, 0x0458},
		{&&op_subi_16_pd       , 0xfff8, 0x0460},
		{&&op_subi_16_di       , 0xfff8, 0x0468},
		{&&op_subi_16_ix       , 0xfff8, 0x0470},
		{&&op_subi_32_d        , 0xfff8, 0x0480},
		{&&op_subi_32_ai       , 0xfff8, 0x0490},
		{&&op_subi_32_pi       , 0xfff8, 0x0498},
		{&&op_subi_32_pd       , 0xfff8, 0x04a0},
		{&&op_subi_32_di       , 0xfff8, 0x04a8},
		{&&op_subi_32_ix       , 0xfff8, 0x04b0},
		{&&op_addi_8_d         , 0xfff8, 0x0600},
		{&&op_addi_8_ai        , 0xfff8, 0x0610},
		{&&op_addi_8_pi        , 0xfff8, 0x0618},
		{&&op_addi_8_pd        , 0xfff8, 0x0620},
		{&&op_addi_8_di        , 0xfff8, 0x0628},
		{&&op_addi_8_ix        , 0xfff8, 0x0630},
		{&&op_addi_16_d        , 0xfff8, 0x0640},
		{&&op_addi_16_ai       , 0xfff8, 0x0650},
		{&&op_addi_16_pi       , 0xfff8, 0x0658},
		{&&op_addi_16_pd       , 0xfff8, 0x0660},
		{&&op_addi_16_di       , 0xfff8, 0x0668},
		{&&op_addi_16_ix       , 0xfff8, 0x0670},
		{&&op_addi_32_d        , 0xfff8, 0x0680},
		{&&op_addi_32_ai       , 0xfff8, 0x0690},
		{&&op_addi_32_pi       , 0xfff8, 0x0698},
		{&&op_addi_32_pd       , 0xfff8, 0x06a0},
		{&&op_addi_32_di       , 0xfff8, 0x06a8},
		{&&op_addi_32_ix       , 0xfff8, 0x06b0},
		{&&op_btst_32_s_d      , 0xfff8, 0x0800},
		{&&op_btst_8_s_ai      , 0xfff8, 0x0810},
		{&&op_btst_8_s_pi      , 0xfff8, 0x0818},
		{&&op_btst_8_s_pd      , 0xfff8, 0x0820},
		{&&op_btst_8_s_di      , 0xfff8, 0x0828},
		{&&op_btst_8_s_ix      , 0xfff8, 0x0830},
		{&&op_bchg_32_s_d      , 0xfff8, 0x0840},
		{&&op_bchg_8_s_ai      , 0xfff8, 0x0850},
		{&&op_bchg_8_s_pi      , 0xfff8, 0x0858},
		{&&op_bchg_8_s_pd      , 0xfff8, 0x0860},
		{&&op_bchg_8_s_di      , 0xfff8, 0x0868},
		{&&op_bchg_8_s_ix      , 0xfff8, 0x0870},
		{&&op_bclr_32_s_d      , 0xfff8, 0x0880},
		{&&op_bclr_8_s_ai      , 0xfff8, 0x0890},
		{&&op_bclr_8_s_pi      , 0xfff8, 0x0898},
		{&&op_bclr_8_s_pd      , 0xfff8, 0x08a0},
		{&&op_bclr_8_s_di      , 0xfff8, 0x08a8},
		{&&op_bclr_8_s_ix      , 0xfff8, 0x08b0},
		{&&op_bset_32_s_d      , 0xfff8, 0x08c0},
		{&&op_bset_8_s_ai      , 0xfff8, 0x08d0},
		{&&op_bset_8_s_pi      , 0xfff8, 0x08d8},
		{&&op_bset_8_s_pd      , 0xfff8, 0x08e0},
		{&&op_bset_8_s_di      , 0xfff8, 0x08e8},
		{&&op_bset_8_s_ix      , 0xfff8, 0x08f0},
		{&&op_eori_8_d         , 0xfff8, 0x0a00},
		{&&op_eori_8_ai        , 0xfff8, 0x0a10},
		{&&op_eori_8_pi        , 0xfff8, 0x0a18},
		{&&op_eori_8_pd        , 0xfff8, 0x0a20},
		{&&op_eori_8_di        , 0xfff8, 0x0a28},
		{&&op_eori_8_ix        , 0xfff8, 0x0a30},
		{&&op_eori_16_d        , 0xfff8, 0x0a40},
		{&&op_eori_16_ai       , 0xfff8, 0x0a50},
		{&&op_eori_16_pi       , 0xfff8, 0x0a58},
		{&&op_eori_16_pd       , 0xfff8, 0x0a60},
		{&&op_eori_16_di       , 0xfff8, 0x0a68},
		{&&op_eori_16_ix       , 0xfff8, 0x0a70},
		{&&op_eori_32_d        , 0xfff8, 0x0a80},
		{&&op_eori_32_ai       , 0xfff8, 0x0a90},
		{&&op_eori_32_pi       , 0xfff8, 0x0a98},
		{&&op_eori_32_pd       , 0xfff8, 0x0aa0},
		{&&op_eori_32_di       , 0xfff8, 0x0aa8},
		{&&op_eori_32_ix       , 0xfff8, 0x0ab0},
		{&&op_cmpi_8_d         , 0xfff8, 0x0c00},
		{&&op_cmpi_8_ai        , 0xfff8, 0x0c10},
		{&&op_cmpi_8_pi        , 0xfff8, 0x0c18},
		{&&op_cmpi_8_pd        , 0xfff8, 0x0c20},
		{&&op_cmpi_8_di        , 0xfff8, 0x0c28},
		{&&op_cmpi_8_ix        , 0xfff8, 0x0c30},
		{&&op_cmpi_16_d        , 0xfff8, 0x0c40},
		{&&op_cmpi_16_ai       , 0xfff8, 0x0c50},
		{&&op_cmpi_16_pi       , 0xfff8, 0x0c58},
		{&&op_cmpi_16_pd       , 0xfff8, 0x0c60},
		{&&op_cmpi_16_di       , 0xfff8, 0x0c68},
		{&&op_cmpi_16_ix       , 0xfff8, 0x0c70},
		{&&op_cmpi_32_d        , 0xfff8, 0x0c80},
		{&&op_cmpi_32_ai       , 0xfff8, 0x0c90},
		{&&op_cmpi_32_pi       , 0xfff8, 0x0c98},
		{&&op_cmpi_32_pd       , 0xfff8, 0x0ca0},
		{&&op_cmpi_32_di       , 0xfff8, 0x0ca8},
		{&&op_cmpi_32_ix       , 0xfff8, 0x0cb0},
		{&&op_move_8_aw_d      , 0xfff8, 0x11c0},
		{&&op_move_8_aw_ai     , 0xfff8, 0x11d0},
		{&&op_move_8_aw_pi     , 0xfff8, 0x11d8},
		{&&op_move_8_aw_pd     , 0xfff8, 0x11e0},
		{&&op_move_8_aw_di     , 0xfff8, 0x11e8},
		{&&op_move_8_aw_ix     , 0xfff8, 0x11f0},
		{&&op_move_8_al_d      , 0xfff8, 0x13c0},
		{&&op_move_8_al_ai     , 0xfff8, 0x13d0},
		{&&op_move_8_al_pi     , 0xfff8, 0x13d8},
		{&&op_move_8_al_pd     , 0xfff8, 0x13e0},
		{&&op_move_8_al_di     , 0xfff8, 0x13e8},
		{&&op_move_8_al_ix     , 0xfff8, 0x13f0},
		{&&op_move_8_pi7_d     , 0xfff8, 0x1ec0},
		{&&op_move_8_pi7_ai    , 0xfff8, 0x1ed0},
		{&&op_move_8_pi7_pi    , 0xfff8, 0x1ed8},
		{&&op_move_8_pi7_pd    , 0xfff8, 0x1ee0},
		{&&op_move_8_pi7_di    , 0xfff8, 0x1ee8},
		{&&op_move_8_pi7_ix    , 0xfff8, 0x1ef0},
		{&&op_move_8_pd7_d     , 0xfff8, 0x1f00},
		{&&op_move_8_pd7_ai    , 0xfff8, 0x1f10},
		{&&op_move_8_pd7_pi    , 0xfff8, 0x1f18},
		{&&op_move_8_pd7_pd    , 0xfff8, 0x1f20},
		{&&op_move_8_pd7_di    , 0xfff8, 0x1f28},
		{&&op_move_8_pd7_ix    , 0xfff8, 0x1f30},
		{&&op_move_32_aw_d     , 0xfff8, 0x21c0},
		{&&op_move_32_aw_a     , 0xfff8, 0x21c8},
		{&&op_move_32_aw_ai    , 0xfff8, 0x21d0},
		{&&op_move_32_aw_pi    , 0xfff8, 0x21d8},
		{&&op_move_32_aw_pd    , 0xfff8, 0x21e0},
		{&&op_move_32_aw_di    , 0xfff8, 0x21e8},
		{&&op_move_32_aw_ix    , 0xfff8, 0x21f0},
		{&&op_move_32_al_d     , 0xfff8, 0x23c0},
		{&&op_move_32_al_a     , 0xfff8, 0x23c8},
		{&&op_move_32_al_ai    , 0xfff8, 0x23d0},
		{&&op_move_32_al_pi    , 0xfff8, 0x23d8},
		{&&op_move_32_al_pd    , 0xfff8, 0x23e0},
		{&&op_move_32_al_di    , 0xfff8, 0x23e8},
		{&&op_move_32_al_ix    , 0xfff8, 0x23f0},
		{&&op_move_16_aw_d     , 0xfff8, 0x31c0},
		{&&op_move_16_aw_a     , 0xfff8, 0x31c8},
		{&&op_move_16_aw_ai    , 0xfff8, 0x31d0},
		{&&op_move_16_aw_pi    , 0xfff8, 0x31d8},
		{&&op_move_16_aw_pd    , 0xfff8, 0x31e0},
		{&&op_move_16_aw_di    , 0xfff8, 0x31e8},
		{&&op_move_16_aw_ix    , 0xfff8, 0x31f0},
		{&&op_move_16_al_d     , 0xfff8, 0x33c0},
		{&&op_move_16_al_a     , 0xfff8, 0x33c8},
		{&&op_move_16_al_ai    , 0xfff8, 0x33d0},
		{&&op_move_16_al_pi    , 0xfff8, 0x33d8},
		{&&op_move_16_al_pd    , 0xfff8, 0x33e0},
		{&&op_move_16_al_di    , 0xfff8, 0x33e8},
		{&&op_move_16_al_ix    , 0xfff8, 0x33f0},
		{&&op_negx_8_d         , 0xfff8, 0x4000},
		{&&op_negx_8_ai        , 0xfff8, 0x4010},
		{&&op_negx_8_pi        , 0xfff8, 0x4018},
		{&&op_negx_8_pd        , 0xfff8, 0x4020},
		{&&op_negx_8_di        , 0xfff8, 0x4028},
		{&&op_negx_8_ix        , 0xfff8, 0x4030},
		{&&op_negx_16_d        , 0xfff8, 0x4040},
		{&&op_negx_16_ai       , 0xfff8, 0x4050},
		{&&op_negx_16_pi       , 0xfff8, 0x4058},
		{&&op_negx_16_pd       , 0xfff8, 0x4060},
		{&&op_negx_16_di       , 0xfff8, 0x4068},
		{&&op_negx_16_ix       , 0xfff8, 0x4070},
		{&&op_negx_32_d        , 0xfff8, 0x4080},
		{&&op_negx_32_ai       , 0xfff8, 0x4090},
		{&&op_negx_32_pi       , 0xfff8, 0x4098},
		{&&op_negx_32_pd       , 0xfff8, 0x40a0},
		{&&op_negx_32_di       , 0xfff8, 0x40a8},
		{&&op_negx_32_ix       , 0xfff8, 0x40b0},
		{&&op_move_16_frs_d    , 0xfff8, 0x40c0},
		{&&op_move_16_frs_ai   , 0xfff8, 0x40d0},
		{&&op_move_16_frs_pi   , 0xfff8, 0x40d8},
		{&&op_move_16_frs_pd   , 0xfff8, 0x40e0},
		{&&op_move_16_frs_di   , 0xfff8, 0x40e8},
		{&&op_move_16_frs_ix   , 0xfff8, 0x40f0},
		{&&op_clr_8_d          , 0xfff8, 0x4200},
		{&&op_clr_8_ai         , 0xfff8, 0x4210},
		{&&op_clr_8_pi         , 0xfff8, 0x4218},
		{&&op_clr_8_pd         , 0xfff8, 0x4220},
		{&&op_clr_8_di         , 0xfff8, 0x4228},
		{&&op_clr_8_ix         , 0xfff8, 0x4230},
		{&&op_clr_16_d         , 0xfff8, 0x4240},
		{&&op_clr_16_ai        , 0xfff8, 0x4250},
		{&&op_clr_16_pi        , 0xfff8, 0x4258},
		{&&op_clr_16_pd        , 0xfff8, 0x4260},
		{&&op_clr_16_di        , 0xfff8, 0x4268},
		{&&op_clr_16_ix        , 0xfff8, 0x4270},
		{&&op_clr_32_d         , 0xfff8, 0x4280},
		{&&op_clr_32_ai        , 0xfff8, 0x4290},
		{&&op_clr_32_pi        , 0xfff8, 0x4298},
		{&&op_clr_32_pd        , 0xfff8, 0x42a0},
		{&&op_clr_32_di        , 0xfff8, 0x42a8},
		{&&op_clr_32_ix        , 0xfff8, 0x42b0},
		{&&op_neg_8_d          , 0xfff8, 0x4400},
		{&&op_neg_8_ai         , 0xfff8, 0x4410},
		{&&op_neg_8_pi         , 0xfff8, 0x4418},
		{&&op_neg_8_pd         , 0xfff8, 0x4420},
		{&&op_neg_8_di         , 0xfff8, 0x4428},
		{&&op_neg_8_ix         , 0xfff8, 0x4430},
		{&&op_neg_16_d         , 0xfff8, 0x4440},
		{&&op_neg_16_ai        , 0xfff8, 0x4450},
		{&&op_neg_16_pi        , 0xfff8, 0x4458},
		{&&op_neg_16_pd        , 0xfff8, 0x4460},
		{&&op_neg_16_di        , 0xfff8, 0x4468},
		{&&op_neg_16_ix        , 0xfff8, 0x4470},
		{&&op_neg_32_d         , 0xfff8, 0x4480},
		{&&op_neg_32_ai        , 0xfff8, 0x4490},
		{&&op_neg_32_pi        , 0xfff8, 0x4498},
		{&&op_neg_32_pd        , 0xfff8, 0x44a0},
		{&&op_neg_32_di        , 0xfff8, 0x44a8},
		{&&op_neg_32_ix        , 0xfff8, 0x44b0},
		{&&op_move_16_toc_d    , 0xfff8, 0x44c0},
		{&&op_move_16_toc_ai   , 0xfff8, 0x44d0},
		{&&op_move_16_toc_pi   , 0xfff8, 0x44d8},
		{&&op_move_16_toc_pd   , 0xfff8, 0x44e0},
		{&&op_move_16_toc_di   , 0xfff8, 0x44e8},
		{&&op_move_16_toc_ix   , 0xfff8, 0x44f0},
		{&&op_not_8_d          , 0xfff8, 0x4600},
		{&&op_not_8_ai         , 0xfff8, 0x4610},
		{&&op_not_8_pi         , 0xfff8, 0x4618},
		{&&op_not_8_pd         , 0xfff8, 0x4620},
		{&&op_not_8_di         , 0xfff8, 0x4628},
		{&&op_not_8_ix         , 0xfff8, 0x4630},
		{&&op_not_16_d         , 0xfff8, 0x4640},
		{&&op_not_16_ai        , 0xfff8, 0x4650},
		{&&op_not_16_pi        , 0xfff8, 0x4658},
		{&&op_not_16_pd        , 0xfff8, 0x4660},
		{&&op_not_16_di        , 0xfff8, 0x4668},
		{&&op_not_16_ix        , 0xfff8, 0x4670},
		{&&op_not_32_d         , 0xfff8, 0x4680},
		{&&op_not_32_ai        , 0xfff8, 0x4690},
		{&&op_not_32_pi        , 0xfff8, 0x4698},
		{&&op_not_32_pd        , 0xfff8, 0x46a0},
		{&&op_not_32_di        , 0xfff8, 0x46a8},
		{&&op_not_32_ix        , 0xfff8, 0x46b0},
		{&&op_move_16_tos_d    , 0xfff8, 0x46c0},
		{&&op_move_16_tos_ai   , 0xfff8, 0x46d0},
		{&&op_move_16_tos_pi   , 0xfff8, 0x46d8},
		{&&op_move_16_tos_pd   , 0xfff8, 0x46e0},
		{&&op_move_16_tos_di   , 0xfff8, 0x46e8},
		{&&op_move_16_tos_ix   , 0xfff8, 0x46f0},
		{&&op_nbcd_8_d         , 0xfff8, 0x4800},
		{&&op_nbcd_8_ai        , 0xfff8, 0x4810},
		{&&op_nbcd_8_pi        , 0xfff8, 0x4818},
		{&&op_nbcd_8_pd        , 0xfff8, 0x4820},
		{&&op_nbcd_8_di        , 0xfff8, 0x4828},
		{&&op_nbcd_8_ix        , 0xfff8, 0x4830},
		{&&op_swap_32          , 0xfff8, 0x4840},
		{&&op_pea_32_ai        , 0xfff8, 0x4850},
		{&&op_pea_32_di        , 0xfff8, 0x4868},
		{&&op_pea_32_ix        , 0xfff8, 0x4870},
		{&&op_ext_16           , 0xfff8, 0x4880},
		{&&op_movem_16_re_ai   , 0xfff8, 0x4890},
		{&&op_movem_16_re_pd   , 0xfff8, 0x48a0},
		{&&op_movem_16_re_di   , 0xfff8, 0x48a8},
		{&&op_movem_16_re_ix   , 0xfff8, 0x48b0},
		{&&op_ext_32           , 0xfff8, 0x48c0},
		{&&op_movem_32_re_ai   , 0xfff8, 0x48d0},
		{&&op_movem_32_re_pd   , 0xfff8, 0x48e0},
		{&&op_movem_32_re_di   , 0xfff8, 0x48e8},
		{&&op_movem_32_re_ix   , 0xfff8, 0x48f0},
		{&&op_tst_8_d          , 0xfff8, 0x4a00},
		{&&op_tst_8_ai         , 0xfff8, 0x4a10},
		{&&op_tst_8_pi         , 0xfff8, 0x4a18},
		{&&op_tst_8_pd         , 0xfff8, 0x4a20},
		{&&op_tst_8_di         , 0xfff8, 0x4a28},
		{&&op_tst_8_ix         , 0xfff8, 0x4a30},
		{&&op_tst_16_d         , 0xfff8, 0x4a40},
		{&&op_tst_16_ai        , 0xfff8, 0x4a50},
		{&&op_tst_16_pi        , 0xfff8, 0x4a58},
		{&&op_tst_16_pd        , 0xfff8, 0x4a60},
		{&&op_tst_16_di        , 0xfff8, 0x4a68},
		{&&op_tst_16_ix        , 0xfff8, 0x4a70},
		{&&op_tst_32_d         , 0xfff8, 0x4a80},
		{&&op_tst_32_ai        , 0xfff8, 0x4a90},
		{&&op_tst_32_pi        , 0xfff8, 0x4a98},
		{&&op_tst_32_pd        , 0xfff8, 0x4aa0},
		{&&op_tst_32_di        , 0xfff8, 0x4aa8},
		{&&op_tst_32_ix        , 0xfff8, 0x4ab0},
		{&&op_tas_8_d          , 0xfff8, 0x4ac0},
		{&&op_tas_8_ai         , 0xfff8, 0x4ad0},
		{&&op_tas_8_pi         , 0xfff8, 0x4ad8},
		{&&op_tas_8_pd         , 0xfff8, 0x4ae0},
		{&&op_tas_8_di         , 0xfff8, 0x4ae8},
		{&&op_tas_8_ix         , 0xfff8, 0x4af0},
		{&&op_movem_16_er_ai   , 0xfff8, 0x4c90},
		{&&op_movem_16_er_pi   , 0xfff8, 0x4c98},
		{&&op_movem_16_er_di   , 0xfff8, 0x4ca8},
		{&&op_movem_16_er_ix   , 0xfff8, 0x4cb0},
		{&&op_movem_32_er_ai   , 0xfff8, 0x4cd0},
		{&&op_movem_32_er_pi   , 0xfff8, 0x4cd8},
		{&&op_movem_32_er_di   , 0xfff8, 0x4ce8},
		{&&op_movem_32_er_ix   , 0xfff8, 0x4cf0},
		{&&op_link_16          , 0xfff8, 0x4e50},
		{&&op_unlk_32          , 0xfff8, 0x4e58},
		{&&op_move_32_tou      , 0xfff8, 0x4e60},
		{&&op_move_32_fru      , 0xfff8, 0x4e68},
		{&&op_jsr_32_ai        , 0xfff8, 0x4e90},
		{&&op_jsr_32_di        , 0xfff8, 0x4ea8},
		{&&op_jsr_32_ix        , 0xfff8, 0x4eb0},
		{&&op_jmp_32_ai        , 0xfff8, 0x4ed0},
		{&&op_jmp_32_di        , 0xfff8, 0x4ee8},
		{&&op_jmp_32_ix        , 0xfff8, 0x4ef0},
		{&&op_st_8_d           , 0xfff8, 0x50c0},
		{&&op_dbt_16           , 0xfff8, 0x50c8},
		{&&op_st_8_ai          , 0xfff8, 0x50d0},
		{&&op_st_8_pi          , 0xfff8, 0x50d8},
		{&&op_st_8_pd          , 0xfff8, 0x50e0},
		{&&op_st_8_di          , 0xfff8, 0x50e8},
		{&&op_st_8_ix          , 0xfff8, 0x50f0},
		{&&op_sf_8_d           , 0xfff8, 0x51c0},
		{&&op_dbf_16           , 0xfff8, 0x51c8},
		{&&op_sf_8_ai          , 0xfff8, 0x51d0},
		{&&op_sf_8_pi          , 0xfff8, 0x51d8},
		{&&op_sf_8_pd          , 0xfff8, 0x51e0},
		{&&op_sf_8_di          , 0xfff8, 0x51e8},
		{&&op_sf_8_ix          , 0xfff8, 0x51f0},
		{&&op_shi_8_d          , 0xfff8, 0x52c0},
		{&&op_dbhi_16          , 0xfff8, 0x52c8},
		{&&op_shi_8_ai         , 0xfff8, 0x52d0},
		{&&op_shi_8_pi         , 0xfff8, 0x52d8},
		{&&op_shi_8_pd         , 0xfff8, 0x52e0},
		{&&op_shi_8_di         , 0xfff8, 0x52e8},
		{&&op_shi_8_ix         , 0xfff8, 0x52f0},
		{&&op_sls_8_d          , 0xfff8, 0x53c0},
		{&&op_dbls_16          , 0xfff8, 0x53c8},
		{&&op_sls_8_ai         , 0xfff8, 0x53d0},
		{&&op_sls_8_pi         , 0xfff8, 0x53d8},
		{&&op_sls_8_pd         , 0xfff8, 0x53e0},
		{&&op_sls_8_di         , 0xfff8, 0x53e8},
		{&&op_sls_8_ix         , 0xfff8, 0x53f0},
		{&&op_scc_8_d          , 0xfff8, 0x54c0},
		{&&op_dbcc_16          , 0xfff8, 0x54c8},
		{&&op_scc_8_ai         , 0xfff8, 0x54d0},
		{&&op_scc_8_pi         , 0xfff8, 0x54d8},
		{&&op_scc_8_pd         , 0xfff8, 0x54e0},
		{&&op_scc_8_di         , 0xfff8, 0x54e8},
		{&&op_scc_8_ix         , 0xfff8, 0x54f0},
		{&&op_scs_8_d          , 0xfff8, 0x55c0},
		{&&op_dbcs_16          , 0xfff8, 0x55c8},
		{&&op_scs_8_ai         , 0xfff8, 0x55d0},
		{&&op_scs_8_pi         , 0xfff8, 0x55d8},
		{&&op_scs_8_pd         , 0xfff8, 0x55e0},
		{&&op_scs_8_di         , 0xfff8, 0x55e8},
		{&&op_scs_8_ix         , 0xfff8, 0x55f0},
		{&&op_sne_8_d          , 0xfff8, 0x56c0},
		{&&op_dbne_16          , 0xfff8, 0x56c8},
		{&&op_sne_8_ai         , 0xfff8, 0x56d0},
		{&&op_sne_8_pi         , 0xfff8, 0x56d8},
		{&&op_sne_8_pd         , 0xfff8, 0x56e0},
		{&&op_sne_8_di         , 0xfff8, 0x56e8},
		{&&op_sne_8_ix         , 0xfff8, 0x56f0},
		{&&op_seq_8_d          , 0xfff8, 0x57c0},
		{&&op_dbeq_16          , 0xfff8, 0x57c8},
		{&&op_seq_8_ai         , 0xfff8, 0x57d0},
		{&&op_seq_8_pi         , 0xfff8, 0x57d8},
		{&&op_seq_8_pd         , 0xfff8, 0x57e0},
		{&&op_seq_8_di         , 0xfff8, 0x57e8},
		{&&op_seq_8_ix         , 0xfff8, 0x57f0},
		{&&op_svc_8_d          , 0xfff8, 0x58c0},
		{&&op_dbvc_16          , 0xfff8, 0x58c8},
		{&&op_svc_8_ai         , 0xfff8, 0x58d0},
		{&&op_svc_8_pi         , 0xfff8, 0x58d8},
		{&&op_svc_8_pd         , 0xfff8, 0x58e0},
		{&&op_svc_8_di         , 0xfff8, 0x58e8},
		{&&op_svc_8_ix         , 0xfff8, 0x58f0},
		{&&op_svs_8_d          , 0xfff8, 0x59c0},
		{&&op_dbvs_16          , 0xfff8, 0x59c8},
		{&&op_svs_8_ai         , 0xfff8, 0x59d0},
		{&&op_svs_8_pi         , 0xfff8, 0x59d8},
		{&&op_svs_8_pd         , 0xfff8, 0x59e0},
		{&&op_svs_8_di         , 0xfff8, 0x59e8},
		{&&op_svs_8_ix         , 0xfff8, 0x59f0},
		{&&op_spl_8_d          , 0xfff8, 0x5ac0},
		{&&op_dbpl_16          , 0xfff8, 0x5ac8},
		{&&op_spl_8_ai         , 0xfff8, 0x5ad0},
		{&&op_spl_8_pi         , 0xfff8, 0x5ad8},
		{&&op_spl_8_pd         , 0xfff8, 0x5ae0},
		{&&op_spl_8_di         , 0xfff8, 0x5ae8},
		{&&op_spl_8_ix         , 0xfff8, 0x5af0},
		{&&op_smi_8_d          , 0xfff8, 0x5bc0},
		{&&op_dbmi_16          , 0xfff8, 0x5bc8},
		{&&op_smi_8_ai         , 0xfff8, 0x5bd0},
		{&&op_smi_8_pi         , 0xfff8, 0x5bd8},
		{&&op_smi_8_pd         , 0xfff8, 0x5be0},
		{&&op_smi_8_di         , 0xfff8, 0x5be8},
		{&&op_smi_8_ix         , 0xfff8, 0x5bf0},
		{&&op_sge_8_d          , 0xfff8, 0x5cc0},
		{&&op_dbge_16          , 0xfff8, 0x5cc8},
		{&&op_sge_8_ai         , 0xfff8, 0x5cd0},
		{&&op_sge_8_pi         , 0xfff8, 0x5cd8},
		{&&op_sge_8_pd         , 0xfff8, 0x5ce0},
		{&&op_sge_8_di         , 0xfff8, 0x5ce8},
		{&&op_sge_8_ix         , 0xfff8, 0x5cf0},
		{&&op_slt_8_d          , 0xfff8, 0x5dc0},
		{&&op_dblt_16          , 0xfff8, 0x5dc8},
		{&&op_slt_8_ai         , 0xfff8, 0x5dd0},
		{&&op_slt_8_pi         , 0xfff8, 0x5dd8},
		{&&op_slt_8_pd         , 0xfff8, 0x5de0},
		{&&op_slt_8_di         , 0xfff8, 0x5de8},
		{&&op_slt_8_ix         , 0xfff8, 0x5df0},
		{&&op_sgt_8_d          , 0xfff8, 0x5ec0},
		{&&op_dbgt_16          , 0xfff8, 0x5ec8},
		{&&op_sgt_8_ai         , 0xfff8, 0x5ed0},
		{&&op_sgt_8_pi         , 0xfff8, 0x5ed8},
		{&&op_sgt_8_pd         , 0xfff8, 0x5ee0},
		{&&op_sgt_8_di         , 0xfff8, 0x5ee8},
		{&&op_sgt_8_ix         , 0xfff8, 0x5ef0},
		{&&op_sle_8_d          , 0xfff8, 0x5fc0},
		{&&op_dble_16          , 0xfff8, 0x5fc8},
		{&&op_sle_8_ai         , 0xfff8, 0x5fd0},
		{&&op_sle_8_pi         , 0xfff8, 0x5fd8},
		{&&op_sle_8_pd         , 0xfff8, 0x5fe0},
		{&&op_sle_8_di         , 0xfff8, 0x5fe8},
		{&&op_sle_8_ix         , 0xfff8, 0x5ff0},
		{&&op_sbcd_8_mm_ax7    , 0xfff8, 0x8f08},
		{&&op_subx_8_mm_ax7    , 0xfff8, 0x9f08},
		{&&op_cmpm_8_ax7       , 0xfff8, 0xbf08},
		{&&op_abcd_8_mm_ax7    , 0xfff8, 0xcf08},
		{&&op_addx_8_mm_ax7    , 0xfff8, 0xdf08},
		{&&op_asr_16_ai        , 0xfff8, 0xe0d0},
		{&&op_asr_16_pi        , 0xfff8, 0xe0d8},
		{&&op_asr_16_pd        , 0xfff8, 0xe0e0},
		{&&op_asr_16_di        , 0xfff8, 0xe0e8},
		{&&op_asr_16_ix        , 0xfff8, 0xe0f0},
		{&&op_asl_16_ai        , 0xfff8, 0xe1d0},
		{&&op_asl_16_pi        , 0xfff8, 0xe1d8},
		{&&op_asl_16_pd        , 0xfff8, 0xe1e0},
		{&&op_asl_16_di        , 0xfff8, 0xe1e8},
		{&&op_asl_16_ix        , 0xfff8, 0xe1f0},
		{&&op_lsr_16_ai        , 0xfff8, 0xe2d0},
		{&&op_lsr_16_pi        , 0xfff8, 0xe2d8},
		{&&op_lsr_16_pd        , 0xfff8, 0xe2e0},
		{&&op_lsr_16_di        , 0xfff8, 0xe2e8},
		{&&op_lsr_16_ix        , 0xfff8, 0xe2f0},
		{&&op_lsl_16_ai        , 0xfff8, 0xe3d0},
		{&&op_lsl_16_pi        , 0xfff8, 0xe3d8},
		{&&op_lsl_16_pd        , 0xfff8, 0xe3e0},
		{&&op_lsl_16_di        , 0xfff8, 0xe3e8},
		{&&op_lsl_16_ix        , 0xfff8, 0xe3f0},
		{&&op_roxr_16_ai       , 0xfff8, 0xe4d0},
		{&&op_roxr_16_pi       , 0xfff8, 0xe4d8},
		{&&op_roxr_16_pd       , 0xfff8, 0xe4e0},
		{&&op_roxr_16_di       , 0xfff8, 0xe4e8},
		{&&op_roxr_16_ix       , 0xfff8, 0xe4f0},
		{&&op_roxl_16_ai       , 0xfff8, 0xe5d0},
		{&&op_roxl_16_pi       , 0xfff8, 0xe5d8},
		{&&op_roxl_16_pd       , 0xfff8, 0xe5e0},
		{&&op_roxl_16_di       , 0xfff8, 0xe5e8},
		{&&op_roxl_16_ix       , 0xfff8, 0xe5f0},
		{&&op_ror_16_ai        , 0xfff8, 0xe6d0},
		{&&op_ror_16_pi        , 0xfff8, 0xe6d8},
		{&&op_ror_16_pd        , 0xfff8, 0xe6e0},
		{&&op_ror_16_di        , 0xfff8, 0xe6e8},
		{&&op_ror_16_ix        , 0xfff8, 0xe6f0},
		{&&op_rol_16_ai        , 0xfff8, 0xe7d0},
		{&&op_rol_16_pi        , 0xfff8, 0xe7d8},
		{&&op_rol_16_pd        , 0xfff8, 0xe7e0},
		{&&op_rol_16_di        , 0xfff8, 0xe7e8},
		{&&op_rol_16_ix        , 0xfff8, 0xe7f0},
		{&&op_ori_8_pi7        , 0xffff, 0x001f},
		{&&op_ori_8_pd7        , 0xffff, 0x0027},
		{&&op_ori_8_aw         , 0xffff, 0x0038},
		{&&op_ori_8_al         , 0xffff, 0x0039},
		{&&op_ori_16_toc       , 0xffff, 0x003c},
		{&&op_ori_16_aw        , 0xffff, 0x0078},
		{&&op_ori_16_al        , 0xffff, 0x0079},
		{&&op_ori_16_tos       , 0xffff, 0x007c},
		{&&op_ori_32_aw        , 0xffff, 0x00b8},
		{&&op_ori_32_al        , 0xffff, 0x00b9},
		{&&op_andi_8_pi7       , 0xffff, 0x021f},
		{&&op_andi_8_pd7       , 0xffff, 0x0227},
		{&&op_andi_8_aw        , 0xffff, 0x0238},
		{&&op_andi_8_al        , 0xffff, 0x0239},
		{&&op_andi_16_toc      , 0xffff, 0x023c},
		{&&op_andi_16_aw       , 0xffff, 0x0278},
		{&&op_andi_16_al       , 0xffff, 0x0279},
		{&&op_andi_16_tos      , 0xffff, 0x027c},
		{&&op_andi_32_aw       , 0xffff, 0x02b8},
		{&&op_andi_32_al       , 0xffff, 0x02b9},
		{&&op_subi_8_pi7       , 0xffff, 0x041f},
		{&&op_subi_8_pd7       , 0xffff, 0x0427},
		{&&op_subi_8_aw        , 0xffff, 0x0438},
		{&&op_subi_8_al        , 0xffff, 0x0439},
		{&&op_subi_16_aw       , 0xffff, 0x0478},
		{&&op_subi_16_al       , 0xffff, 0x0479},
		{&&op_subi_32_aw       , 0xffff, 0x04b8},
		{&&op_subi_32_al       , 0xffff, 0x04b9},
		{&&op_addi_8_pi7       , 0xffff, 0x061f},
		{&&op_addi_8_pd7       , 0xffff, 0x0627},
		{&&op_addi_8_aw        , 0xffff, 0x0638},
		{&&op_addi_8_al        , 0xffff, 0x0639},
		{&&op_addi_16_aw       , 0xffff, 0x0678},
		{&&op_addi_16_al       , 0xffff, 0x0679},
		{&&op_addi_32_aw       , 0xffff, 0x06b8},
		{&&op_addi_32_al       , 0xffff, 0x06b9},
		{&&op_btst_8_s_pi7     , 0xffff, 0x081f},
		{&&op_btst_8_s_pd7     , 0xffff, 0x0827},
		{&&op_btst_8_s_aw      , 0xffff, 0x0838},
		{&&op_btst_8_s_al      , 0xffff, 0x0839},
		{&&op_btst_8_s_pcdi    , 0xffff, 0x083a},
		{&&op_btst_8_s_pcix    , 0xffff, 0x083b},
		{&&op_bchg_8_s_pi7     , 0xffff, 0x085f},
		{&&op_bchg_8_s_pd7     , 0xffff, 0x0867},
		{&&op_bchg_8_s_aw      , 0xffff, 0x0878},
		{&&op_bchg_8_s_al      , 0xffff, 0x0879},
		{&&op_bclr_8_s_pi7     , 0xffff, 0x089f},
		{&&op_bclr_8_s_pd7     , 0xffff, 0x08a7},
		{&&op_bclr_8_s_aw      , 0xffff, 0x08b8},
		{&&op_bclr_8_s_al      , 0xffff, 0x08b9},
		{&&op_bset_8_s_pi7     , 0xffff, 0x08df},
		{&&op_bset_8_s_pd7     , 0xffff, 0x08e7},
		{&&op_bset_8_s_aw      , 0xffff, 0x08f8},
		{&&op_bset_8_s_al      , 0xffff, 0x08f9},
		{&&op_eori_8_pi7       , 0xffff, 0x0a1f},
		{&&op_eori_8_pd7       , 0xffff, 0x0a27},
		{&&op_eori_8_aw        , 0xffff, 0x0a38},
		{&&op_eori_8_al        , 0xffff, 0x0a39},
		{&&op_eori_16_toc      , 0xffff, 0x0a3c},
		{&&op_eori_16_aw       , 0xffff, 0x0a78},
		{&&op_eori_16_al       , 0xffff, 0x0a79},
		{&&op_eori_16_tos      , 0xffff, 0x0a7c},
		{&&op_eori_32_aw       , 0xffff, 0x0ab8},
		{&&op_eori_32_al       , 0xffff, 0x0ab9},
		{&&op_cmpi_8_pi7       , 0xffff, 0x0c1f},
		{&&op_cmpi_8_pd7       , 0xffff, 0x0c27},
		{&&op_cmpi_8_aw        , 0xffff, 0x0c38},
		{&&op_cmpi_8_al        , 0xffff, 0x0c39},
		{&&op_cmpi_16_aw       , 0xffff, 0x0c78},
		{&&op_cmpi_16_al       , 0xffff, 0x0c79},
		{&&op_cmpi_32_aw       , 0xffff, 0x0cb8},
		{&&op_cmpi_32_al       , 0xffff, 0x0cb9},
		{&&op_move_8_aw_pi7    , 0xffff, 0x11df},
		{&&op_move_8_aw_pd7    , 0xffff, 0x11e7},
		{&&op_move_8_aw_aw     , 0xffff, 0x11f8},
		{&&op_move_8_aw_al     , 0xffff, 0x11f9},
		{&&op_move_8_aw_pcdi   , 0xffff, 0x11fa},
		{&&op_move_8_aw_pcix   , 0xffff, 0x11fb},
		{&&op_move_8_aw_i      , 0xffff, 0x11fc},
		{&&op_move_8_al_pi7    , 0xffff, 0x13df},
		{&&op_move_8_al_pd7    , 0xffff, 0x13e7},
		{&&op_move_8_al_aw     , 0xffff, 0x13f8},
		{&&op_move_8_al_al     , 0xffff, 0x13f9},
		{&&op_move_8_al_pcdi   , 0xffff, 0x13fa},
		{&&op_move_8_al_pcix   , 0xffff, 0x13fb},
		{&&op_move_8_al_i      , 0xffff, 0x13fc},
		{&&op_move_8_pi7_pi7   , 0xffff, 0x1edf},
		{&&op_move_8_pi7_pd7   , 0xffff, 0x1ee7},
		{&&op_move_8_pi7_aw    , 0xffff, 0x1ef8},
		{&&op_move_8_pi7_al    , 0xffff, 0x1ef9},
		{&&op_move_8_pi7_pcdi  , 0xffff, 0x1efa},
		{&&op_move_8_pi7_pcix  , 0xffff, 0x1efb},
		{&&op_move_8_pi7_i     , 0xffff, 0x1efc},
		{&&op_move_8_pd7_pi7   , 0xffff, 0x1f1f},
		{&&op_move_8_pd7_pd7   , 0xffff, 0x1f27},
		{&&op_move_8_pd7_aw    , 0xffff, 0x1f38},
		{&&op_move_8_pd7_al    , 0xffff, 0x1f39},
		{&&op_move_8_pd7_pcdi  , 0xffff, 0x1f3a},
		{&&op_move_8_pd7_pcix  , 0xffff, 0x1f3b},
		{&&op_move_8_pd7_i     , 0xffff, 0x1f3c},
		{&&op_move_32_aw_aw    , 0xffff, 0x21f8},
		{&&op_move_32_aw_al    , 0xffff, 0x21f9},
		{&&op_move_32_aw_pcdi  , 0xffff, 0x21fa},
		{&&op_move_32_aw_pcix  , 0xffff, 0x21fb},
		{&&op_move_32_aw_i     , 0xffff, 0x21fc},
		{&&op_move_32_al_aw    , 0xffff, 0x23f8},
		{&&op_move_32_al_al    , 0xffff, 0x23f9},
		{&&op_move_32_al_pcdi  , 0xffff, 0x23fa},
		{&&op_move_32_al_pcix  , 0xffff, 0x23fb},
		{&&op_move_32_al_i     , 0xffff, 0x23fc},
		{&&op_move_16_aw_aw    , 0xffff, 0x31f8},
		{&&op_move_16_aw_al    , 0xffff, 0x31f9},
		{&&op_move_16_aw_pcdi  , 0xffff, 0x31fa},
		{&&op_move_16_aw_pcix  , 0xffff, 0x31fb},
		{&&op_move_16_aw_i     , 0xffff, 0x31fc},
		{&&op_move_16_al_aw    , 0xffff, 0x33f8},
		{&&op_move_16_al_al    , 0xffff, 0x33f9},
		{&&op_move_16_al_pcdi  , 0xffff, 0x33fa},
		{&&op_move_16_al_pcix  , 0xffff, 0x33fb},
		{&&op_move_16_al_i     , 0xffff, 0x33fc},
		{&&op_negx_8_pi7       , 0xffff, 0x401f},
		{&&op_negx_8_pd7       , 0xffff, 0x4027},
		{&&op_negx_8_aw        , 0xffff, 0x4038},
		{&&op_negx_8_al        , 0xffff, 0x4039},
		{&&op_negx_16_aw       , 0xffff, 0x4078},
		{&&op_negx_16_al       , 0xffff, 0x4079},
		{&&op_negx_32_aw       , 0xffff, 0x40b8},
		{&&op_negx_32_al       , 0xffff, 0x40b9},
		{&&op_move_16_frs_aw   , 0xffff, 0x40f8},
		{&&op_move_16_frs_al   , 0xffff, 0x40f9},
		{&&op_clr_8_pi7        , 0xffff, 0x421f},
		{&&op_clr_8_pd7        , 0xffff, 0x4227},
		{&&op_clr_8_aw         , 0xffff, 0x4238},
		{&&op_clr_8_al         , 0xffff, 0x4239},
		{&&op_clr_16_aw        , 0xffff, 0x4278},
		{&&op_clr_16_al        , 0xffff, 0x4279},
		{&&op_clr_32_aw        , 0xffff, 0x42b8},
		{&&op_clr_32_al        , 0xffff, 0x42b9},
		{&&op_neg_8_pi7        , 0xffff, 0x441f},
		{&&op_neg_8_pd7        , 0xffff, 0x4427},
		{&&op_neg_8_aw         , 0xffff, 0x4438},
		{&&op_neg_8_al         , 0xffff, 0x4439},
		{&&op_neg_16_aw        , 0xffff, 0x4478},
		{&&op_neg_16_al        , 0xffff, 0x4479},
		{&&op_neg_32_aw        , 0xffff, 0x44b8},
		{&&op_neg_32_al        , 0xffff, 0x44b9},
		{&&op_move_16_toc_aw   , 0xffff, 0x44f8},
		{&&op_move_16_toc_al   , 0xffff, 0x44f9},
		{&&op_move_16_toc_pcdi , 0xffff, 0x44fa},
		{&&op_move_16_toc_pcix , 0xffff, 0x44fb},
		{&&op_move_16_toc_i    , 0xffff, 0x44fc},
		{&&op_not_8_pi7        , 0xffff, 0x461f},
		{&&op_not_8_pd7        , 0xffff, 0x4627},
		{&&op_not_8_aw         , 0xffff, 0x4638},
		{&&op_not_8_al         , 0xffff, 0x4639},
		{&&op_not_16_aw        , 0xffff, 0x4678},
		{&&op_not_16_al        , 0xffff, 0x4679},
		{&&op_not_32_aw        , 0xffff, 0x46b8},
		{&&op_not_32_al        , 0xffff, 0x46b9},
		{&&op_move_16_tos_aw   , 0xffff, 0x46f8},
		{&&op_move_16_tos_al   , 0xffff, 0x46f9},
		{&&op_move_16_tos_pcdi , 0xffff, 0x46fa},
		{&&op_move_16_tos_pcix , 0xffff, 0x46fb},
		{&&op_move_16_tos_i    , 0xffff, 0x46fc},
		{&&op_nbcd_8_pi7       , 0xffff, 0x481f},
		{&&op_nbcd_8_pd7       , 0xffff, 0x4827},
		{&&op_nbcd_8_aw        , 0xffff, 0x4838},
		{&&op_nbcd_8_al        , 0xffff, 0x4839},
		{&&op_pea_32_aw        , 0xffff, 0x4878},
		{&&op_pea_32_al        , 0xffff, 0x4879},
		{&&op_pea_32_pcdi      , 0xffff, 0x487a},
		{&&op_pea_32_pcix      , 0xffff, 0x487b},
		{&&op_movem_16_re_aw   , 0xffff, 0x48b8},
		{&&op_movem_16_re_al   , 0xffff, 0x48b9},
		{&&op_movem_32_re_aw   , 0xffff, 0x48f8},
		{&&op_movem_32_re_al   , 0xffff, 0x48f9},
		{&&op_tst_8_pi7        , 0xffff, 0x4a1f},
		{&&op_tst_8_pd7        , 0xffff, 0x4a27},
		{&&op_tst_8_aw         , 0xffff, 0x4a38},
		{&&op_tst_8_al         , 0xffff, 0x4a39},
		{&&op_tst_16_aw        , 0xffff, 0x4a78},
		{&&op_tst_16_al        , 0xffff, 0x4a79},
		{&&op_tst_32_aw        , 0xffff, 0x4ab8},
		{&&op_tst_32_al        , 0xffff, 0x4ab9},
		{&&op_tas_8_pi7        , 0xffff, 0x4adf},
		{&&op_tas_8_pd7        , 0xffff, 0x4ae7},
		{&&op_tas_8_aw         , 0xffff, 0x4af8},
		{&&op_tas_8_al         , 0xffff, 0x4af9},
		{&&op_illegal          , 0xffff, 0x4afc},
		{&&op_movem_16_er_aw   , 0xffff, 0x4cb8},
		{&&op_movem_16_er_al   , 0xffff, 0x4cb9},
		{&&op_movem_16_er_pcdi , 0xffff, 0x4cba},
		{&&op_movem_16_er_pcix , 0xffff, 0x4cbb},
		{&&op_movem_32_er_aw   , 0xffff, 0x4cf8},
		{&&op_movem_32_er_al   , 0xffff, 0x4cf9},
		{&&op_movem_32_er_pcdi , 0xffff, 0x4cfa},
		{&&op_movem_32_er_pcix , 0xffff, 0x4cfb},
		{&&op_link_16_a7       , 0xffff, 0x4e57},
		{&&op_unlk_32_a7       , 0xffff, 0x4e5f},
		{&&op_reset            , 0xffff, 0x4e70},
		{&&op_nop              , 0xffff, 0x4e71},
		{&&op_stop             , 0xffff, 0x4e72},
		{&&op_rte_32           , 0xffff, 0x4e73},
		{&&op_rts_32           , 0xffff, 0x4e75},
		{&&op_trapv            , 0xffff, 0x4e76},
		{&&op_rtr_32           , 0xffff, 0x4e77},
		{&&op_jsr_32_aw        , 0xffff, 0x4eb8},
		{&&op_jsr_32_al        , 0xffff, 0x4eb9},
		{&&op_jsr_32_pcdi      , 0xffff, 0x4eba},
		{&&op_jsr_32_pcix      , 0xffff, 0x4ebb},
		{&&op_jmp_32_aw        , 0xffff, 0x4ef8},
		{&&op_jmp_32_al        , 0xffff, 0x4ef9},
		{&&op_jmp_32_pcdi      , 0xffff, 0x4efa},
		{&&op_jmp_32_pcix      , 0xffff, 0x4efb},
		{&&op_st_8_pi7         , 0xffff, 0x50df},
		{&&op_st_8_pd7         , 0xffff, 0x50e7},
		{&&op_st_8_aw          , 0xffff, 0x50f8},
		{&&op_st_8_al          , 0xffff, 0x50f9},
		{&&op_sf_8_pi7         , 0xffff, 0x51df},
		{&&op_sf_8_pd7         , 0xffff, 0x51e7},
		{&&op_sf_8_aw          , 0xffff, 0x51f8},
		{&&op_sf_8_al          , 0xffff, 0x51f9},
		{&&op_shi_8_pi7        , 0xffff, 0x52df},
		{&&op_shi_8_pd7        , 0xffff, 0x52e7},
		{&&op_shi_8_aw         , 0xffff, 0x52f8},
		{&&op_shi_8_al         , 0xffff, 0x52f9},
		{&&op_sls_8_pi7        , 0xffff, 0x53df},
		{&&op_sls_8_pd7        , 0xffff, 0x53e7},
		{&&op_sls_8_aw         , 0xffff, 0x53f8},
		{&&op_sls_8_al         , 0xffff, 0x53f9},
		{&&op_scc_8_pi7        , 0xffff, 0x54df},
		{&&op_scc_8_pd7        , 0xffff, 0x54e7},
		{&&op_scc_8_aw         , 0xffff, 0x54f8},
		{&&op_scc_8_al         , 0xffff, 0x54f9},
		{&&op_scs_8_pi7        , 0xffff, 0x55df},
		{&&op_scs_8_pd7        , 0xffff, 0x55e7},
		{&&op_scs_8_aw         , 0xffff, 0x55f8},
		{&&op_scs_8_al         , 0xffff, 0x55f9},
		{&&op_sne_8_pi7        , 0xffff, 0x56df},
		{&&op_sne_8_pd7        , 0xffff, 0x56e7},
		{&&op_sne_8_aw         , 0xffff, 0x56f8},
		{&&op_sne_8_al         , 0xffff, 0x56f9},
		{&&op_seq_8_pi7        , 0xffff, 0x57df},
		{&&op_seq_8_pd7        , 0xffff, 0x57e7},
		{&&op_seq_8_aw         , 0xffff, 0x57f8},
		{&&op_seq_8_al         , 0xffff, 0x57f9},
		{&&op_svc_8_pi7        , 0xffff, 0x58df},
		{&&op_svc_8_pd7        , 0xffff, 0x58e7},
		{&&op_svc_8_aw         , 0xffff, 0x58f8},
		{&&op_svc_8_al         , 0xffff, 0x58f9},
		{&&op_svs_8_pi7        , 0xffff, 0x59df},
		{&&op_svs_8_pd7        , 0xffff, 0x59e7},
		{&&op_svs_8_aw         , 0xffff, 0x59f8},
		{&&op_svs_8_al         , 0xffff, 0x59f9},
		{&&op_spl_8_pi7        , 0xffff, 0x5adf},
		{&&op_spl_8_pd7        , 0xffff, 0x5ae7},
		{&&op_spl_8_aw         , 0xffff, 0x5af8},
		{&&op_spl_8_al         , 0xffff, 0x5af9},
		{&&op_smi_8_pi7        , 0xffff, 0x5bdf},
		{&&op_smi_8_pd7        , 0xffff, 0x5be7},
		{&&op_smi_8_aw         , 0xffff, 0x5bf8},
		{&&op_smi_8_al         , 0xffff, 0x5bf9},
		{&&op_sge_8_pi7        , 0xffff, 0x5cdf},
		{&&op_sge_8_pd7        , 0xffff, 0x5ce7},
		{&&op_sge_8_aw         , 0xffff, 0x5cf8},
		{&&op_sge_8_al         , 0xffff, 0x5cf9},
		{&&op_slt_8_pi7        , 0xffff, 0x5ddf},
		{&&op_slt_8_pd7        , 0xffff, 0x5de7},
		{&&op_slt_8_aw         , 0xffff, 0x5df8},
		{&&op_slt_8_al         , 0xffff, 0x5df9},
		{&&op_sgt_8_pi7        , 0xffff, 0x5edf},
		{&&op_sgt_8_pd7        , 0xffff, 0x5ee7},
		{&&op_sgt_8_aw         , 0xffff, 0x5ef8},
		{&&op_sgt_8_al         , 0xffff, 0x5ef9},
		{&&op_sle_8_pi7        , 0xffff, 0x5fdf},
		{&&op_sle_8_pd7        , 0xffff, 0x5fe7},
		{&&op_sle_8_aw         , 0xffff, 0x5ff8},
		{&&op_sle_8_al         , 0xffff, 0x5ff9},
		{&&op_bra_16           , 0xffff, 0x6000},
		{&&op_bsr_16           , 0xffff, 0x6100},
		{&&op_bhi_16           , 0xffff, 0x6200},
		{&&op_bls_16           , 0xffff, 0x6300},
		{&&op_bcc_16           , 0xffff, 0x6400},
		{&&op_bcs_16           , 0xffff, 0x6500},
		{&&op_bne_16           , 0xffff, 0x6600},
		{&&op_beq_16           , 0xffff, 0x6700},
		{&&op_bvc_16           , 0xffff, 0x6800},
		{&&op_bvs_16           , 0xffff, 0x6900},
		{&&op_bpl_16           , 0xffff, 0x6a00},
		{&&op_bmi_16           , 0xffff, 0x6b00},
		{&&op_bge_16           , 0xffff, 0x6c00},
		{&&op_blt_16           , 0xffff, 0x6d00},
		{&&op_bgt_16           , 0xffff, 0x6e00},
		{&&op_ble_16           , 0xffff, 0x6f00},
		{&&op_sbcd_8_mm_axy7   , 0xffff, 0x8f0f},
		{&&op_subx_8_mm_axy7   , 0xffff, 0x9f0f},
		{&&op_cmpm_8_axy7      , 0xffff, 0xbf0f},
		{&&op_abcd_8_mm_axy7   , 0xffff, 0xcf0f},
		{&&op_addx_8_mm_axy7   , 0xffff, 0xdf0f},
		{&&op_asr_16_aw        , 0xffff, 0xe0f8},
		{&&op_asr_16_al        , 0xffff, 0xe0f9},
		{&&op_asl_16_aw        , 0xffff, 0xe1f8},
		{&&op_asl_16_al        , 0xffff, 0xe1f9},
		{&&op_lsr_16_aw        , 0xffff, 0xe2f8},
		{&&op_lsr_16_al        , 0xffff, 0xe2f9},
		{&&op_lsl_16_aw        , 0xffff, 0xe3f8},
		{&&op_lsl_16_al        , 0xffff, 0xe3f9},
		{&&op_roxr_16_aw       , 0xffff, 0xe4f8},
		{&&op_roxr_16_al       , 0xffff, 0xe4f9},
		{&&op_roxl_16_aw       , 0xffff, 0xe5f8},
		{&&op_roxl_16_al       , 0xffff, 0xe5f9},
		{&&op_ror_16_aw        , 0xffff, 0xe6f8},
		{&&op_ror_16_al        , 0xffff, 0xe6f9},
		{&&op_rol_16_aw        , 0xffff, 0xe7f8},
		{&&op_rol_16_al        , 0xffff, 0xe7f9},

		{&&op_illegal          , 0x0000, 0x0000}
	};

	opcode_struct *ostruct;
	int i, j, instr;

	ostruct = c68k_opcode_jump_table;

	while (ostruct->match != 0x4afc)
		ostruct++;

	for (i = 0; i < 0x10000; i++)
	{
		JumpTable[i] = ostruct->label;
	}

	ostruct = c68k_opcode_jump_table;

	while (ostruct->mask != 0xff00)
	{
		for (i = 0; i < 0x10000; i++)
		{
			if ((i & ostruct->mask) == ostruct->match)
			{
				JumpTable[i] = ostruct->label;
			}
		}
		ostruct++;
	}

	while (ostruct->mask == 0xff00)
	{
		for (i = 0; i <= 0xff; i++)
		{
			instr = ostruct->match | i;
			JumpTable[instr] = ostruct->label;
		}
		ostruct++;
	}

	while (ostruct->mask == 0xf1f8)
	{
		for (i = 0; i < 8; i++)
		{
			for (j = 0; j < 8; j++)
			{
				instr = ostruct->match | (i << 9) | j;
				JumpTable[instr] = ostruct->label;
			}
		}
		ostruct++;
	}

	while (ostruct->mask == 0xfff0)
	{
		for (i = 0; i <= 0x0f; i++)
		{
			instr = ostruct->match | i;
			JumpTable[instr] = ostruct->label;
		}
		ostruct++;
	}

	while (ostruct->mask == 0xf1ff)
	{
		for (i = 0; i <= 0x07; i++)
		{
			instr = ostruct->match | (i << 9);
			JumpTable[instr] = ostruct->label;
		}
		ostruct++;
	}

	while (ostruct->mask == 0xfff8)
	{
		for (i = 0; i <= 0x07; i++)
		{
			instr = ostruct->match | i;
			JumpTable[instr] = ostruct->label;
		}
		ostruct++;
	}

	while (ostruct->mask == 0xffff)
	{
		instr = ostruct->match;
		JumpTable[instr] = ostruct->label;
		ostruct++;
	}
