#!/bin/sh

CFG_DIR=$HOME/.cps2-gui
CFG_FILE=$CFG_DIR/cps2-gui.cfg
LOG_FILE=$CFG_DIR/cps2-output.log
mkdir -p $CFG_DIR 2> /dev/null
if [ ! -r $CFG_FILE ]
then
	echo "exec_path /usr/bin" > $CFG_FILE
	echo "exit_after_launch false" >> $CFG_FILE
	echo "rom_path notset" >> $CFG_FILE
	echo "sound true" >> $CFG_FILE
	echo "samplerate 22050" >> $CFG_FILE
	echo "showfps false" >> $CFG_FILE
	echo "68kclock 0" >> $CFG_FILE
	echo "z80clock 0" >> $CFG_FILE
	echo "linescroll true" >> $CFG_FILE
	echo "save_hs true" >> $CFG_FILE
	echo "rescaling hw-rescale" >> $CFG_FILE
	echo "extinput false" >> $CFG_FILE
fi
# Set missing values
grep ^exit_after_launch $CFG_FILE >/dev/null || echo "exit_after_launch false" >> $CFG_FILE
grep ^exec_path $CFG_FILE >/dev/null || echo "exec_path /usr/bin" >> $CFG_FILE
grep ^rom_path $CFG_FILE >/dev/null || echo "rom_path notset" >> $CFG_FILE
grep ^sound $CFG_FILE >/dev/null || echo "sound true" >> $CFG_FILE
grep ^samplerate $CFG_FILE >/dev/null || echo "samplerate 22050" >> $CFG_FILE
grep ^showfps $CFG_FILE >/dev/null || echo "showfps false" >> $CFG_FILE
grep ^68kclock $CFG_FILE >/dev/null || echo "68kclock 0" >> $CFG_FILE
grep ^z80clock $CFG_FILE >/dev/null || echo "z80clock 0" >> $CFG_FILE
grep ^linescroll $CFG_FILE >/dev/null || echo "linescroll true" >> $CFG_FILE
grep ^save_hs $CFG_FILE >/dev/null || echo "save_hs true" >> $CFG_FILE
grep ^rescaling $CFG_FILE >/dev/null || echo "rescaling hw-rescale" >> $CFG_FILE
grep ^extinput $CFG_FILE >/dev/null || echo "extinput false" >> $CFG_FILE
 
cd /opt/cps2-gui/
python cps2-gui.py
