/*
 * Copyright (c) 2008 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>

#include "connection-switcher-statusbar.h"
#include <nm_main_dialog.h>

#define CONNECTION_SWITCHER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, \
                            TYPE_CONNECTION_SWITCHER, ConnectionSwitcherPrivate))

struct _ConnectionSwitcherPrivate
{
    GtkWidget *label;
    gpointer data;
};

HD_DEFINE_PLUGIN_MODULE (ConnectionSwitcher, connection_switcher, HD_TYPE_STATUS_MENU_ITEM);

static void connection_switcher_cb (gpointer, gpointer);

static void
connection_switcher_class_finalize (ConnectionSwitcherClass *klass) {}

static void
connection_switcher_class_init (ConnectionSwitcherClass *klass)
{
    g_type_class_add_private (klass, sizeof (ConnectionSwitcherPrivate));
}

static void
connection_switcher_init (ConnectionSwitcher *plugin)
{
    plugin->priv = CONNECTION_SWITCHER_GET_PRIVATE (plugin);
    
    /* Put the icon at the status bar*/
    GdkPixbuf *pixbuf = gdk_pixbuf_new_from_file_at_size ("/usr/share/icons/hicolor/scalable/hildon/connection-switcher.png",
                                                          STATUS_AREA_CONNECTION_SWITCHER_ICON_SIZE, 
                                                          STATUS_AREA_CONNECTION_SWITCHER_ICON_SIZE, 
                                                          NULL);
                                                           
    hd_status_plugin_item_set_status_area_icon (HD_STATUS_PLUGIN_ITEM (plugin), pixbuf);
    g_object_unref (pixbuf);
    
    /* Define the button to show on the menu */
    
    GtkWidget *image = gtk_image_new_from_file ("/usr/share/icons/hicolor/scalable/hildon/connection-switcher.png");
    
    GtkWidget *b = hildon_button_new (HILDON_SIZE_FINGER_HEIGHT, 
                                      HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    
    hildon_button_set_style (HILDON_BUTTON(b), 
                             HILDON_BUTTON_STYLE_PICKER);
    hildon_button_set_image (HILDON_BUTTON(b),
                             image);
    hildon_button_set_title (HILDON_BUTTON(b), "Connection Switcher");
    hildon_button_set_alignment (HILDON_BUTTON(b),
                                 0.0, 0.0, 1.0, 1.0);
    // hildon_button_set_value (HILDON_BUTTON(b), 
    //                          nm_environment_manager_get_active());
    
    g_signal_connect_after (G_OBJECT (b), "clicked",
                       G_CALLBACK (connection_switcher_cb), plugin);
                       
    gtk_widget_show_all (b);

    plugin->priv->label = b;

    gtk_container_add (GTK_CONTAINER (plugin), plugin->priv->label);

    gtk_widget_show_all (plugin->priv->label);

    gtk_widget_show (GTK_WIDGET (plugin));
}

static void 
connection_switcher_cb (gpointer instance, gpointer self) 
{
    GtkWidget *dialog;
    dialog = nm_main_dialog_new();

    nm_main_dialog_run(NM_MAIN_DIALOG(dialog), NM_STATUS_MENU);

    /* Free the dialog (and it's children) */
    gtk_widget_destroy(GTK_WIDGET(dialog));
}

