#ifndef CONFIGREADER_H
#define CONFIGREADER_H

#include <QMainWindow>
#include <QProcess>
#include <QDir>
#include <QFile>
#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>

class aboutDialog;
class settingsDialog;
class processDialog;
class compareDialog;

namespace Ui {
    class configReader;
}

class configReader : public QMainWindow
{
    Q_OBJECT

public:
    explicit configReader(QWidget *parent = 0);
    ~configReader();

    // processDialog, writeWindow
    QString outData;
    // settingsDialog, writeWindow
    QString dateFormat;
    QString dateFormatTitle;
    bool carAnim;
    // settingsDialog
    QString dateSep;
    // compareDialog, writeWindow
    QDir saveDir;
    QFile fileWithPath1;
    QFile fileWithPath2;
    QString fileCont1;
    QString fileCont2;
    // compareDialog, processDialog, writeWindow
    QString cameFrom;

    // settingsDialog
    void setDateFormatTitle();

public slots:
    void saveDirReadReady();
    void sepReadReady();
    void dateReadReady();

    void openProcDialog();
    void openCompDialog();

    void createAboutDialog();
    void createAboutQtDialog();
    void createSettingsDialog();

private:
    Ui::configReader *ui;

    int i;

    QString saveDirConf;
    QString dateSepConf;

    QProcess saveDirProcess;
    QProcess sepProcess;
    QProcess dateProcess;

    QMenuBar crMenu;
    aboutDialog *abtDialog;
    settingsDialog *settDialog;
    processDialog *procDialog;
    compareDialog *compDialog;

    void setupCRMenu();
    void getSaveDir();
    void getSep();
    void getDateFormat();
};

#endif // CONFIGREADER_H
