#include "comparedialog.h"
#include "ui_comparedialog.h"

#include "configreader.h"
#include "ui_configreader.h"

#include "writewindow.h"
#include "ui_writewindow.h"

compareDialog::compareDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::compareDialog)
{
    // compareParent is a pointer to compareDialog's parent (configReader)
    compareParent = (configReader*) parent;

    ui->setupUi(this);
    // Setup the button box, don't add the "Start" button yet
    ui->btnBox->addButton("Cancel", QDialogButtonBox::NoRole);

    // Setup the File buttons
    ui->fileBtn1->setMinimumWidth(575);
    ui->fileBtn2->setMinimumWidth(575);
    ui->fileBtn1->setStyleSheet("color: deepskyblue;");
    ui->fileBtn2->setStyleSheet("color: deepskyblue;");

    // Hide the Swap button + warning by default
    ui->swapBtn->hide();
    ui->warningLbl->hide();
    this->adjustSize();

    // Clear the QFiles before start
    compareParent->fileWithPath1.setFileName("");
    compareParent->fileWithPath2.setFileName("");

    connect(ui->fileBtn1, SIGNAL(clicked()),
            this, SLOT(openFile1()));
    connect(ui->fileBtn2, SIGNAL(clicked()),
            this, SLOT(openFile2()));
    connect(ui->swapBtn, SIGNAL(clicked()),
            this, SLOT(swapFiles()));

    // btnBox
    connect(ui->btnBox, SIGNAL(rejected()),
            this, SLOT(close()));
    connect(ui->btnBox, SIGNAL(accepted()),
            this, SLOT(readFiles()));
}

compareDialog::~compareDialog()
{
    delete ui;
}





void compareDialog::checkFiles() {
    if(compareParent->fileWithPath1.exists() &&
       compareParent->fileWithPath2.exists()) {
        // Clear the button box, hide the Swap button + warning
        ui->btnBox->clear();
        ui->swapBtn->hide();
        ui->warningLbl->hide();

        // Get last modified date
        fileDateTime1 = QFileInfo(compareParent->fileWithPath1).lastModified();
        fileDateTime2 = QFileInfo(compareParent->fileWithPath2).lastModified();

        // File 1 needs to be older than File 2
        if(fileDateTime1 < fileDateTime2)
            ui->btnBox->addButton("Start", QDialogButtonBox::AcceptRole);
        else if(fileDateTime1 == fileDateTime2) {
            if(compareParent->fileWithPath1.fileName() == compareParent->fileWithPath2.fileName()) {
                // User selected the same file twice
                ui->warningLbl->show();
                ui->warningLbl->setText("Warning: File 1 is the same as File 2 (select another)");
            }
            else
                ui->btnBox->addButton("Start", QDialogButtonBox::AcceptRole);
        }
        else {
            ui->swapBtn->show();
            ui->warningLbl->show();
            ui->warningLbl->setText("Warning: File 1 is newer than File 2 (press 'Swap')");
        }

        // Add the "Cancel" button in any case
        ui->btnBox->addButton("Cancel", QDialogButtonBox::NoRole);

        // Adjust the size to the possibly new contents
        this->adjustSize();
    }
}





void compareDialog::openFile1() {
    compareParent->fileWithPath1.setFileName(QFileDialog::getOpenFileName(this,
                                                           "Select file 1:",
                                                           compareParent->saveDir.absolutePath()));

    // Only go on if it exists
    if(compareParent->fileWithPath1.exists()) {
        // Set global saveDir and buttontext
        compareParent->saveDir = QFileInfo(compareParent->fileWithPath1).absoluteDir();
        ui->fileBtn1->setText(QFileInfo(compareParent->fileWithPath1).fileName());
        // Save the new selected directory to GConf
        system("gconftool -s /apps/maemo/configreader/save_dir -t string " + compareParent->saveDir.absolutePath().toAscii());
    }

    checkFiles();
}





void compareDialog::openFile2() {
    compareParent->fileWithPath2.setFileName(QFileDialog::getOpenFileName(this,
                                                           "Select file 2:",
                                                           compareParent->saveDir.absolutePath()));

    // Only go on if it exists
    if(compareParent->fileWithPath2.exists()) {
        // Set global saveDir and buttontext
        compareParent->saveDir = QFileInfo(compareParent->fileWithPath2).absoluteDir();
        ui->fileBtn2->setText(QFileInfo(compareParent->fileWithPath2).fileName());
        // Save the new selected directory to GConf
        system("gconftool -s /apps/maemo/configreader/save_dir -t string " + compareParent->saveDir.absolutePath().toAscii());
    }

    checkFiles();
}





void compareDialog::swapFiles() {
    // Swap File 1 and File 2
    swapFile1.setFileName(compareParent->fileWithPath1.fileName());
    swapFile2.setFileName(compareParent->fileWithPath2.fileName());

    compareParent->fileWithPath1.setFileName(swapFile2.fileName());
    compareParent->fileWithPath2.setFileName(swapFile1.fileName());

    // Update the buttons
    ui->fileBtn1->setText(QFileInfo(compareParent->fileWithPath1).fileName());
    ui->fileBtn2->setText(QFileInfo(compareParent->fileWithPath2).fileName());

    checkFiles();
}





void compareDialog::readFile1() {
    // Empty fileContStrm and compareParent->fileCont1 before use
    fileContStrm.flush();
    compareParent->fileCont1.clear();

    // Open File1 (read-only) and set textstream
    compareParent->fileWithPath1.open(QFile::ReadOnly);
    fileContStrm.setDevice(&compareParent->fileWithPath1);

    // Read fileWithPath1 entirely, save it in compareParent->fileCont1
    while( ! fileContStrm.atEnd()) {
        compareParent->fileCont1.append(fileContStrm.readLine() + "\n");
    }

    compareParent->fileWithPath1.close();
}





void compareDialog::readFile2() {
    // Empty fileContStrm and compareParent->fileCont2 before use
    fileContStrm.flush();
    compareParent->fileCont2.clear();

    // Open File2 (read-only) and set textstream
    compareParent->fileWithPath2.open(QFile::ReadOnly);
    fileContStrm.setDevice(&compareParent->fileWithPath2);

    // Read fileWithPath2 entirely, save it in compareParent->fileCont2
    while( ! fileContStrm.atEnd()) {
        compareParent->fileCont2.append(fileContStrm.readLine() + "\n");
    }

    compareParent->fileWithPath2.close();
}





void compareDialog::readFiles() {
    // Read the HTML files
    readFile1();
    readFile2();

    // Close this dialog and open writeWindow
    this->close();
    openWriteWin();
}





void compareDialog::openWriteWin() {
    // Open writeWindow for HTML wrting
    writeWin = new writeWindow(compareParent);
    writeWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    writeWin->setAttribute(Qt::WA_DeleteOnClose);
    compareParent->cameFrom = "compare";
    writeWin->show();
}
