import gobject
import hildon
import hildondesktop
import gtk
import csv
import urllib2
import string
import os
import osso
import cairo
import datetime
import shutil
import sys
import socket

socket.setdefaulttimeout(30)

supports_alpha = False

# LOGGING!
# sys.stdout = open('/home/user/.comic-widget/output_log.txt', 'a')
# sys.stderr = open('/home/user/.comic-widget/error_log.txt', 'a')
# print "Start logging!"

# constants. dbfile is the location of the csv
# comiccache is the location of the images
APP_VERSION = "0.4.1-1"

basedbdir = "/opt/comic-widget/db/"
imagedir = "/opt/comic-widget/images/"
dbdir = "/home/user/.comic-widget/"
activecomics = dbdir + "activecomics.cfg"
comiccache = "/home/user/MyDocs/.comics/"
defaultcomics = ['xkcd','wulff','sinfest']
comics = {
		"9_chickweed_lanecomicscom":{"name":"9 Chickweed Lane","link":"http://comics.com/9_chickweed_lane/","start":"2010-02-01","dbfile":dbdir + "comicdb.9chickweedlane.csv"},
		"agnescomicscom":{"name":"Agnes","link":"http://comics.com/agnes/","start":"2010-02-01","dbfile":dbdir + "comicdb.agnes.csv"},
		"andy_cappcomicscom":{"name":"Andy Capp","link":"http://comics.com/andy_capp/","start":"2010-02-01","dbfile":dbdir + "comicdb.andycapp.csv"},
		"alley_oopcomicscom":{"name":"Alley Oop","link":"http://comics.com/alley_oop/","start":"2010-02-01","dbfile":dbdir + "comicdb.alleyoop.csv"},
		"arlonjaniscomicscom":{"name":"Arlo and Janis","link":'http://comics.com/arlo&janis/',"start":"2010-02-01","dbfile":dbdir + "comicdb.arlonjanis.csv"},
		"bccomicscom":{"name":"B.C.","link":"http://comics.com/bc/","start":"2010-02-01","dbfile":dbdir + "comicdb.bc.csv"},
		"ballard_streetcomicscom":{"name":"Ballard Street","link":"http://comics.com/ballard_street/","start":"2010-02-01","dbfile":dbdir + "comicdb.ballardstreet.csv"},
		"babyblues":{"name":"Baby Blues","link":"http://www.babyblues.com/","start":"01/19/2010","dbfile":dbdir + "comicdb.babyblues.csv"},
		"bencomicscom":{"name":"Ben","link":'http://comics.com/ben/',"start":"2010-02-01","dbfile":dbdir + "comicdb.ben.csv"},
		"bettycomicscom":{"name":"Betty","link":"http://comics.com/betty/","start":"2010-02-01","dbfile":dbdir + "comicdb.betty.csv"},
		"big_natecomicscom":{"name":"Big Nate","link":"http://comics.com/big_nate/","start":"2010-02-01","dbfile":dbdir + "comicdb.bignate.csv"},
		"brevitycomicscom":{"name":"Brevity","link":"http://comics.com/brevity/","start":"2010-02-01","dbfile":dbdir + "comicdb.brevity.csv"},
		"candorvillecomicscom":{"name":"Candorville","link":"http://comics.com/candorville/","start":"2010-02-01","dbfile":dbdir + "comicdb.candorville.csv"},
		"cheap_thrillscomicscom":{"name":"Cheap Thrills","link":"http://comics.com/cheap_thrills/","start":"2010-02-01","dbfile":dbdir + "comicdb.cheapthrills.csv"},
		"committedcomicscom":{"name":"Committed","link":"http://comics.com/committed/","start":"2010-02-01","dbfile":dbdir + "comicdb.committed.csv"},
		"cownboycomicscom":{"name":"Cow and Boy","link":'http://comics.com/cow&boy/',"start":"2010-02-01","dbfile":dbdir + "comicdb.cownboy.csv"},
		"cyanide":{"name":"Cyanide and Happiness","link":"http://explosm.com/","start":"1920","dbfile":dbdir + "comicdb.cyanide.csv"},
		"daddyshomecomicscom":{"name":"Daddy's Home","link":"http://comics.com/daddys_home/","start":"2010-02-01","dbfile":dbdir + "comicdb.daddyshome.csv"},
		"dilbert":{"name":"Dilbert","link":"http://dilbert.com/","start":"2010-01-01","dbfile":dbdir + "comicdb.dilbert.csv"},
		"dog_eat_dougcomicscom":{"name":"Dog eat Doug","link":"http://comics.com/dog_eat_doug/","start":"2010-02-01","dbfile":dbdir + "comicdb.dogeatdoug.csv"},
		"drabblecomicscom":{"name":"Drabble","link":"http://comics.com/drabble/","start":"2010-02-01","dbfile":dbdir + "comicdb.drabble.csv"},
		"f_minuscomicscom":{"name":"F Minus","link":"http://comics.com/f_minus/","start":"2010-02-01","dbfile":dbdir + "comicdb.f_minus.csv"},
		"family_treecomicscom":{"name":"Family Tree","link":"http://comics.com/family_tree/","start":"2010-02-01","dbfile":dbdir + "comicdb.familytree.csv"},
		"farcuscomicscom":{"name":"Farcus","link":'http://comics.com/farcus/',"start":"2010-02-01","dbfile":dbdir + "comicdb.farcus.csv"},
		"fat_catscomicscom":{"name":"Fat Cats","link":'http://comics.com/fat_cats_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.fatcats.csv"},
		"ferdnandcomicscom":{"name":"Ferd'nand","link":'http://comics.com/ferdnand/',"start":"2010-02-01","dbfile":dbdir + "comicdb.ferdnand.csv"},
		"flight_deckcomicscom":{"name":"Flight_Deck","link":'http://comics.com/flight_deck/',"start":"2010-02-01","dbfile":dbdir + "comicdb.flightdeck.csv"},
		"flonfriendscomicscom":{"name":"Flo and Friends","link":'http://comics.com/flo&friends/',"start":"2010-02-01","dbfile":dbdir + "comicdb.flonfriends.csv"},
		"fort_knoxcomicscom":{"name":"Fort Knox","link":'http://comics.com/fort_knox/',"start":"2010-02-01","dbfile":dbdir + "comicdb.fortknox.csv"},
		"franknernestcomicscom":{"name":"Frank and Ernest","link":'http://comics.com/frank&ernest/',"start":"2010-02-01","dbfile":dbdir + "comicdb.franknernest.csv"},
		"frazzcomicscom":{"name":"Frazz","link":"http://comics.com/frazz/","start":"2010-02-01","dbfile":dbdir + "comicdb.frazz.csv"},
		"free_rangecomicscom":{"name":"Free Range","link":'http://comics.com/free_range/',"start":"2010-02-01","dbfile":dbdir + "comicdb.freerange.csv"},
		"geechcomicscom":{"name":"Geech","link":'http://comics.com/geech_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.geech.csv"},
		"getfuzzycomicscom":{"name":"Get Fuzzy","link":"http://comics.com/get_fuzzy/","start":"2010-02-01","dbfile":dbdir + "comicdb.getfuzzy.csv"},
		"girlsnsportscomicscom":{"name":"Girls and Sports","link":'http://comics.com/girls&sports/',"start":"2010-02-01","dbfile":dbdir + "comicdb.gitlsnsports.csv"},
		"graffiticomicscom":{"name":"Graffiti","link":'http://comics.com/graffiti/',"start":"2010-02-01","dbfile":dbdir + "comicdb.graffiti.csv"},
		"grand_avenuecomicscom":{"name":"Grand Avenue","link":'http://comics.com/grand_avenue/',"start":"2010-02-01","dbfile":dbdir + "comicdb.grandavenue.csv"},
		"heathcliffcomicscom":{"name":"Heathcliff","link":'http://comics.com/heathcliff/',"start":"2010-02-01","dbfile":dbdir + "comicdb.heathcliff.csv"},
		"herb_and_jamaalcomicscom":{"name":"Herb and Jamaal","link":'http://comics.com/herb_and_jamaal/',"start":"2010-02-01","dbfile":dbdir + "comicdb.herbandjamaal.csv"},
		"hermancomicscom":{"name":"Herman","link":'http://comics.com/herman/',"start":"2010-02-01","dbfile":dbdir + "comicdb.herman.csv"},
		"home_and_awaycomicscom":{"name":"Home and Away","link":'http://comics.com/home_and_away/',"start":"2010-02-01","dbfile":dbdir + "comicdb.homeandaway.csv"},
		"its_all_about_youcomicscom":{"name":"It's All About You","link":'http://comics.com/its_all_about_you/',"start":"2010-02-01","dbfile":dbdir + "comicdb.itsallaboutyou.csv"},
		"janes_worldcomicscom":{"name":"Jane's World","link":'http://comics.com/janes_world/',"start":"2010-02-01","dbfile":dbdir + "comicdb.janesworld.csv"},
		"jump_startcomicscom":{"name":"Jump Start","link":'http://comics.com/jump_start/',"start":"2010-02-01","dbfile":dbdir + "comicdb.jumpstart.csv"},
		"kit_n_carlylecomicscom":{"name":"Kit 'n' Carlyle","link":'http://comics.com/kit_n_carlyle/',"start":"2010-02-01","dbfile":dbdir + "comicdb.kitncarlyle.csv"},
		"lil_abnercomicscom":{"name":"Li'l Abner","link":'http://comics.com/lil_abner_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.lilabner.csv"},
		"liberty_meadowscomicscom":{"name":"Liberty Meadows","link":'http://comics.com/liberty_meadows/',"start":"2010-02-01","dbfile":dbdir + "comicdb.libertymeadows.csv"},
		"little_dog_lostcomicscom":{"name":"Little Dog Lost","link":'http://comics.com/little_dog_lost/',"start":"2010-02-01","dbfile":dbdir + "comicdb.littledoglost.csv"},
		"lolacomicscom":{"name":"Lola","link":'http://comics.com/lola/',"start":"2010-02-01","dbfile":dbdir + "comicdb.lola.csv"},
		"luanncomicscom":{"name":"Luann","link":'http://comics.com/luann/',"start":"2010-02-01","dbfile":dbdir + "comicdb.luann.csv"},
		"marmadukecomicscom":{"name":"Marmaduke","link":'http://comics.com/marmaduke/',"start":"2010-02-01","dbfile":dbdir + "comicdb.marmaduke.csv"},
		"megcomicscom":{"name":"Meg","link":'http://comics.com/meg_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.meg.csv"},
		"minimum_securitycomicscom":{"name":"Minimum Security","link":'http://comics.com/minimum_security/',"start":"2010-02-01","dbfile":dbdir + "comicdb.minimumsecurity.csv"},
		"moderately_confusedcomicscom":{"name":"Moderately Confused","link":'http://comics.com/moderately_confused/',"start":"2010-02-01","dbfile":dbdir + "comicdb.moderatelyconfused.csv"},
		"mommacomicscom":{"name":"Momma","link":'http://comics.com/momma/',"start":"2010-02-01","dbfile":dbdir + "comicdb.momma.csv"},
		"motleycomicscom":{"name":"Motley","link":'http://comics.com/motley_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.motley.csv"},
		"nancycomicscom":{"name":"Nancy","link":'http://comics.com/nancy/',"start":"2010-02-01","dbfile":dbdir + "comicdb.nancy.csv"},
		"natural_selectioncomicscom":{"name":"Natural Selection","link":'http://comics.com/natural_selection/',"start":"2010-02-01","dbfile":dbdir + "comicdb.naturalselection.csv"},
		"nest_headscomicscom":{"name":"Nest Heads","link":'http://comics.com/nest_heads/',"start":"2010-02-01","dbfile":dbdir + "comicdb.nestheads.csv"},
		"off_the_markcomicscom":{"name":"Off the mark","link":"http://comics.com/off_the_mark/","start":"2010-02-01","dbfile":dbdir + "comicdb.offthemark.csv"},
		"on_a_claire_daycomicscom":{"name":"On A Claire Day","link":'http://comics.com/on_a_claire_day/',"start":"2010-02-01","dbfile":dbdir + "comicdb.onaclaireday.csv"},
		"one_big_happycomicscom":{"name":"One Big Happy","link":'http://comics.com/one_big_happy_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.onebighappy.csv"},
		"over_the_hedgecomicscom":{"name":"Over the Hedge","link":'http://comics.com/over_the_hedge/',"start":"2010-02-01","dbfile":dbdir + "comicdb.overthehedge.csv"},
		"pc_and_pixelcomicscom":{"name":"PC and Pixel","link":'http://comics.com/pc_and_pixel/',"start":"2010-02-01","dbfile":dbdir + "comicdb.pcandpixel.csv"},
		"peanutscomicscom":{"name":"Peanuts","link":"http://comics.com/peanuts/","start":"2010-02-01","dbfile":dbdir + "comicdb.peanuts.csv"},
		"pearls_before_swinecomicscom":{"name":"Pearls Before Swine","link":'http://comics.com/pearls_before_swine/',"start":"2010-02-01","dbfile":dbdir + "comicdb.pearlsbeforeswine.csv"},
		"phd":{"name":"PHD Comics","link":"http://www.phdcomics.com/","start":1240,"dbfile":dbdir + "comicdb.phd.csv"},
		"picklescomicscom":{"name":"Pickles","link":'http://comics.com/pickles/',"start":"2010-02-01","dbfile":dbdir + "comicdb.pickles.csv"},
		"prickly_citycomicscom":{"name":"Prickly City","link":'http://comics.com/prickly_city/',"start":"2010-02-01","dbfile":dbdir + "comicdb.pricklycity.csv"},
		"raising_duncancomicscom":{"name":"Raising Duncan","link":'http://comics.com/raising_duncan_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.raisingduncan.csv"},
		"reality_checkcomicscom":{"name":"Reality Check","link":'http://comics.com/reality_check/',"start":"2010-02-01","dbfile":dbdir + "comicdb.realitycheck.csv"},
		"rednrovercomicscom":{"name":"Red and Rover","link":'http://comics.com/red&rover/',"start":"2010-02-01","dbfile":dbdir + "comicdb.rednrover.csv"},
		"rip_haywirecomicscom":{"name":"Rip Haywire","link":'http://comics.com/rip_haywire/',"start":"2010-02-01","dbfile":dbdir + "comicdb.riphaywire.csv"},
		"ripleys_believe_it_or_notcomicscom":{"name":"Ripley's Believe it or not","link":'http://comics.com/ripleys_believe_it_or_not/',"start":"2010-02-01","dbfile":dbdir + "comicdb.ripleysbelieveitornot.csv"},
		"rose_is_rosecomicscom":{"name":"Rose Is Rose","link":'http://comics.com/rose_is_rose/',"start":"2010-02-01","dbfile":dbdir + "comicdb.roseisrose.csv"},
		"rubescomicscom":{"name":"Rubes","link":'http://comics.com/rubes/',"start":"2010-02-01","dbfile":dbdir + "comicdb.rubes.csv"},
		"rudy_parkcomicscom":{"name":"Rudy Park","link":'http://comics.com/rudy_park/',"start":"2010-02-01","dbfile":dbdir + "comicdb.rudypark.csv"},
		"scary_garycomicscom":{"name":"Scary Gary","link":'http://comics.com/scary_gary/',"start":"2010-02-01","dbfile":dbdir + "comicdb.scarygary.csv"},
		"shirley_and_soncomicscom":{"name":"Shirley and Son","link":'http://comics.com/shirley_and_son_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.shirleyandson.csv"},
		"sinfest":{"name":"Sinfest","link":"http://sinfest.com/","start":3400,"dbfile":dbdir + "comicdb.sinfest.csv"},
		"soup_to_nutzcomicscom":{"name":"Soup to Nutz","link":'http://comics.com/soup_to_nutz/',"start":"2010-02-01","dbfile":dbdir + "comicdb.souptonutz.csv"},
		"speed_bumpcomicscom":{"name":"Speed Bump","link":'http://comics.com/speed_bump/',"start":"2010-02-01","dbfile":dbdir + "comicdb.speedbump.csv"},
		"spot_the_frogcomicscom":{"name":"Spot the Frog","link":'http://comics.com/spot_the_frog/',"start":"2010-02-01","dbfile":dbdir + "comicdb.spotthefrog.csv"},
		"state_of_the_unioncomicscom":{"name":"State of the Union","link":'http://comics.com/state_of_the_union/',"start":"2010-02-01","dbfile":dbdir + "comicdb.stateoftheunion.csv"},
		"strange_brewcomicscom":{"name":"Strange Brew","link":'http://comics.com/strange_brew/',"start":"2010-02-01","dbfile":dbdir + "comicdb.strangebrew.csv"},
		"tarzancomicscom":{"name":"Tarzan","link":'http://comics.com/tarzan_classics/',"start":"2010-02-01","dbfile":dbdir + "comicdb.tarzan.csv"},
		"thats_lifecomicscom":{"name":"That's Life","link":'http://comics.com/thats_life/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thatslife.csv"},
		"the_barncomicscom":{"name":"The Barn","link":'http://comics.com/the_barn/',"start":"2010-02-01","dbfile":dbdir + "comicdb.the_barn.csv"},
		"the_born_losercomicscom":{"name":"The Born Loser","link":'http://comics.com/the_born_loser/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thebornloser.csv"},
		"the_bucketscomicscom":{"name":"The Buckets","link":'http://comics.com/the_buckets/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thebuckets.csv"},
		"the_dinette_setcomicscom":{"name":"The Dinette Set","link":'http://comics.com/the_dinette_set/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thedinetteset.csv"},
		"the_grizzwellscomicscom":{"name":"The Grizzwells","link":'http://comics.com/the_grizzwells/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thegrizzwells.csv"},
		"the_humble_stumblecomicscom":{"name":"The Humble Stumble","link":'http://comics.com/the_humble_stumble/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thehumblestumble.csv"},
		"the_knight_lifecomicscom":{"name":"The Knight Life","link":'http://comics.com/the_knight_life/',"start":"2010-02-01","dbfile":dbdir + "comicdb.theknightlife.csv"},
		"the_meaning_of_lilacomicscom":{"name":"The Meaning of Lila","link":'http://comics.com/the_meaning_of_lila/',"start":"2010-02-01","dbfile":dbdir + "comicdb.themeaningoflila.csv"},
		"the_other_coastcomicscom":{"name":"The Other Coast","link":'http://comics.com/the_other_coast/',"start":"2010-02-01","dbfile":dbdir + "comicdb.theothercoast.csv"},
		"the_sunshine_clubcomicscom":{"name":"the Sunshine Club","link":'http://comics.com/the_sunshine_club/',"start":"2010-02-01","dbfile":dbdir + "comicdb.thesunshineclub.csv"},
		"unstrange_phenomenacomicscom":{"name":"Unstrange Phenomena","link":'http://comics.com/unstrange_phenomena/',"start":"2010-02-01","dbfile":dbdir + "comicdb.unstrangephenomena.csv"},
		"watch_your_headcomicscom":{"name":"Watch Your Head","link":'http://comics.com/watch_your_head/',"start":"2010-02-01","dbfile":dbdir + "comicdb.watchyourhead.csv"},
		"wizard_of_idcomicscom":{"name":"Wizard of Id","link":'http://comics.com/wizard_of_id/',"start":"2010-02-01","dbfile":dbdir + "comicdb.wizardofid.csv"},
		"working_dazecomicscom":{"name":"Working Daze","link":'http://comics.com/working_daze/',"start":"2010-02-01","dbfile":dbdir + "comicdb.workingdaze.csv"},
		"working_it_outcomicscom":{"name":"Working It Out","link":'http://comics.com/working_it_out/',"start":"2010-02-01","dbfile":dbdir + "comicdb.workingitout.csv"},
		"wulff":{"name":"Wulffmorgenthaler","link":"http://wulffmorgenthaler.com/","start":"edd3411b-96ca-4d93-bd5f-0cf1deb67c8a","dbfile":dbdir + "comicdb.wulff.csv"},
		"xkcd":{"name":"xkcd","link":"http://xkcd.org/","start":666,"dbfile":dbdir + "comicdb.xkcd.csv"},
		"zack_hillcomicscom":{"name":"Zack Hill","link":'http://comics.com/zack_hill/',"start":"2010-02-01","dbfile":dbdir + "comicdb.zackhill.csv"},



		}
defaults = {'width':480,'height':230}
#defaults = {'width':480,'height':240}
sizefile = "/home/user/.comic-widget/size.cfg"
previous = False
next = False


# handling of the comics
class ComicDb():
	def __init__(self, comic):
		self.comic = comic
		self.start = comics[self.comic]["start"]
		self.dbfile = comics[self.comic]["dbfile"]

		#if db file exist, read it
		# if os.path.isfile(self.dbfile) == True:
		#	dbf = open(self.dbfile, 'r')
		# if not, create it.
		dbf = self.get_dbfile()
		dbr = csv.DictReader(dbf)
		self.db = []
		for row in dbr:
			self.db.insert(0,row)
		dbf.close()
		if len(self.db) == 0:
			self.refresh()
		self.currentcomic = 0



	def get_dbfile(self):
		#if db file exist, read it
		print "fetching " + self.dbfile
		if os.path.isfile(self.dbfile) == True:
			print "found " + self.dbfile
			dbf = open(self.dbfile, 'r')
			return dbf
		# if not, copy it.
		else:
			print "file " + self.dbfile + " not found"
			if not os.path.exists(dbdir):
				print "path not found: " + dbdir
				try:
					os.makedirs(dbdir)
				except:
					print "comic db creation failed on mkdir"
					exit()
			try:
				shutil.copyfile(basedbdir + "comicdb." + self.comic + ".csv", dbdir + "comicdb." + self.comic + ".csv")
			except:
				print "comic db creation failed on copy"
				print "creating new..."
				dbf = open(self.dbfile, 'w')
				dbf.write('comic,id,link,url,filename,title\n')
				dbf.close()
				
			if os.path.isfile(self.dbfile) == True:
				dbf = open(self.dbfile, 'r')
				return dbf
			else:
				print "comic db creation failed after copy"


	def get_comic(self):
		print str(self.currentcomic)
		if self.currentcomic < 0:
			self.currentcomic = 0
			if len(self.db) > 0:
				fetchid = self.db[self.currentcomic]['id']
			else:
				fetchid = comics[self.comic]['start']
			self.fetch_newer(self.comic, fetchid)
			self.refresh()
		if  len(self.db) < (self.currentcomic + 1):
			print "Empty db"
			self.currentcomic = len(self.db) - 1
			if len(self.db) > 0:
				fetchid = self.db[self.currentcomic]['id']
			else:
				fetchid = comics[self.comic]['start']
			self.fetch_earlier(self.comic, fetchid)
			self.refresh()
			self.currentcomic = len(self.db) - 1
			
		dbrow = self.db[self.currentcomic]
		filename = comiccache + self.comic + "/" + dbrow['filename']
		print filename + "\n"
		
		if os.path.isfile(filename):
			print "found, returning " + filename + "\n"
			return filename
		else:
			#fetch file
			print filename + " not found\nretrieving " + dbrow['url'] + "\n"
			if not os.path.exists(comiccache + self.comic + "/"):
				print "create dir " + comiccache + self.comic + "/"
				try:
					os.makedirs(comiccache + self.comic + "/")
					print "created dir"
				except:
					print "comic db creation failed on mkdir"
			try:
				f = open(filename, "wb")
				print "writing to " + filename
				req = urllib2.Request(dbrow['url'])
				req.add_header('Referer', dbrow['link'])
				tmpimg = urllib2.urlopen(req)
				f.write(tmpimg.read())
				tmpimg = None
				f.close()

#				urllib.urlretrieve(dbrow['url'], filename)
			except:
				if os.path.isfile(filename):
					os.remove(filename)
			print "success\n"
			return filename

	def get_current_row(self):
		return self.db[self.currentcomic]		

	def get_link(self):
		print str(self.currentcomic)
		if self.currentcomic < 0:
			self.refresh()
			self.currentcomic = 0
		if  len(self.db) < (self.currentcomic + 1):
			self.currentcomic -= 1
		return self.db[self.currentcomic]['link']



	def insert_row(self, irow):
		dbf = open(self.dbfile, 'a')
		dbw = csv.writer(dbf)
		dbw.writerow(irow)
		dbf.close()

	def insert_row_first(self, irow):
		dbf = open(self.dbfile, 'w')
		dbf.write('comic,id,link,url,filename,title\n')
		dbw = csv.writer(dbf)
		dbw.writerow(irow)
		dbf.close()
		dbf = open(self.dbfile, 'a')
		dbw = csv.DictWriter(dbf, ['comic','id','link','url','filename','title'])
		tmpdb = self.db
		tmpdb.reverse()
		for row in tmpdb:
			dbw.writerow(row)
		dbf.close()

	def refresh(self):
	#	if len(self.db) < 1:
	#		self.currentcomic = -1
	#		self.fetch_latest_std(self.comic, self.start)
	#	elif self.currentcomic == 0 or self.currentcomic < 0:
	#		self.fetch_latest_std(self.comic, self.db[0]['id'])
	#	elif self.currentcomic == (len(self.db) - 1):
	#		self.fetch_earlier(self.comic, self.db[self.currentcomic]['id'])
		dbf = open(self.dbfile, 'r')
		dbr = csv.DictReader(dbf)
		self.db = []
		for row in dbr:
			self.db.insert(0,row)
		dbf.close()
		if len(self.db) == 0:
			self.fetch_earlier(self.comic, self.start)
			dbf = open(self.dbfile, 'r')
			dbr = csv.DictReader(dbf)
			self.db = []
			for row in dbr:
				self.db.insert(0,row)
			dbf.close()


# fetch earlier
	def fetch_earlier(self, comic, earliest):
		print "fetch before, " + comic + " earliest"
		print comic[-9:]
		if comic == "cyanide" or comic == "wulff" or comic == "babyblues" or comic[-9:] == "comicscom":
			print "getting get_prev_id..."
			comicid = self.get_prev_id(comic,earliest)
			if not comicid:
				print "already at first comic"
				return
			print "got " + comicid + " as the one before current..."
		elif len(str(earliest)) == 10:
			# date id.
			dt = string.split(earliest, "-")
			d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
			earlier = d - datetime.timedelta( 1 )
			comicid = earlier.isoformat()
		else:
			comicid = int(earliest) - 1

		irow = self.get_irow(comic, comicid)
		if irow and irow[0] == "skip":
				print "problem with this one, fetching " + str(irow[2]) + " instead."
				irow = self.get_irow(comic, irow[2])

		if irow and len(irow) > 3:
			print "got irow: "
			print irow
			print "\ninserting...\n"
			self.insert_row_first([irow[0],irow[1],irow[2],irow[3],irow[4],irow[5]])
		else:
			print "No comic found at " + comicid





	def fetch_newer(self, comic, newest):
		if comic == "cyanide" or comic == "wulff" or comic == "babyblues" or comic[-9:] == "comicscom":
			comicid = self.get_next_id(comic,newest)
			if not comicid:
				print "already at last comic"
				return
		elif len(newest) == 10:
			# date id.
			dt = string.split(newest, "-")
			d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
			newest = d + datetime.timedelta( 1 )
			comicid = newest.isoformat()
		else:
			comicid = int(newest) + 1

		irow = self.get_irow(comic, comicid)
		if irow and irow[0] == "skip":
				print "problem with this one, fetching " + str(irow[1]) + " instead."
				irow = self.get_irow(comic, irow[1])

		if irow and len(irow) > 3:
			print "got irow: "
			print irow
			print "\ninserting...\n"
			self.insert_row([irow[0],irow[1],irow[2],irow[3],irow[4],irow[5]])
		else:
			print "No comic found at " + str(comicid)




	def fetch_latest_std(self, comic, latest):
		print "fetching new after " + str(comic) + " " + str(latest)
		next = False
		dateid = False
		if comic == 'cyanide':
			next = self.get_next_id(comic, latest)
			if not next:
				return
			else:
				comicid = next
		else: 
			if len(str(latest)) == 10:
				# date id.
				dateid = True
				dt = string.split(latest, "-")
				d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
				newer = d + datetime.timedelta( 1 )
				comicid = newer.isoformat()
			else:
				comicid = int(latest) + 1

		if len(self.db) > 0:
			lasturl = self.db[0]['url']
		else:
			lasturl = "http"
		while True:
			irow = self.get_irow(comic, comicid)
			if irow:
				print "got irow: " + str(irow)
				if str(irow[0]) == 'skip':
					print "skipping this one..."
					next = int(irow[1])
				else:
					if irow[3] == lasturl:
						print "Looping the same, break break break!"
						break
					lasturl = irow[3]
					print "inserting..."
					self.insert_row([irow[0],irow[1],irow[2],irow[3],irow[4],irow[5]])
					if len(irow) > 6:
						next = irow[6]
						if not next:
							break
				if dateid:
					dt = string.split(comicid, "-")
					d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
					newer = d + datetime.timedelta( 1 )
					comicid = newer.isoformat()
				elif next:
					comicid = next
				else:
					comicid += 1
			else:
				break




	def get_next_id(self, comic, number):
		if comic == 'babyblues':
			link = "http://www.babyblues.com/archive/index.php?formname=getstrip&GoToDay=" + str(number)
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				print "checking next Babyblues date.."
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, 'nextStripLink', 1)
				if len(splt) < 2:
					print "no 'prev' found"
					return False
				else:
					next = splt[1][48:58]
					print "got next: " + next

					return next

		if comic == 'cyanide':
			link = "http://www.explosm.net/comics/" + str(number) + "/"
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				# print "Cyanide & Happiness is unreliable, so we need to track next and prev"
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, 'Previous</a> | <a href="/comics/', 1)
				if len(splt) < 2:
					print "no 'next' found"
					return False
				splt = string.split(splt[1], '/">Next >', 1)
				if len(splt) < 2:
					print "no 'next' found"
					return False
				else:
					print "got next: " + splt[0]
					return splt[0]	
		if comic == 'wulff':
			link = "http://wulffmorgenthaler.com/default.aspx?id=" + number
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, '<a href="/default.aspx?id=', 1)
				if not splt[1][36:69] == '" id="ctl00_content_Strip1_aPrev"':
					print "no previous found"
					if not splt[1][36:69] == '" id="ctl00_content_Strip1_aNext"':
						print "no next found!"
						return False
				else:
					splt = string.split(splt[1], '<a href="/default.aspx?id=', 1)
				if len(splt) < 2:
					print "no next found! At newest comic!"
					return False
				if not splt[1][36:69] == '" id="ctl00_content_Strip1_aNext"':
					print "no next found!"
					return False
				else:
					return splt[1][:36]
		elif comic[-9:] == "comicscom":
			link = comics[comic]['link'] + str(number) + "/"
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				s = f.read()
				f.close()
				return self.parse_comics_com(comic, s, 'next')






	def get_prev_id(self, comic, number):
		if comic == 'babyblues':
			link = 'http://www.babyblues.com/archive/index.php?formname=getstrip&GoToDay=' + str(number)
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				print "checking prev Babyblues date.."
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, 'prevStripLink', 1)
				if len(splt) < 2:
					print "no 'prev' found"
					exit()
					return False
				else:
					prev = splt[1][48:58]
					print "got previous: " + prev
					return prev

		if comic == 'cyanide':
			link = "http://www.explosm.net/comics/" + str(number) + "/"
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				print "Cyanide & Happiness is unreliable, so we need to track next and prev"
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, 'First</a> | <a href="/comics/', 1)
				if len(splt) < 2:
					print "no 'prev' found"
					return False
				splt = string.split(splt[1], '/">< Previous', 1)
				if len(splt) < 2 or len(splt[0]) > 5:
					print "no 'next' found"
					return False
				else:
					print "got previous: " + splt[0]
					return splt[0]	
		elif comic == 'wulff':
			link = "http://wulffmorgenthaler.com/default.aspx?id=" + number
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, '<a href="/default.aspx?id=', 1)
				if not splt[1][36:69] == '" id="ctl00_content_Strip1_aPrev"':
					print splt[1][36:69]
					print splt[1][:36]
					print "no previous found"
					return False
				else:
					return splt[1][:36]
		elif comic[-9:] == "comicscom":
			print "fetch prev, still in function..."
			link = comics[comic]['link'] + str(number) + "/"
			print "link: " + link
			try:
				f = urllib2.urlopen(link)
				hcode = f.code
			except:
				hcode = 404
			print "got hcode = " + str(hcode) + "\n"
			if (hcode != 200):
				return False
			else:
				s = f.read()
				f.close()
				return self.parse_comics_com(comic, s, 'prev')




	def get_irow(self, comic, number):
		dateid = False
		if len(str(number)) == 10:
			dateid = True
		else:
			if number < 0:
				return False
			print "number is now: " + str(number) + "\n"
		if comic == 'xkcd':
			link = "http://xkcd.org/" + str(number) + "/"
		elif comic == 'sinfest':
			link = "http://www.sinfest.net/archive_page.php?comicID=" + str(number)
		elif comic == 'dilbert':
			link = "http://dilbert.com/" + str(number) + "/"
		elif comic == 'phd':
			link = "http://www.phdcomics.com/comics/archive.php?comicid=" + str(number)
		elif comic == 'cyanide':
			link = "http://www.explosm.net/comics/" + str(number) + "/"
		elif comic == 'wulff':
			link = "http://wulffmorgenthaler.com/default.aspx?id=" + str(number)
		elif comic == 'babyblues':
			link = "http://www.babyblues.com/archive/index.php?formname=getstrip&GoToDay=" + str(number)
		elif comic[-9:] == 'comicscom':	
			link = comics[comic]['link'] + str(number) + "/"
		else:
			return False

		print "link: " + link
		try:
			f = urllib2.urlopen(link)
			hcode = f.code
		except:
			hcode = 404
		print "got hcode = " + str(hcode) + "\n"
		if (hcode != 200):
			return False
		else:
                        # Build db entry.
                        # they look like: comic,id,link,url,filename,title
                        # We already have comic, number/id and link

			if comic == 'xkcd':
				s = f.read()
				f.close()
                                # This should be done with regex but...
				splt = string.split(s, 'png" title="', 1)
				splt = string.split(splt[1], '" alt="', 1)
				title = splt[0]
				splt = string.split(splt[1], "<h3>Image URL (for hotlinking/embedding): ", 1)
				splt = string.split(splt[1], "</h3>", 1)
				url = splt[0]


			elif comic == 'sinfest':
				s = f.read()
				f.close()
				splt = string.split(s, 'height="107"', 1)
				splt = string.split(splt[1], '<img src="', 1)
				splt = string.split(splt[1], '" alt="', 1)
				url = splt[0]
				if len(url) < 49:
					print "Fake 404! Break break break!"
					return False
				splt = string.split(splt[1], '" border="0" />', 1)
				title = splt[0]

			elif comic == 'dilbert':
				s = f.read()
				f.close()
				splt = string.split(s, 'input type="hidden" name="PrintPath" value="', 1)
				splt = string.split(splt[1], '" />', 1)
				url = "http://dilbert.com" + splt[0]
				if len(url) < 50:
					print "Fake 404! Break break break!"
					return False
				title = ""

			elif comic == 'phd':
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, '<title>PHD Comics: ', 1)
				splt = string.split(splt[1], '</title>', 1)
				title = splt[0];
				splt = string.split(splt[1], '<td bgcolor=#FFFFFF align=center><img src=', 1)
				splt = string.split(splt[1], ' align=top>', 1)
				url = splt[0]
				if len(url) < 49:
					print "Fake 404! Break break break!"
					return False

			elif comic == 'cyanide':
				s = f.read()
				f.close()
				# title:
				splt = string.split(s, ' First</a> | <a href="/comics/', 1)
				if len(splt) < 2:
					print "first comic?"
					prev = False
				else:
					splt = string.split(splt[1], '/">< ', 1)
					prev = splt[0];
					print "got prev: " + prev
				splt = string.split(s, 'Previous</a> | <a href="/comics/', 1)
				if len(splt) < 2:
					print "last comic?"
					next = False
				else:
					splt = string.split(splt[1], '/">Next ></a>', 1)
					if len(splt[0]) > 10:
						next = False
					else:
						next = splt[0]
						print "got next: " + next

				splt = string.split(s, '</tr><tr><td colspan=2>', 1)
				if len(splt) < 2:
					print "no comic?"
					return False
				splt = string.split(splt[1], ' <b>by <a href="', 1)
				title = splt[0];
				if len(title) > 10:
					print "title wrong..."
					return False
				splt = string.split(splt[1], 'a daily webcomic" src="http://www.explosm', 1)
				if len(splt) < 2:
					print "a video? Try skipping"
					return ['skip',next,prev]
					
				splt = string.split(splt[1], '">', 1)
				url = "http://www.explosm" + splt[0]
				splt2 = string.rsplit(url, "/", 1)
				filename = splt2[1]
				irow = [comic,number,link,url,filename,title,next,prev]
				return irow


			elif comic == 'babyblues':
				# babyblues is type .gif
				s = f.read()
				f.close()
				splt = string.split(s, 'http://est.rbma.com/content/Baby_Blues?date=', 1)
				flnm = splt[1][:8]
				# check filename...
				datesplt = string.split(number, "/")
				flncheck = datesplt[2] + datesplt[0] + datesplt[1]
				if not flnm == flncheck:
					print "incorrect filename, end of line. Break break break!"
					return False
				url = 'http://est.rbma.com/content/Baby_Blues?date=' + flnm
				title = number + " (2 weeks delay)"
				filename = flnm + ".gif"
				irow = [comic,number,link,url,filename,title]
				return irow


			elif comic == 'wulff':
				# wulf is type .gif
				s = f.read()
				f.close()
				splt = string.split(s, '<img src="pics/dates/month/', 1)
				if not splt[1][1:2] == ".":
					title = splt[1][:2]
				else:
					title = "0" + splt[1][:1]
				splt = string.split(splt[1], '<img src="pics/dates/day/', 1)
				if not splt[1][1:2] == ".":
					title = title + "-" + splt[1][:2]
				else:
					title = title + "-0" + splt[1][:1]
				splt = string.split(splt[1], '<img src="pics/dates/year/', 1)
				title = splt[1][:4] + "-" + title
				# title done...
				splt = string.split(splt[1], 'id="ctl00_content_Strip1_imgStrip" class="strip" src="striphandler.ashx?stripid=', 1)
				number = splt[1][:36]
				url = "http://wulffmorgenthaler.com/striphandler.ashx?stripid=" + number
				filename = number + ".gif"
				irow = [comic,number,link,url,filename,title]
				return irow
			elif comic[-9:] == 'comicscom':
				url = self.parse_comics_com(comic, f.read(), 'url') 
				f.close()
				title = number

			splt2 = string.rsplit(url, "/", 1)
			filename = splt2[1]
			try:
				if filename == self.db[0]['filename']:
					print "already exists! Break break break!"
					return False
			except:
				pass
			irow = [comic,number,link,url,filename,title]
			return irow


	def parse_comics_com(self, comicname, source, get_what):
		# 	rel="{StripID:309486, ComicID:36, Type:'Comic', DateStrip:'2010-02-06', URL_Comic: 'girls&sports', Link_Previous: '/girls&sports/2010-02-05/', Link_Next: '/girls&sports/2010-02-07/'}"
		if get_what == "url":
			splt = string.split(source, 'StripID:', 1)
			splt = string.split(splt[1], ', ComicID:', 1)
			url = "http://c0389161.cdn.cloudfiles.rackspacecloud.com/dyn/str_strip/" + splt[0] + ".full.gif"
			return url
		elif get_what == "next":
			splt = string.split(source, "Link_Next: '", 1)
			splt = string.split(splt[1], "'", 1)
			splt = string.split(splt[0], "/")
			if len(splt) < 3:
				return False
			else:
				
				return splt[2]

		elif get_what == "prev":
			print "getting comics com prev: " + comicname
			splt = string.split(source, "Link_Previous: '", 1)
			splt = string.split(splt[1], "'", 1)
			splt = string.split(splt[0], "/")
			if len(splt) == 0:
				return False
			else:
				if len(splt[2]) == 10:
					return splt[2]
				else:
					return False
		


# ------------UI

class ComicHomePlugin(hildondesktop.HomePluginItem):
	# __gtype_name__ = 'ComicHomePlugin'
	def __init__(self):
		hildondesktop.HomePluginItem.__init__(self)
		global supports_alpha
		self.set_settings(True)
		self.active_comics = self.get_active_comics()
		self.sizes = self.get_size_settings()
		self.new_width = self.sizes['width']
		self.new_height = self.sizes['height']
		self.connect("show-settings", self.show_options)
		self.osso_c = osso.Context("comic-widget", "0.3.0", False)
		self.osso_rpc = osso.Rpc(self.osso_c)
		self.keypointer = 0
		if len(self.active_comics) < 1:
			self.active_comics = ['xkcd']
		
		self.db = ComicDb(self.active_comics[self.keypointer])
		self.comicname = comics[self.active_comics[self.keypointer]]['name']
		self.set_name = "comicwidget"
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
			supports_alpha = True
		self.set_colormap(colormap)
		self.set_app_paintable(True)
		#setup internal area
		self.set_size_request(self.sizes['width'], self.sizes['height'])
		self.imgvpos = 0;
		self.vbox = gtk.VBox()
		self.hbox = gtk.HBox()
		self.label = gtk.Label()
		self.label.set_alignment(xalign = 0, yalign = 0.5)
		self.label.set_use_markup(True)
		self.label.set_markup(self.get_markup())


		self.e_goweb = gtk.EventBox()
		self.e_goweb.set_name('goweb')
		self.e_goweb.set_size_request(self.sizes['width'] - 250, 48)
		# e_open is the eventbox for the image. Does nothing, but it's convenient to have it.
		# it will change to be a cairo thing when I have the time.
		self.e_open = gtk.EventBox()
		self.e_open.set_name('open')
		self.e_switch = gtk.EventBox()
		self.e_switch.set_name('switch')
		self.e_switch.set_size_request(48, 48)
		self.e_next = gtk.EventBox()
		self.e_next.set_name('next')
		self.e_next.set_size_request(48, 48)
		self.e_prev = gtk.EventBox()
		self.e_prev.set_name('prev')
		self.e_prev.set_size_request(48, 48)
		self.e_up = gtk.EventBox()
		self.e_up.set_name('up')
		self.e_up.set_size_request(48, 48)
		self.e_down = gtk.EventBox()
		self.e_down.set_name('down')
		self.e_down.set_size_request(48, 48)
		self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
		self.comic_image.show()
		

		# Preload images into a dictionary, so that we can access them by the names of the eventboxes:

		self.images = {'up0':cairo.ImageSurface.create_from_png(imagedir + "up0-48x48.png"),
					'up1':cairo.ImageSurface.create_from_png(imagedir + "up1-48x48.png"),
					'down0':cairo.ImageSurface.create_from_png(imagedir + "down0-48x48.png"),
					'down1':cairo.ImageSurface.create_from_png(imagedir + "down1-48x48.png"),
					'next0':cairo.ImageSurface.create_from_png(imagedir + "next0-48x48.png"),
					'next1':cairo.ImageSurface.create_from_png(imagedir + "next1-48x48.png"),
					'prev0':cairo.ImageSurface.create_from_png(imagedir + "prev0-48x48.png"),
					'prev1':cairo.ImageSurface.create_from_png(imagedir + "prev1-48x48.png"),
					'switch0':cairo.ImageSurface.create_from_png(imagedir + "switch0-48x48.png"),
					'switch1':cairo.ImageSurface.create_from_png(imagedir + "switch1-48x48.png"),
					}



		self.e_goweb.add(self.label)
		self.e_goweb.set_events(gtk.gdk.BUTTON_RELEASE_MASK)
		self.e_goweb.connect("button-release-event", self.view_comic)

		self.e_open.add(self.comic_image)

		# self.e_switch.add(self.switch)
		self.e_switch.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_switch.connect("button-press-event", self.button_press)
		self.e_switch.connect("button-release-event", self.button_release)
		self.e_switch.connect("leave-notify-event", self.button_release)


		# self.e_next.add(self.next)
		self.e_next.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_next.connect("button-press-event", self.button_press)
		self.e_next.connect("button-release-event", self.button_release)
		self.e_next.connect("leave-notify-event", self.button_release)

		#self.e_prev.add(self.prev)
		self.e_prev.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_prev.connect("button-press-event", self.button_press)
		self.e_prev.connect("button-release-event", self.button_release)
		self.e_prev.connect("leave-notify-event", self.button_release)

		#self.e_up.add(self.up)
		self.e_up.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_up.connect("button-press-event", self.button_press)
		self.e_up.connect("button-release-event", self.button_release)
		self.e_up.connect("leave-notify-event", self.button_release)
		

		#self.e_down.add(self.down)
		self.e_down.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_down.connect("button-press-event", self.button_press)
		self.e_down.connect("button-release-event", self.button_release)
		self.e_down.connect("leave-notify-event", self.button_release)

		self.vbox.pack_start(self.e_open,False,False,0)
		self.vbox.pack_end(self.hbox,False,False,0)

		self.hbox.pack_start(self.e_switch,False,False,0)
		self.hbox.pack_start(self.e_goweb,False,False,5)
		self.hbox.pack_end(self.e_next,False,False,0)
		self.hbox.pack_end(self.e_prev,False,False,0)
		self.hbox.pack_end(self.e_down,False,False,0)
		self.hbox.pack_end(self.e_up,False,False,0)
		self.vbox.show_all()
		self.add(self.vbox)



	# **************** Cairo draw functions ***************

	def realize(self, widget):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
		#      print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		self.set_colormap(colormap)

		return False

	def do_expose_event(widget, event):
		cr = widget.window.cairo_create()
		widget.draw(widget.e_up, 0)
		widget.draw(widget.e_down, 0)
		widget.draw(widget.e_prev,0)
		widget.draw(widget.e_next, 0)
		widget.draw(widget.e_switch, 0)
#		widget.writeit(widget.e_goweb, "asdf")
		cr.set_operator(cairo.OPERATOR_OVER)
		region = gtk.gdk.region_rectangle(event.area)
		cr.region(region)
		bg_color=gtk.gdk.color_parse('#000000')
		if supports_alpha:
			cr.set_source_rgba (0.0, 0.0, 0.0, 0.5)
		else:
			cr.set_source_rgb (0.0, 0.0, 0.0)
			
		cr.fill_preserve()
		return False

	# Function that draws a button preloaded in the images dictionary.
	def draw(self, target, postfix):
		cr_e = target.window.cairo_create()
		cr_e.set_source_rgba(0.0, 0.0, 0.0, 0.5) # Transparent
		cr_e.set_operator(cairo.OPERATOR_SOURCE)
		cr_e.paint()
		cr_e.set_operator(cairo.OPERATOR_OVER)
		cr_e.set_source_surface(self.images[target.get_name() + str(postfix)], 0, 0)
		cr_e.paint()

	# ********** Event handlers *************


	# Most events happen on release, so I moved all of them into the same event handler.
	def button_release(self, widget, event):
		if event.type == gtk.gdk.BUTTON_RELEASE:
			func = widget.get_name()
			print "pressed: " + func
			if func == 'up':
				self.e_open.remove(self.comic_image)
				self.imgvpos = self.imgvpos - ((self.sizes['height'] - 48) / 2.1)
				if self.imgvpos < 0:
					self.imgvpos = 0
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()

			elif func == 'down':
				self.e_open.remove(self.comic_image)
				self.imgvpos = self.imgvpos + ((self.sizes['height'] - 48) / 2.1)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()
			
			elif func == 'next':
				self.db.currentcomic -= 1
				self.imgvpos = 0
				self.e_open.remove(self.comic_image)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()
				self.e_goweb.remove(self.label)
				titl = str(self.db.db[self.db.currentcomic]['title'])
				if len(titl) > 22:
					titl = titl[:19] + "..."
				self.label.set_markup(self.get_markup())
				self.e_goweb.add(self.label)
				self.e_goweb.show_all()

			elif func == 'prev':
				self.db.currentcomic += 1
				self.imgvpos = 0
				self.e_open.remove(self.comic_image)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()
				self.e_goweb.remove(self.label)
				titl = str(self.db.db[self.db.currentcomic]['title'])
				if len(titl) > 22:
					titl = titl[:19] + "..."
				self.label.set_markup(self.get_markup())
				self.e_goweb.add(self.label)
				self.e_goweb.show_all()

			elif func == 'switch':
				self.active_comics = self.get_active_comics()
				print "closing log"
				#sys.stdout.close()
				#sys.stdout = sys.__stdout__
				#sys.stderr.close()
				#sys.stderr = sys.__stderr__
				print "active comics: " + str(self.active_comics)
				self.keypointer = (self.keypointer + 1) % len(self.active_comics)
				self.imgvpos = 0
				self.db = []
				print "switching to " + self.active_comics[self.keypointer]
				self.comicname = comics[self.active_comics[self.keypointer]]['name']
				self.db = ComicDb(self.active_comics[self.keypointer])
				self.e_open.remove(self.comic_image)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_goweb.remove(self.label)
				titl = str(self.db.db[self.db.currentcomic]['title'])
				if len(titl) > 22:
					titl = titl[:19] + "..."
				self.label.set_markup(self.get_markup())
				self.e_goweb.add(self.label)
				self.e_goweb.show_all()
				self.e_open.add(self.comic_image)
				self.e_open.show_all()	

			else:
				return False			
		self.draw(widget, "0")

	# this one only switches to pressed button image
	def button_press(self, widget, event):
		if not event.type == gtk.gdk.BUTTON_PRESS:
			return False
		self.draw(widget, "1")

	# this one cancels a button press when pointer is moved out from it after press.
	def button_out(self, widget, event):
		if not event.type == gtk.gdk.BUTTON_PRESS:
			return False
		self.draw(widget, "0")

	# no fancy cairo stuff here. simply launches url in browser.
	def view_comic(self, widget, event):
		if not event.type == gtk.gdk.BUTTON_RELEASE:
			return False
		link = self.db.get_link()
		self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (link,))



	# this function modifies the image to fit the widget and then returns it.

	def get_resized_pixmap(self, filename, vpos):
		print "vpos: " + str(vpos)
		
		width = int(self.sizes['width'])
		height = int(self.sizes['height'])
		picwidth = width - 2
		maxheight = height - 48

	  	pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
		parent_buf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, pixbuf.get_has_alpha(), 8, width, maxheight)
		parent_buf.fill(0xffffffff)
		retimg = gtk.Image()
		# get correct width/height
		new_height = 1
		new_width = picwidth
		new_height = int((float(picwidth) / pixbuf.get_width()) * pixbuf.get_height())
  		scaled_buf = pixbuf.scale_simple(new_width,new_height,gtk.gdk.INTERP_BILINEAR)
		print "scaled height: " + str(scaled_buf.get_height())
		if scaled_buf.get_height() > maxheight:
			if scaled_buf.get_height() - (vpos + maxheight) < 0:
				vpos = scaled_buf.get_height() - maxheight
			scaled_buf.copy_area(0,vpos,picwidth,maxheight,parent_buf,1,0)
			# parent_buf.composite(scaled_buf, 0, 0, 478, maxheight, 0, 0, 478, maxheight, gtk.gdk.INTERP_BILINEAR, 0)
			self.imgvpos = vpos
		else:
			tmpy = maxheight - scaled_buf.get_height()
			if tmpy > 0:
				tmpy = tmpy / 2

			scaled_buf.copy_area(0,0,picwidth,scaled_buf.get_height(),parent_buf,1,tmpy)
			self.imgvpos = 0
#		test = parent_buf.render_pixmap_and_mask(0)
#		parent_buf.add_alpha(True,chr(255),chr(255),chr(255))
		retimg.set_from_pixbuf(parent_buf)
		print retimg.get_pixel_size()
		print "vpos after fixing image: " + str(self.imgvpos)
		return retimg

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
		#      print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		self.set_colormap(colormap)

		return False


	def get_active_comics(self):
		print "get list"

		if os.path.isfile(activecomics) == True:
			print "found " + activecomics
			dbf = open(activecomics, 'r')
			dbr = csv.reader(dbf)
			try:
				active = dbr.next()
			except:
				active = []
			dbf.close()
			return active
		# if not, copy it.
		else:
			print "file " + activecomics + " not found"
			if not os.path.exists(dbdir):
				print "path not found: " + dbdir
				try:
					os.makedirs(dbdir)
				except:
					print "settings dir creation failed. Exiting."
					exit()
			try:
#				dbf = file(activecomics, 'w')
#				dbf.close()
				dbf = open(activecomics, 'w')
			except:
				print "error storing settings"
				exit()
			dbw = csv.writer(dbf)
			dbw.writerow(defaultcomics)
			dbf.close()
			ret = defaultcomics
			return ret

		
	def get_markup(self):
		if len(self.comicname + " " + str(self.db.db[self.db.currentcomic]['id'])) < 20:
			return '<span size="12000" face="arial"> <b>' + self.comicname + '</b> ' + str(self.db.db[self.db.currentcomic]['id']) + '\n ' + str(self.db.db[self.db.currentcomic]['title']) + '</span>'
		else:
			return '<span size="12000" face="arial"> <b>' + self.comicname + '</b>' + '\n ' + str(self.db.db[self.db.currentcomic]['title']) + '</span>'

		
		#check if settings file exists

		#if not, write defaults

# ************************* OPTION DIALOGS ********************************

	def show_options(self, widget):
		print "loading options dialog"
		dialog = gtk.Dialog("Comic Widget", None, gtk.DIALOG_DESTROY_WITH_PARENT)

		about_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		about_button.set_text("About", "See Author, Copyright and License information")
		about_button.set_alignment(0,0,0,0)
		about_button.connect("clicked", self.show_about)

		comics_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		comics_button.set_text("Comics", "Choose which comics to view")
		comics_button.set_alignment(0,0,0,0)
		comics_button.connect("clicked", self.show_comics)

		# size_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		# size_button.set_text("Change size", "Change the size of the widget")
		# size_button.set_alignment(0,0,0,0)
		# size_button.connect("clicked", self.show_size)

		print "adding buttons to dialog, starting with comics"
		dialog.vbox.pack_start(comics_button, True, True, 0)
		print "adding about button"
		dialog.vbox.pack_start(about_button, True, True, 0)
		# dialog.vbox.pack_start(size_button, True, True, 0)
		print "show!"
		dialog.show_all()
		dialog.run()
		dialog.destroy()

	def show_about(self, widget):
		print "in about dialog"
		dialog = gtk.AboutDialog()
		dialog.set_title("About")
		dialog.set_name("Comic widget")
		dialog.set_version(APP_VERSION)
		dialog.set_copyright("Copyright 2010 Marcus Wikstrom")
		dialog.set_authors(["Marcus Wikstrom <mece@ovi.com>\nLogo by Martin Wikstrom\n\nSpecial thanks to all the great python developers on t.m.o who share their code, and the helpful wizards on #maemo."])
		dialog.set_logo(gtk.gdk.pixbuf_new_from_file("/opt/comic-widget/images/icon2-64x64.png"))
		dialog.set_comments("Silly rabbit, tricks are for kids.")
		dialog.set_license("""This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License. <http://www.gnu.org/licenses/>.""")
		dialog.set_wrap_license(True)
		dialog.show_all()
		dialog.run()
		dialog.destroy()

	def show_comics(self, widget, data = None):
		print "in comics dialog! yay!"
		dialog = gtk.Dialog("Choose comics", None, gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR)
		comiclist = comics.keys()
		comiclist.sort()
		buttonlist = {}
		self.connlist = {}
		self.liststore = gtk.ListStore(str,str,bool)
		for comicid in comiclist:
			active = False
			for acomic in self.active_comics:
				if acomic == comicid:
					active = True
					break
			if active:
				self.liststore.append(["* " + comics[comicid]['name'],comicid, active])
			else:
				self.liststore.append(["  " + comics[comicid]['name'],comicid, active])
		self.treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_EDIT)
		self.treeview.set_model(self.liststore)
		self.treeview.set_reorderable(True)
		tvcolumn = gtk.TreeViewColumn('Column 0')
		self.treeview.append_column(tvcolumn)
		cell = gtk.CellRendererText()
		tvcolumn.pack_start(cell, True)
		tvcolumn.add_attribute(cell, 'text', 0)

		ts = hildon.PannableArea()
	
		ts.set_size_request(-1, 280)
		ts.add(self.treeview)
		selection = self.treeview.get_selection()

		dialog.vbox.pack_start(ts,True,True,0)
		dialog.show_all()
		selection.connect("changed", self.pick_comic, comiclist)
		dialog.run()
		dialog.destroy()

	def pick_comic(self, widget, data):
		selected = widget.get_selected()
		if selected == None:
			return False
		
		print selected[0].get_value(selected[1],0) + ", " + selected[0].get_value(selected[1],1) + ", " + str(selected[0].get_value(selected[1],2))
		if selected[0].get_value(selected[1],2):
			self.remove_comic(selected[0].get_value(selected[1],1))
			splt = selected[0].get_value(selected[1],0)[1:]
			selected[0].set_value(selected[1],0," " + splt)
			selected[0].set_value(selected[1],2,False)
		else:
			self.add_comic(selected[0].get_value(selected[1],1))
			splt = selected[0].get_value(selected[1],0)[1:]
			selected[0].set_value(selected[1],0,"*" + splt)
			selected[0].set_value(selected[1],2,True)

				
	def add_comic(self, comicid):
		if os.path.isfile(activecomics) == True:
			print "added " + comicid + " to " + str(self.active_comics)
			try:
				found = self.active_comics.index(comicid)
			except:
				self.active_comics.append(comicid)
			dbf = open(activecomics, 'w')
			dbw = csv.writer(dbf)
			dbw.writerow(self.active_comics)
			dbf.close()

	def remove_comic(self, comicid):
		if os.path.isfile(activecomics) == True:
			print "removing " + comicid + " from " + str(self.active_comics)
			try:
				del self.active_comics[self.active_comics.index(comicid)]
			except:
				pass
			dbf = open(activecomics, 'w')
			dbw = csv.writer(dbf)
			dbw.writerow(self.active_comics)
			dbf.close()


	def get_size_settings(self):
		# defaults = {'width':480,'height':230}
		# options: w 798 700 600 500 480 400
		# options: h 420 360 310 270 240 200
		print "checking to see if config file is available"
		if os.path.isfile(sizefile) == True:
			print "found " + sizefile
			dbf = open(sizefile, 'r')
			dbr = csv.reader(dbf)
			try:
				cfg = dbr.next()
			except:
				dbf.close()
				print "empty config file"
				return defaults
			dbf.close()
			
			sizes = {'width':int(cfg[0]),'height':int(cfg[1])}
			if sizes['width'] > 798:
				sizes['width'] = 798
			if sizes['width'] < 400:
				sizes['width'] = 400
			if sizes['height'] > 420:
				sizes['height'] = 420
			if sizes['height'] < 200:
				sizes['height'] = 200
			
			return sizes
			
			
		# if not, copy it.
		else:
			print "no config file"
			return defaults
		
hd_plugin_type = ComicHomePlugin


if __name__ == "__main__":
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
	obj.show_all()
	gtk.main()
