import gobject
import hildon
import hildondesktop
import gtk
import csv
import urllib2
import urllib
import string
import os
import osso
import cairo
import datetime
import shutil

supports_alpha = False

# constants. dbfile is the location of the csv
# comiccache is the location of the images
APP_VERSION = "0.2.5"

basedbdir = "/opt/comic-widget/db/"
imagedir = "/opt/comic-widget/images/"
dbdir = "/home/user/.comic-widget/"
comiccache = "/home/user/MyDocs/.comics/"
comics = {"xkcd":{"name":"xkcd","link":"http://xkcd.org/","start":666,"dbfile":dbdir + "comicdb.xkcd.csv"},
		"sinfest":{"name":"Sinfest","link":"http://sinfest.com/","start":3400,"dbfile":dbdir + "comicdb.sinfest.csv"},
		"dilbert":{"name":"Dilbert","link":"http://dilbert.com.com/","start":"2009-01-01","dbfile":dbdir + "comicdb.dilbert.csv"}}

# handling of the comics
class ComicDb():
	def __init__(self, comic):
		self.comic = comic
		self.start = comics[self.comic]["start"]
		self.dbfile = comics[self.comic]["dbfile"]

		#if db file exist, read it
		# if os.path.isfile(self.dbfile) == True:
		#	dbf = open(self.dbfile, 'r')
		# if not, create it.
		dbf = self.get_dbfile()
		dbr = csv.DictReader(dbf)
		self.db = []
		for row in dbr:
			self.db.insert(0,row)
		dbf.close()
		self.currentcomic = 0		



	def get_dbfile(self):
		#if db file exist, read it
		print "fetching " + self.dbfile
		if os.path.isfile(self.dbfile) == True:
			print "found " + self.dbfile
			dbf = open(self.dbfile, 'r')
			return dbf
		# if not, copy it.
		else:
			print "file " + self.dbfile + " not found"
			if not os.path.exists(dbdir + self.comic + "/"):
				print "path not found: " + dbdir + self.comic + "/"
				try:
					os.makedirs(dbdir + self.comic + "/")
				except:
					print "comic db creation failed on mkdir"
					exit()
			try:
				shutil.copyfile(basedbdir + "comicdb." + self.comic + ".csv", dbdir + "comicdb." + self.comic + ".csv")
			except:
				print "comic db creation failed on copy"
				exit()
			if os.path.isfile(self.dbfile) == True:
				dbf = open(self.dbfile, 'r')
				return dbf
			else:
				print "comic db creation failed after copy"
				exit()


	def get_comic(self):
		print str(self.currentcomic)
		if self.currentcomic < 0:
			self.refresh()
			self.currentcomic = 0
		if  len(self.db) < (self.currentcomic + 1):
			self.currentcomic -= 1
			self.refresh()
			self.currentcomic = len(self.db) - 1
			
		dbrow = self.db[self.currentcomic]
		filename = comiccache + self.comic + "/" + dbrow['filename']
		print filename + "\n"
		
		if os.path.isfile(filename):
			print "found, returning " + filename + "\n"
			return filename
		else:
			#fetch file
			print filename + " not found\nretrieving " + dbrow['url'] + "\n"
			if not os.path.exists(comiccache + self.comic + "/"):
				print "create dir " + comiccache + self.comic + "/"
				try:
					os.makedirs(comiccache + self.comic + "/")
					print "created dir"
				except:
					print "comic db creation failed on mkdir"
			urllib.urlretrieve(dbrow['url'], filename)
			print "success\n"
			return filename

	def get_current_row(self):
		return self.db[self.currentcomic]		

	def get_link(self):
		print str(self.currentcomic)
		if self.currentcomic < 0:
			self.refresh()
			self.currentcomic = 0
		if  len(self.db) < (self.currentcomic + 1):
			self.currentcomic -= 1
		return self.db[self.currentcomic]['link']



	def insert_row(self, irow):
		dbf = open(self.dbfile, 'a')
		dbw = csv.writer(dbf)
		dbw.writerow(irow)
		dbf.close()

	def insert_row_first(self, irow):
		dbf = open(self.dbfile, 'w')
		dbf.write('comic,id,link,url,filename,title\n')
		dbw = csv.writer(dbf)
		dbw.writerow(irow)
		dbf.close()
		dbf = open(self.dbfile, 'a')
		dbw = csv.DictWriter(dbf, ['comic','id','link','url','filename','title'])
		tmpdb = self.db
		tmpdb.reverse()
		for row in tmpdb:
			dbw.writerow(row)
		dbf.close()

	def refresh(self):
		if len(self.db) < 1:
			self.fetch_latest_std(self.comic, self.start)
		elif self.currentcomic == 0 or self.currentcomic < 0:
			self.fetch_latest_std(self.comic, self.db[0]['id'])
		elif self.currentcomic == (len(self.db) - 1):
			self.fetch_earlier(self.comic, self.db[self.currentcomic]['id'])
		dbf = open(self.dbfile, 'r')
		dbr = csv.DictReader(dbf)
		self.db = []
		for row in dbr:
			self.db.insert(0,row)
		dbf.close()

	def fetch_earlier(self, comic, earliest):
		if len(earliest) == 10:
			# date id.
			dt = string.split(earliest, "-")
			d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
			earlier = d - datetime.timedelta( 1 )
			comicid = earlier.isoformat()
		else:
			comicid = int(earliest) - 1

		irow = self.get_irow(comic, comicid)
		if irow:
			print "got irow: "
			print irow
			print "\ninserting first...\n"
			self.insert_row_first(irow)
		else:
			print "No comic found at " + comicid

	def fetch_latest_std(self, comic, latest):
		print "fetching new after " + str(comic) + " " + str(latest)
		dateid = False
		if len(latest) == 10:
			# date id.
			dateid = True
			dt = string.split(latest, "-")
			d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
			newer = d + datetime.timedelta( 1 )
			comicid = newer.isoformat()
		else:
			comicid = int(latest) + 1


		while True:
			irow = self.get_irow(comic, comicid)
			if irow:
				print "got irow: " + str(irow)
				print "inserting..."
				self.insert_row(irow)
				if dateid:
					dt = string.split(comicid, "-")
					d = datetime.date(int(dt[0]),int(dt[1]),int(dt[2]))
					newer = d + datetime.timedelta( 1 )
					comicid = newer.isoformat()
				else:
					comicid += 1
			else:
				break


	def get_irow(self, comic, number):
		dateid = False
		if len(str(number)) == 10:
			dateid = True
		else:
			if number < 0:
				return False
			print "number is now: " + str(number) + "\n"
		if comic == 'xkcd':
			link = "http://xkcd.org/" + str(number) + "/"
		elif comic == 'sinfest':
			link = "http://www.sinfest.net/archive_page.php?comicID=" + str(number)
		elif comic == 'dilbert':
			link = "http://dilbert.com/" + str(number) + "/"
		else:
			return False

		print "link: " + link
		try:
			f = urllib2.urlopen(link)
			hcode = f.code
		except:
			hcode = 404
		print "got hcode = " + str(hcode) + "\n"
		if (hcode != 200):
			return False
		else:
                        # Build db entry.
                        # they look like: comic,id,link,url,filename,title
                        # We already have comic, number/id and link

			if comic == 'xkcd':
				s = f.read()
				f.close()
                                # This should be done with regex but...
				splt = string.split(s, "<h3>Image URL (for hotlinking/embedding): ", 1)
				splt2 = string.split(splt[1], "</h3>", 1)
				url = splt2[0]
				splt = string.split(splt[0], "<h1>", 1)
				splt = string.split(splt[1], "</h1>", 1)

				title = splt[0]

			elif comic == 'sinfest':
				s = f.read()
				f.close()
				splt = string.split(s, 'height="107"', 1)
				splt = string.split(splt[1], '<img src="', 1)
				splt = string.split(splt[1], '" alt="', 1)
				url = splt[0]
				if len(url) < 49:
					print "Fake 404! Break break break!"
					return False
				splt = string.split(splt[1], '" border="0" />', 1)
				title = splt[0]

			elif comic == 'dilbert':
				s = f.read()
				f.close()
				splt = string.split(s, 'input type="hidden" name="PrintPath" value="', 1)
				splt = string.split(splt[1], '" />', 1)
				url = "http://dilbert.com" + splt[0]
				if len(url) < 50:
					print "Fake 404! Break break break!"
					return False
				title = ""

			splt2 = string.rsplit(url, "/", 1)
			filename = splt2[1]
			irow = [comic,number,link,url,filename,title]
			return irow


# ------------UI

class ComicHomePlugin(hildondesktop.HomePluginItem):
	__gtype_name__ = 'ComicHomePlugin'
	def __init__(self):
		hildondesktop.HomePluginItem.__init__(self)
		global supports_alpha
		self.set_settings(True)
		self.connect("show-settings", self.show_options)
		self.osso_c = osso.Context("comic-widget", "0.0.1", False)
		self.osso_rpc = osso.Rpc(self.osso_c)
		self.keys = comics.keys()
		self.keypointer = 1
		self.db = ComicDb(self.keys[self.keypointer])
		self.comicname = comics[self.keys[self.keypointer]]['name']
		self.set_name = "comicwidget"
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
			supports_alpha = True
		self.set_colormap(colormap)
		self.set_app_paintable(True)
		#setup internal area
		self.set_size_request(480, 230)
		self.imgvpos = 0;
		self.vbox = gtk.VBox()
		self.hbox = gtk.HBox()
		self.label = gtk.Label()
		self.label.set_alignment(xalign = 0, yalign = 0.5)
		self.label.set_use_markup(True)
		titl = str(self.db.db[self.db.currentcomic]['title'])
		if len(titl) > 22:
			titl = titl[:19] + "..."
		self.label.set_markup('<span size="12000" face="monospace"> <b>' + self.comicname + '</b> ' + str(self.db.db[self.db.currentcomic]['id']) + '\n ' + titl + '</span>')


		self.e_goweb = gtk.EventBox()
		self.e_goweb.set_name('goweb')
		self.e_goweb.set_size_request(220, 48)
		# e_open is the eventbox for the image. Does nothing, but it's convenient to have it.
		# it will change to be a cairo thing when I have the time.
		self.e_open = gtk.EventBox()
		self.e_open.set_name('open')
		self.e_switch = gtk.EventBox()
		self.e_switch.set_name('switch')
		self.e_switch.set_size_request(48, 48)
		self.e_next = gtk.EventBox()
		self.e_next.set_name('next')
		self.e_next.set_size_request(48, 48)
		self.e_prev = gtk.EventBox()
		self.e_prev.set_name('prev')
		self.e_prev.set_size_request(48, 48)
		self.e_up = gtk.EventBox()
		self.e_up.set_name('up')
		self.e_up.set_size_request(48, 48)
		self.e_down = gtk.EventBox()
		self.e_down.set_name('down')
		self.e_down.set_size_request(48, 48)
		self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
		self.comic_image.show()
		

		# Preload images into a dictionary, so that we can access them by the names of the eventboxes:

		self.images = {'up0':cairo.ImageSurface.create_from_png(imagedir + "up0-48x48.png"),
					'up1':cairo.ImageSurface.create_from_png(imagedir + "up1-48x48.png"),
					'down0':cairo.ImageSurface.create_from_png(imagedir + "down0-48x48.png"),
					'down1':cairo.ImageSurface.create_from_png(imagedir + "down1-48x48.png"),
					'next0':cairo.ImageSurface.create_from_png(imagedir + "next0-48x48.png"),
					'next1':cairo.ImageSurface.create_from_png(imagedir + "next1-48x48.png"),
					'prev0':cairo.ImageSurface.create_from_png(imagedir + "prev0-48x48.png"),
					'prev1':cairo.ImageSurface.create_from_png(imagedir + "prev1-48x48.png"),
					'switch0':cairo.ImageSurface.create_from_png(imagedir + "switch0-48x48.png"),
					'switch1':cairo.ImageSurface.create_from_png(imagedir + "switch1-48x48.png"),
					}



		self.e_goweb.add(self.label)
		self.e_goweb.set_events(gtk.gdk.BUTTON_RELEASE_MASK)
		self.e_goweb.connect("button-release-event", self.view_comic)

		self.e_open.add(self.comic_image)

		# self.e_switch.add(self.switch)
		self.e_switch.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_switch.connect("button-press-event", self.button_press)
		self.e_switch.connect("button-release-event", self.button_release)
		self.e_switch.connect("leave-notify-event", self.button_release)


		# self.e_next.add(self.next)
		self.e_next.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_next.connect("button-press-event", self.button_press)
		self.e_next.connect("button-release-event", self.button_release)
		self.e_next.connect("leave-notify-event", self.button_release)

		#self.e_prev.add(self.prev)
		self.e_prev.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_prev.connect("button-press-event", self.button_press)
		self.e_prev.connect("button-release-event", self.button_release)
		self.e_prev.connect("leave-notify-event", self.button_release)

		#self.e_up.add(self.up)
		self.e_up.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_up.connect("button-press-event", self.button_press)
		self.e_up.connect("button-release-event", self.button_release)
		self.e_up.connect("leave-notify-event", self.button_release)
		

		#self.e_down.add(self.down)
		self.e_down.set_events(gtk.gdk.BUTTON_PRESS_MASK|gtk.gdk.BUTTON_RELEASE_MASK|gtk.gdk.LEAVE_NOTIFY)
		self.e_down.connect("button-press-event", self.button_press)
		self.e_down.connect("button-release-event", self.button_release)
		self.e_down.connect("leave-notify-event", self.button_release)

		self.vbox.pack_start(self.e_open,False,False,0)
		self.vbox.pack_end(self.hbox,False,False,0)

		self.hbox.pack_start(self.e_switch,False,False,0)
		self.hbox.pack_start(self.e_goweb,False,False,10)
		self.hbox.pack_end(self.e_next,False,False,0)
		self.hbox.pack_end(self.e_prev,False,False,0)
		self.hbox.pack_end(self.e_down,False,False,0)
		self.hbox.pack_end(self.e_up,False,False,0)
		self.vbox.show_all()
		self.add(self.vbox)

	# **************** Cairo draw functions ***************

	def realize(self, widget):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
		#      print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		self.set_colormap(colormap)

		return False

	def do_expose_event(widget, event):
		cr = widget.window.cairo_create()
		widget.draw(widget.e_up, 0)
		widget.draw(widget.e_down, 0)
		widget.draw(widget.e_prev,0)
		widget.draw(widget.e_next, 0)
		widget.draw(widget.e_switch, 0)
#		widget.writeit(widget.e_goweb, "asdf")
		cr.set_operator(cairo.OPERATOR_OVER)
		region = gtk.gdk.region_rectangle(event.area)
		cr.region(region)
		bg_color=gtk.gdk.color_parse('#000000')
		if supports_alpha:
			cr.set_source_rgba (0.0, 0.0, 0.0, 0.5)
		else:
			cr.set_source_rgb (0.0, 0.0, 0.0)
			
		cr.fill_preserve()
		return False

	# Function that draws a button preloaded in the images dictionary.
	def draw(self, target, postfix):
		cr_e = target.window.cairo_create()
		cr_e.set_source_rgba(0.0, 0.0, 0.0, 0.5) # Transparent
		cr_e.set_operator(cairo.OPERATOR_SOURCE)
		cr_e.paint()
		cr_e.set_operator(cairo.OPERATOR_OVER)
		cr_e.set_source_surface(self.images[target.get_name() + str(postfix)], 0, 0)
		cr_e.paint()

	# ********** Event handlers *************


	# Most events happen on release, so I moved all of them into the same event handler.
	def button_release(self, widget, event):
		if event.type == gtk.gdk.BUTTON_RELEASE:
			func = widget.get_name()
			print "pressed: " + func
			if func == 'up':
				self.e_open.remove(self.comic_image)
				self.imgvpos = self.imgvpos - 80
				if self.imgvpos < 0:
					self.imgvpos = 0
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()

			elif func == 'down':
				self.e_open.remove(self.comic_image)
				self.imgvpos = self.imgvpos + 80
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()
			
			elif func == 'next':
				self.db.currentcomic -= 1
				self.imgvpos = 0
				self.e_open.remove(self.comic_image)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()
				self.e_goweb.remove(self.label)
				titl = str(self.db.db[self.db.currentcomic]['title'])
				if len(titl) > 22:
					titl = titl[:19] + "..."
				self.label.set_markup('<span size="12000" face="monospace"> <b>' + self.comicname + '</b> ' + str(self.db.db[self.db.currentcomic]['id']) + '\n ' + titl + '</span>')
				self.e_goweb.add(self.label)
				self.e_goweb.show_all()

			elif func == 'prev':
				self.db.currentcomic += 1
				self.imgvpos = 0
				self.e_open.remove(self.comic_image)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()
				self.e_goweb.remove(self.label)
				titl = str(self.db.db[self.db.currentcomic]['title'])
				if len(titl) > 22:
					titl = titl[:19] + "..."
				self.label.set_markup('<span size="12000" face="monospace"> <b>' + self.comicname + '</b> ' + str(self.db.db[self.db.currentcomic]['id']) + '\n ' + titl + '</span>')
				self.e_goweb.add(self.label)
				self.e_goweb.show_all()

			elif func == 'switch':
				self.keypointer = (self.keypointer + 1) % 3
				self.imgvpos = 0
				self.db = []
				print "switching to " + self.keys[self.keypointer]
				self.comicname = comics[self.keys[self.keypointer]]['name']
				self.db = ComicDb(self.keys[self.keypointer])
				self.e_goweb.remove(self.label)
				titl = str(self.db.db[self.db.currentcomic]['title'])
				if len(titl) > 22:
					titl = titl[:19] + "..."
				self.label.set_markup('<span size="12000" face="monospace"> <b>' + self.comicname + '</b> ' + str(self.db.db[self.db.currentcomic]['id']) + '\n ' + titl + '</span>')
				self.e_goweb.add(self.label)
				self.e_goweb.show_all()
				self.e_open.remove(self.comic_image)
				self.comic_image = self.get_resized_pixmap(self.db.get_comic(), self.imgvpos)
				self.e_open.add(self.comic_image)
				self.e_open.show_all()	

			else:
				return False			
		self.draw(widget, "0")

	# this one only switches to pressed button image
	def button_press(self, widget, event):
		if not event.type == gtk.gdk.BUTTON_PRESS:
			return False
		self.draw(widget, "1")

	# this one cancels a button press when pointer is moved out from it after press.
	def button_out(self, widget, event):
		if not event.type == gtk.gdk.BUTTON_PRESS:
			return False
		self.draw(widget, "0")

	# no fancy cairo stuff here. simply launches url in browser.
	def view_comic(self, widget, event):
		if not event.type == gtk.gdk.BUTTON_RELEASE:
			return False
		link = self.db.get_link()
		self.osso_rpc.rpc_run_with_defaults("osso_browser", "open_new_window", (link,))



	# this function modifies the image to fit the widget and then returns it.

	def get_resized_pixmap(self, filename, vpos):
		print "vpos: " + str(vpos)

		maxheight = 182

	  	pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
		parent_buf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, pixbuf.get_has_alpha(), 8, 480, maxheight)
		parent_buf.fill(0xffffffff)
		retimg = gtk.Image()
		# get correct width/height
		new_height = 1
		new_width = 478
		new_height = int((478.0 / pixbuf.get_width()) * pixbuf.get_height())
  		scaled_buf = pixbuf.scale_simple(new_width,new_height,gtk.gdk.INTERP_BILINEAR)
		print "scaled height: " + str(scaled_buf.get_height())
		if scaled_buf.get_height() > maxheight:
			if scaled_buf.get_height() - (vpos + maxheight) < 0:
				vpos = scaled_buf.get_height() - maxheight
			scaled_buf.copy_area(0,vpos,478,maxheight,parent_buf,1,0)
			self.imgvpos = vpos
		else:
			tmpy = maxheight - scaled_buf.get_height()
			if tmpy > 0:
				tmpy = tmpy / 2

			scaled_buf.copy_area(0,0,478,scaled_buf.get_height(),parent_buf,1,tmpy)
			self.imgvpos = 0
		retimg.set_from_pixbuf(parent_buf)
		print "vpos after fixing image: " + str(self.imgvpos)
		return retimg

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
		#      print 'Your screen supports alpha channels!'
			supports_alpha = True

		# Now we have a colormap appropriate for the screen, use it
		self.set_colormap(colormap)

		return False

# ************************* OPTIONS ********************************

	def show_options(self, widget):
		dialog = gtk.Dialog("Comic Widget", None, gtk.DIALOG_DESTROY_WITH_PARENT)

		about_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		about_button.set_text("About", "See Author, Copyright and License information")
		about_button.set_alignment(0,0,0,0)
		about_button.connect("clicked", self.show_about)

		dialog.vbox.pack_start(about_button, True, True, 0)

		dialog.show_all()
		dialog.run()
		dialog.destroy()

	def show_about(self, widget):
		dialog = gtk.AboutDialog()
		dialog.set_title("About")
		dialog.set_name("Comic widget")
		dialog.set_version(APP_VERSION)
		dialog.set_copyright("Copyright 2010 Marcus Wikstrom")
		dialog.set_authors(["Marcus Wikstrom <mece@ovi.com>\n\nSpecial thanks to Benoit Hervier, Daniel Would and Brent Chiodo\nfor some nice code to sample."])
		# dialog.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/touchsearch/icon.png"))
		# dialog.set_comments("Thanks to Benoit Hervier, Daniel Would and Brent Chiodo for some nice code to sample.")
		dialog.set_license("""This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License. <http://www.gnu.org/licenses/>.""")
		dialog.set_wrap_license(True)
		dialog.show_all()
		dialog.run()
		dialog.destroy()

hd_plugin_type = ComicHomePlugin


if __name__ == "__main__":
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
	obj.show_all()
	gtk.main()
