#!/bin/sh
# This file is part of clean-device.
#
# Copyright (C) 2011 Nokia Corporation. All rights reserved.
#
# Contact: Gabriel Schulhof <gabriel.schulhof@nokia.com>
#          David Kedves <dkedves@blumsoft.eu>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

CUD_FINISHED=/tmp/cud_finished

while true;
do
    # Turn on the display first
    dbus-send --system --print-reply --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_display_state_on
    # Request blanking pause
    dbus-send --system --print-reply --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_display_blanking_pause
    # Sleeping for 15 secs...
    sleep 15;
    [ -e ${CUD_FINISHED} ] && break;
done;

# Cancel blanking pause
dbus-send --system --print-reply --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_display_cancel_blanking_pause

rm -f ${CUD_FINISHED} > /dev/null || true;

