/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

public class MovieFilter : Object {
	public string title;
	public int year_min;
	public int year_max;
	public int rating_min;
	public Genres genres;

	public bool matches_title (string _title) {
		if (title == null)
			return true;

		if ("*" in title) {
			return PatternSpec.match_simple (title, _title);
		} else {
			return (_title.ascii_ncasecmp (title, title.length) == 0);
		}
	}
}
