/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Hildon;
using Gtk;

class SourceDialog : Gtk.Dialog {
	List<MovieSource> sources;
	List<Gtk.Button> buttons;

	public SourceDialog (Gtk.Window window) {
		set_transient_for (window);
		set_title (_("Select movie source"));

		VBox vbox;
		if (CinaestProgram.plugins.length () > 5) {
			vbox = new VBox (true, 0);

			var pannable = new PannableArea ();
			pannable.add_with_viewport (vbox);

			VBox area = (VBox) get_content_area ();
			area.pack_start (pannable, true, true, 0);
			area.set_size_request (-1, 5*70);
		} else {
			vbox = (VBox) get_content_area ();
		}

		sources = new List<MovieSource> ();
		buttons = new List<Hildon.Button> ();
		foreach (Plugin plugin in CinaestProgram.plugins) {
			foreach (MovieSource source in plugin.get_sources ()) {
				var button = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, source.get_name (), source.get_description ());
				button.set_alignment(0, (float) 0.5, 0, 0);
				vbox.pack_start (button, true, true, 0);

				button.clicked.connect (on_source_select);

				buttons.append (button);
				sources.append (source);
			}
		}
	}

	public void on_source_select (Gtk.Button button) {
		int n = buttons.index (button);

		response (n);
	}

	public new int run (ref MovieSource source) {
		int res = 0;

		show_all ();

		res = base.run ();
		destroy ();

		if (res >= 0) {
			source = sources.nth_data (res);
			return 0;
		}

		return res;
	}
}

