/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

public class PluginRegistrar<T> : Object {
	public string path { get; construct; }

	private Type type;
	private Module module;

	private delegate Type RegisterPluginFunction ();

	construct {
		assert (Module.supported ());
	}

	public PluginRegistrar (string _path) {
		Object (path: _path);
	}

	public bool load () {
		stdout.printf ("Loading plugin with path: '%s'\n", path);

		module = Module.open (path, ModuleFlags.BIND_LAZY);
		if (module == null) {
		        return false;
		}

		stdout.printf ("Loaded module: '%s'\n", module.name ());

		void* function;
		module.symbol ("register_plugin", out function);
		RegisterPluginFunction register_plugin = (RegisterPluginFunction) function;

		type = register_plugin ();
		stdout.printf ("Plugin type: %s\n\n", type.name ());

		// So it doesn't vanish as soon as the registar goes
		module.make_resident ();

		return true;
	}

	public T new_object () {
		return Object.new (type);
	}
}

