/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

public class MovieListMenu : AppMenu {
	public TreeSortable sortable;
	private MovieListWindow movie_list_window;
	private Hildon.Button select_source;

	public MovieListMenu (MovieListWindow window) {
		movie_list_window = window;
	}

	construct {
		// Add sort buttons as view menu filters
		var sort_by_title = new RadioButton.with_label (null, _("ABC"));
		var sort_by_year = new RadioButton.with_label_from_widget (sort_by_title, _("Year"));
		var sort_by_rating = new RadioButton.with_label_from_widget (sort_by_title, _("Rating"));

		// Draw them as toggle buttons, not as radio buttons
		sort_by_title.set_mode (false);
		sort_by_year.set_mode (false);
		sort_by_rating.set_mode (false);

		// TODO - get this from GConf
		sort_by_title.set_active (true);

		// Connect signals
		sort_by_title.toggled.connect (button => {
			if (button.get_active ())
				sortable.set_sort_column_id (MovieListStore.Columns.TITLE, Gtk.SortType.ASCENDING);
		});
		sort_by_year.toggled.connect (button => {
			if (button.get_active ())
				sortable.set_sort_column_id (MovieListStore.Columns.YEAR, Gtk.SortType.DESCENDING);
		});
		sort_by_rating.toggled.connect (button => {
			if (button.get_active ())
				sortable.set_sort_column_id (MovieListStore.Columns.RATING, Gtk.SortType.DESCENDING);
		});

		add_filter (sort_by_title);
		add_filter (sort_by_year);
		add_filter (sort_by_rating);

		// Add view menu buttons
		select_source = new Hildon.Button.with_text (SizeType.FINGER_HEIGHT, ButtonArrangement.VERTICAL, _("Source"), _("None"));
		var settings = new Gtk.Button.with_label (_("Settings"));

		select_source.set_style (ButtonStyle.PICKER);

		// Connect signals
		select_source.clicked.connect (on_select_source_clicked);
		settings.clicked.connect (on_settings_clicked);

		append (select_source);
		append (settings);

		show_all ();
	}

	public MovieSource source {
		set { select_source.value = value.get_name (); }
	}

	public void on_select_source_clicked (Gtk.Button button) {
		Hildon.Button select_source = (Hildon.Button) button;
		var dialog = new SourceDialog (movie_list_window);

		var source = movie_list_window.source;
		dialog.run (ref source);
		movie_list_window.source = source;

		select_source.value = source.get_name ();
	}

	public void on_settings_clicked (Gtk.Button button) {
		var dialog = new SettingsDialog (movie_list_window);

		dialog.run ();
	}
}
