#ifndef LABEL_H
#define LABEL_H

#include <QMainWindow>
#include <QPlainTextEdit>
#include <QScrollArea>
#include <QAction>

class mainWindow : public QMainWindow
{
	Q_OBJECT
public:
	mainWindow();
	void closeEvent(QCloseEvent *event);
private slots:
	void autoOrient();
	void help();
	//void noSave();
	void openFile();
	void newList();
	void hideChecked();
	void showAll();
private:
	QAction* hideCheckedAction;
	QAction* showAllAction;
	QScrollArea *portrait;
	QPlainTextEdit *landscape;
	void goLandscape(void);
	void goPortrait(void);
	QString filename;
	void readSettings(void);
	void writeSettings(void);
	void askSave(void);
	bool save(void);
	bool load(void);
} ;

#endif
