#include <QFont>
#include <QString>
#include "strikeoutbutton.h"

strikeOutButton::strikeOutButton(const QString & text, QWidget * parent)
{
	// The extra spaces are to make the strikeOut more visible by causing it continue into empty space at the sides
	setText(" " + text + " ");
	setParent(parent);
	connect(this, SIGNAL(clicked(void)), this, SLOT(toggleStrikeOut(void)));
	//setStyleSheet("Text-align:left; Font-size: 25pt");
	setIcon(QIcon::fromTheme("sketch_brush1"));
}

void strikeOutButton::toggleStrikeOut(void)
{
	QFont buttonFont = font();
	buttonFont.setStrikeOut(!buttonFont.strikeOut());
	setFont(buttonFont);
	if (buttonFont.strikeOut())
	{
		setIcon(QIcon::fromTheme("widgets_tickmark_list"));
	} else {
		setIcon(QIcon::fromTheme("sketch_brush1"));
	}
}
