#include <QtGui>
#include <QtMaemo5>
#include "mainmenu.h"
#include "entry.h"
#include <libintl.h>
#include <locale.h>

bool sortNameInsensitive(Entry * s1, Entry * s2) {
    QString s1n = (QString::fromLocal8Bit(dgettext(s1->getTextDomain().toUtf8(),s1->getName().toUtf8()))).trimmed();
    if(s1n.operator ==(s1->getName())) {
        s1n = s1->getName();
    }

    QString s2n = (QString::fromLocal8Bit(dgettext(s2->getTextDomain().toUtf8(),s2->getName().toUtf8()))).trimmed();
    if(s2n.operator ==(s2->getName())) {
        s2n = s2->getName();
    }

    s1n = s1n.left(15);
    s2n = s2n.left(15);

    return s1n.toLower() < s2n.toLower();
}

Mainmenu::Mainmenu(){
        setWindowTitle("Catorise PLUS");
        readMenuFile();
        getPossibleIconDirs();

        setlocale( LC_ALL, "" );
        textdomain( "hildon-application-manager" );

        widget = new QWidget;
        scrollArea = new QScrollArea;
        gLayout = new QGridLayout(widget);

        listLabels = new QList<QLabel *>();
        listCBoxes = new QList<QComboBox *>();
        listEntries = new QList<Entry *>();

        progDialog = new QProgressDialog("Refreshing Menu...",0,0,100,this);
        progDialog->hide();

        proc = new QProcess(this);

        Entry *entry;
        entry->CreateList();
        generateEntries();
        putEntriesToLayout();

        scrollArea->setWidget(widget);
        scrollArea->setWidgetResizable(true);
        setCentralWidget(scrollArea);

        createMenu();

        connect(proc,SIGNAL(started()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(readyReadStandardOutput()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(stateChanged(QProcess::ProcessState)),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(finished(int)),this,SLOT(resetProgressDialog()));

    }

    void Mainmenu::putEntriesToLayout(){

        Entry *entry;

        for(int i=0;i<listEntries->size();i++){

            entry = listEntries->at(i);

            QLabel *label= new QLabel;

            QString rName = (QString::fromLocal8Bit(dgettext(entry->getTextDomain().toUtf8(),entry->getName().toUtf8()))).trimmed();
            if(rName.operator ==(entry->getName())) {
                rName = entry->getName();
            }

            label->setText("<img style=\"vertical-align:middle\" height=\"48\" width=\"48\" src=\""+entry->getIconPath()+"\" />&nbsp;"+rName.left(15));
            listLabels->append( label );

            QComboBox *comboBox = new QComboBox;

            catList(comboBox, 1);
            QString actCatName = entry->getActualCategory();

            if (!oldEditName.isEmpty()) {
                for (int i = 0; i < oldEditName.size(); i++) {
                    actCatName.replace(QRegExp("^"+oldEditName.at(i)), newEditName.at(i));
                }
            }

            comboBox->setCurrentIndex(Entry::listCatoriseAvailMens.indexOf( actCatName ));

            connect(comboBox,SIGNAL(currentIndexChanged(int)),entry,SLOT(changedCategory(int)));

            listCBoxes->append( comboBox );

            gLayout->addWidget(comboBox,i,0,0);
            gLayout->addWidget(label,i,1,0);
        }

    }

    void Mainmenu::generateEntries(){
        for(int i=0;i<listCatoriseMenEntries.size();i++){
            QString tmp = QString(listCatoriseMenEntries.at(i));

            Entry *entry = new Entry();
            entry->setDesktopName(tmp.section(':',0,0).trimmed());
            QString actCat = tmp.section(":",1,1).trimmed();
//            if (actCat == "_root") {
//                actCat = "No Category";
//            }
            entry->setActualCategory(actCat);

            readDesktopFileInformation(entry);

            if(!entry->getDesktopName().isNull() && !entry->getDesktopName().isEmpty()
                && !entry->getActualCategory().isNull() && !entry->getActualCategory().isEmpty()){

                listEntries->append(entry);
            }
        }
        // Sort
        qSort(listEntries->begin(), listEntries->end(), sortNameInsensitive);

    }

    void Mainmenu::readDesktopFileInformation(Entry *entry){
        QFile file;

        file.setFileName("/usr/share/applications/hildon/"+entry->getDesktopName()+".desktop");

        if ( file.exists() == 0 ){
            file.setFileName("/home/user/.local/share/applications/hildon/"+entry->getDesktopName()+".desktop");
        }
        
        QString line("");
        bool name = false;
        bool icon = false;
        bool textDomain = false;


        if( entry->getDesktopName().operator==("user-guide")||entry->getDesktopName().operator ==("ovi") ){
            entry->setTextDomain( "maemo-af-desktop" );
            textDomain = !textDomain;
        }

        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            while(!in.atEnd()){
                line = in.readLine();
                if(!name && (line.contains("name=",Qt::CaseInsensitive) || line.contains("name =",Qt::CaseInsensitive))){
                    entry->setName( line.section("=",1,1).trimmed() );
                    name = !name;
                }else if(!icon && (line.contains("icon=",Qt::CaseInsensitive) || line.contains("icon =",Qt::CaseInsensitive))){
                    entry->setIconPath( getIconPath( line.section("=",1,1).trimmed() ) );
                    icon = !icon;
                }else if(!textDomain && line.contains("x-text-domain=",Qt::CaseInsensitive)){
                    entry->setTextDomain( line.section("=",1,1).trimmed() );
                    textDomain = !textDomain;
                }
            }
        }
        file.close();
    }

    void Mainmenu::createMenu(){

        actSave = new QAction(tr("&Save"), this);
        actAbout = new QAction(tr("A&bout"),this);
        actAddCategory = new QAction(tr("&Add Category"),this);
        actDelCategory = new QAction(tr("&Delete Category"),this);
        actEditCategory = new QAction(tr("&Edit Category"),this);

        connect(actSave,SIGNAL(triggered()),this,SLOT(saveMenuFile()));
        connect(actAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
        connect(actAddCategory, SIGNAL(triggered()), this, SLOT(addCategory()));
        connect(actDelCategory, SIGNAL(triggered()), this, SLOT(delCategory()));
        connect(actEditCategory, SIGNAL(triggered()), this, SLOT(editCategory()));

        fileMenu = menuBar()->addMenu(tr("&File"));
        fileMenu->addAction(actSave);
        fileMenu->addAction(actAbout);
        fileMenu->addAction(actAddCategory);
        fileMenu->addAction(actDelCategory);
        fileMenu->addAction(actEditCategory);

    }

    void Mainmenu::readMenuFile(){
        QFile file("/opt/catorise/menu");
        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            QString line;
            while(!in.atEnd()){
                line = in.readLine();
                listCatoriseMenEntries << line;                 // Complete Line of an Entry, like Programname: Category
            }
        }else{
            showInformationBox("Can't open /opt/catorise/menu");
        }
        file.close();
    }


    QString Mainmenu::getIconPath(QString iconName){
        return "icons:"+iconName+".png";
    }


    void Mainmenu::getPossibleIconDirs(){
        it = new QDirIterator("/opt/usr/share/icons/hicolor/",QStringList()<<"apps"<<"hildon",QDir::Dirs|QDir::NoDotAndDotDot, QDirIterator::Subdirectories);
        while (it->hasNext()) {
             listPossibleIconDirs << it->next();

        }

        QDir::setSearchPaths("icons", listPossibleIconDirs << "/opt/usr/share/pixmaps/");

    }

    void Mainmenu::showAbout()
    {
        QMessageBox::about(this, tr("About Catorise PLUS"),
                tr("<p><b>Catorise PLUS</b> is a extended version of catorise with a graphical user interface.<br />"
                   "It is originally based on catorise by <a href=\"http://www.bleb.org/\">Andrew Flegg</a> and Catorise GUI by Recep Karadas (<a href=\"http://www.reckdesign.de\" >Reckdesign</a>)"
                   "</p>"));
    }

    void Mainmenu::saveMenuFile(){
        // Create menufile
        QString menu;

        for(int i=0;i<listEntries->size();i++){
            QString actCat = listEntries->at(i)->getActualCategory();
//            if (actCat == "No Category") {
//                actCat = "_root";
//            }
            menu += QString(listEntries->at(i)->getDesktopName() + ": " + actCat);
            if(i!=listLabels->size()-1){
                menu +="\n";
            }
        }
        // Open menufile
        QFile file("/opt/catorise/menu");
        if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
            showInformationBox("Can't open /opt/catorise/menu");
            return;
        }

        // Write Menufile
        QTextStream out(&file);
        out << menu;
        out.flush();
        if(out.status() == QTextStream::Ok){
            showInformationBox("Menu file successfully updated");
        }else{
            showInformationBox("Can't write to /opt/catorise/menu");
        }
        file.close();

        // Start Catorise to refresh the menu
        proc->start("/bin/busybox sh -c \"echo /opt/catorise/catorise|root\"");

    }

    void Mainmenu::addCategory() {
        QDialog *addCatDialog = new QDialog(this);
        QGridLayout *addCatLayout = new QGridLayout(addCatDialog);
        addCatCBox = new QComboBox;

        QLabel *addCatLabelName = new QLabel("Category Name:"); // Category Name (Label)
        QLabel *addCatLabelSub = new QLabel("Subcategory:"); // Subcategory (Label)
        QLabel *addCatLabelIcon = new QLabel("Category Icon:"); // Category Icon (Label)

        addCatEditName = new QLineEdit(); // Category Name (Edit Box)
        catList(addCatCBox, 1); // Subcategory
        addCatSelectIcon = new QPushButton("Choose a icon file"); // Category Icon (Select)

        QPushButton *addCatButtonOK = new QPushButton(tr("&OK")); // OK Button
        QPushButton *addCatButtonAbort = new QPushButton(tr("&Abort")); // Abort Button

        addCatLayout->addWidget(addCatLabelName,0,0,0);
        addCatLayout->addWidget(addCatLabelSub,1,0,0);
        addCatLayout->addWidget(addCatLabelIcon,2,0,0);
        addCatLayout->addWidget(addCatEditName,0,1,0); // Category Name
        addCatLayout->addWidget(addCatCBox,1,1,0); // Subcategory
        addCatLayout->addWidget(addCatSelectIcon,2,1,0); // Category Icon (Select)

        addCatLayout->addWidget(addCatButtonOK,0,2,0); // OK Button
        addCatLayout->addWidget(addCatButtonAbort,1,2,0); // Abort Button

        connect(addCatButtonOK,SIGNAL(clicked()),addCatDialog,SLOT(accept())); // If OK, than create Category
        connect(addCatButtonAbort,SIGNAL(clicked()),addCatDialog,SLOT(reject())); // Abort
        connect(addCatSelectIcon,SIGNAL(clicked()),this,SLOT( selectCatIcon() )); // Select Icon file
        connect(addCatDialog,SIGNAL(accepted()),this,SLOT(createCategory()));

        addCatDialog->exec();
    }

    void Mainmenu::selectCatIcon() {
        IconCatDialog = new QDialog(this);
        QGridLayout *IconCatLayout = new QGridLayout(IconCatDialog);

        QPushButton *IconCatButton1 = new QPushButton(tr("Select from MyDocs"));
        QPushButton *IconCatButton2 = new QPushButton(tr("Select from System-Icon-Folder"));

        IconCatLayout->addWidget(IconCatButton1,0,0,0);
        IconCatLayout->addWidget(IconCatButton2,1,0,0);

        connect(IconCatButton1,SIGNAL(clicked()),this,SLOT( selectIconFromMyDocs() ));
        connect(IconCatButton2,SIGNAL(clicked()),this,SLOT( selectIconFromSystemDir() ));

        IconCatDialog->exec();
    }

    void Mainmenu::selectIconFromMyDocs() {
        selectIcon("/home/user/MyDocs/");
    }

    void Mainmenu::selectIconFromSystemDir() {
        selectIcon("/usr/share/icons/hicolor/64x64/hildon/");
    }

    void Mainmenu::selectIcon(QString dir) {
        catIconPath = QFileDialog::getOpenFileName(this, "Choose a file", dir, "Images (*.png)");
        if (catIconPath != NULL) {
            addCatSelectIcon->setIcon( QIcon(catIconPath) );
            addCatSelectIcon->setText( catIconPath.mid( catIconPath.lastIndexOf("/")+1 ) );
            IconCatDialog->done(1);
        }
    }

    void Mainmenu::createCategory() {
        createCategory(0);
    }

    void Mainmenu::createCategory(int noMessage) {
        // Open file
        QString createCatFileName = addCatEditName->text();
        createCatFileName.replace("ai_category_", "");
        if (createCatFileName != NULL && createCatFileName != QString("No Category")) {
            // Subcategory
            int DirError = 0;
            QString dirName;
            if (addCatCBox->currentIndex() > 0) {
                // create sub-dir
                dirName = Entry::listCatoriseAvailMens.at( addCatCBox->currentIndex() );
                QDir dir;
                if (dir.exists("/opt/catorise/share/"+dirName) == 0) {
                    if (dir.mkdir("/opt/catorise/share/"+dirName) != 0) {
                        // Dir created
                        createCatFileName = dirName + "/" + createCatFileName;
                    }
                    else {
                        // error
                        DirError = 1;
                    }
                }
                else {
                    createCatFileName = dirName + "/" + createCatFileName;
                }
            }

            if (DirError == 0) {
                QFile file("/opt/catorise/share/"+createCatFileName+".directory");
                if (file.exists() != 1) {
                    if (file.open(QIODevice::WriteOnly | QIODevice::Text)) {
                        // Icon file
                        if (catIconPath != NULL) {
                            QString catIconBasename = catIconPath;
                            catIconBasename = catIconBasename.mid( catIconBasename.lastIndexOf("/")+1 );
                            catIconBasename.chop(4);
                            catIconBasename = "catorise_cat_"+catIconBasename;
                            QProcess *exeApp = new QProcess(this);
                            exeApp->start("/bin/busybox sh -c \"echo cp '"+catIconPath+"' '/opt/usr/share/icons/hicolor/64x64/hildon/"+catIconBasename+".png'|root\""); // Copy file
                            catIcon = catIconBasename;
                        }
                        else {
                            catIcon = "";
                        }

                        // Create file with info
                        QString CatInfo = QString("[Desktop Entry]\n" \
                                                  "Type=Directory\n" \
                                                  "Name="+addCatEditName->text()+"\n" \
                                                  "Icon="+catIcon+"\n" \
                                                  "X-Text-Domain=hildon-application-manager");
                        QTextStream saveCat(&file);
                        saveCat << CatInfo;
                        // Close file
                        file.close();

                        if (noMessage == 0) {
                            // set message
                            showInformationBox("Category \""+ ( QString::fromLocal8Bit(gettext(addCatEditName->text().toUtf8()) ) ).trimmed() +"\" was added.\nPlease click \"Save\" to reload the menu.", 1);
                            // Generate new list
                            Entry *entry;
                            entry->CreateList();
                            putEntriesToLayout();
                        }
                    }
                    else {
                        showInformationBox("File /opt/catorise/share/"+createCatFileName+".directory can't be open.");
                    }
                }
                else {
                    showInformationBox("Category \""+ ( QString::fromLocal8Bit(gettext(addCatEditName->text().toUtf8()) ) ).trimmed() +"\" exists.");
                }
            }
            else {
                showInformationBox("File /opt/catorise/share/"+dirName+" can't be make.");
            }
        }
        else {
            showInformationBox("Category name was empty.");
        }
    }

    void Mainmenu::delCategory() {
        QDialog *delCatDialog = new QDialog(this);
        QGridLayout *delCatLayout = new QGridLayout(delCatDialog);
        delCatCBox = new QComboBox;
        QLabel *delCatLabel;

        QPushButton *delCatButtonOK = new QPushButton(tr("&OK")); // OK Button
        delCatLabel = new QLabel("Select a category you want to delete."); // Label

        // List categories
        catList(delCatCBox, 0);

        delCatLayout->addWidget(delCatLabel,0,0,1,0,0); // Label
        delCatLayout->addWidget(delCatCBox,1,0,1,0,0); // Select Box
        delCatLayout->addWidget(delCatButtonOK,0,3,0); // OK Button

        connect(delCatButtonOK,SIGNAL(clicked()),delCatDialog,SLOT(accept())); // If OK, than create Category
        connect(delCatDialog,SIGNAL(accepted()),this,SLOT(deleteCategory()));

        delCatDialog->exec();
    }

    void Mainmenu::deleteCategory() {
        deleteCategory(0);
    }

    void Mainmenu::deleteCategory(int noMessage) {
        QString delCatName = Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex()+1 );
        QFile *delFileName = new QFile();
        if (delFileName->remove("/opt/catorise/share/"+delCatName+".directory") == 1) {
           if (noMessage == 0) {
               // set message
               showInformationBox("Category \""+delCatCBox->currentText()+"\" was deleted.\nPlease click \"Save\" to reload the menu.", 1);
               // Generate new list
               Entry *entry;
               entry->CreateList();
               putEntriesToLayout();
           }
        }
        else {
           // Cannot delete
           showInformationBox("File /opt/catorise/share/"+delCatName+".directory not found.");
        }   
    }

    void Mainmenu::editCategory() {
        QDialog *editCatDialog = new QDialog(this);
        QGridLayout *editCatLayout = new QGridLayout(editCatDialog);
        
        QLabel *editCatLabel = new QLabel("Select a categorie that you want edit.");
        QLabel *editCatLabelName = new QLabel("Category Name:"); // Category Name (Label)
        QLabel *editCatLabelSub = new QLabel("Subcategory:"); // Subcategory
        QLabel *editCatLabelIcon = new QLabel("Category Icon:"); // Category Icon (Label)

        // List categories
        delCatCBox = new QComboBox();
        addCatCBox = new QComboBox();
        catList(delCatCBox, 0);
        catList(addCatCBox, 1);

        getSubCat( Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex()+1 ) );
        getSubAndName( catName );
        addCatEditName = new QLineEdit( catName ); // Category Name (Edit Box)
        addCatSelectIcon = new QPushButton(); // Category Icon (Select)

        // Get Icon
        if (catIcon != NULL) {
            addCatSelectIcon->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/"+catIcon+".png"));
            addCatSelectIcon->setText(catIcon);
        }
        else {
            addCatSelectIcon->setIcon(QIcon());
            addCatSelectIcon->setText("Choose a icon file");
        }

        QPushButton *editCatButtonOK = new QPushButton(tr("&OK")); // OK Button
        QPushButton *editCatButtonAbort = new QPushButton(tr("&Abort")); // Abort Button

        editCatLayout->addWidget(editCatLabel,0,0,1,2,0);
        editCatLayout->addWidget(delCatCBox,1,0,1,3,0);
        editCatLayout->addWidget(editCatLabelName,2,0,0);
        editCatLayout->addWidget(editCatLabelSub,3,0,0);
        editCatLayout->addWidget(editCatLabelIcon,4,0,0);
        editCatLayout->addWidget(addCatEditName,2,1,1,3,0); // Category Name
        editCatLayout->addWidget(addCatCBox,3,1,1,3,0); // Subcategory
        editCatLayout->addWidget(addCatSelectIcon,4,1,1,3,0); // Category Icon (Select)

        editCatLayout->addWidget(editCatButtonOK,0,3,0); // OK Button
        editCatLayout->addWidget(editCatButtonAbort,1,3,0); // Abort Button

        connect(editCatButtonOK,SIGNAL(clicked()),editCatDialog,SLOT(accept())); // If OK, than create Category
        connect(editCatButtonAbort,SIGNAL(clicked()),editCatDialog,SLOT(reject())); // Abort
        connect(delCatCBox,SIGNAL( currentIndexChanged(int) ),this,SLOT( selectCatEdit() )); // Select a category to edit
        connect(addCatSelectIcon,SIGNAL(clicked()),this,SLOT( selectCatIcon() )); // Select Icon file
        connect(editCatDialog,SIGNAL(accepted()),this,SLOT( editCat() ));

        editCatDialog->exec();
    }

    void Mainmenu::getNameAndIcon(QString fileName) {
        QFile file("/opt/catorise/share/"+fileName+".directory");
        if (file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QTextStream fileContent(&file);
            while (!fileContent.atEnd()) {
                QRegExp lineFindName("Name=(.+)");
                QRegExp lineFindIcon("Icon=(.*)");
                QString fileC = fileContent.readLine();
                lineFindName.indexIn( fileC );
                lineFindIcon.indexIn( fileC );

                if (lineFindName.cap(1) != NULL) {
                    catName = lineFindName.cap(1);
                }
                else if (lineFindIcon.cap(1) != NULL || lineFindIcon.cap(0) != NULL) {
                    catIcon = lineFindIcon.cap(1);
                }
            }
            file.close();
        }
    }

    void Mainmenu::getSubCat(QString fileName) {
        if (fileName.contains("/")) {
            QStringList subCats = fileName.split("/");
            QString newCatName = NULL;
            QString subCatDir = NULL;
            for (int i = 0; i < subCats.size(); i++) {
                if (subCatDir == NULL) {
                    subCatDir = subCats.at(i);
                }
                else {
                    subCatDir = subCatDir+"/"+subCats.at(i);
                }
                getNameAndIcon(subCatDir);
                newCatName = newCatName+"/"+( QString::fromLocal8Bit(gettext(catName.toUtf8()) ) ).trimmed();
            }
            catName = newCatName.remove(0,1);
        }
        else {
            getNameAndIcon(fileName);
        }
    }

    void Mainmenu::getSubAndName(QString name) {
        if (name.contains("/")) {
            int SlashPos = name.lastIndexOf("/");
            QString catIconTmp = catIcon;
            QString catNameTmp = name.mid(SlashPos+1);
            QString subCatName = name.mid(0, SlashPos);
            // set correct subcategory
            for (int i = 0; i < Entry::listCatoriseAvailMens.length(); i++) {
                getSubCat(Entry::listCatoriseAvailMens.at(i));
                if ( ( QString::fromLocal8Bit(gettext(catName.toUtf8()) ) ).trimmed() == subCatName) {
                    addCatCBox->setCurrentIndex(i);
                    break;
                }
            }
            catName = catNameTmp;
            catIcon = catIconTmp;
        }
        else {
            catName = name;
            addCatCBox->setCurrentIndex(0);
        }
    }

    void Mainmenu::selectCatEdit() {
        getSubCat( Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex()+1 ) );
        getSubAndName( catName );
        addCatEditName->setText( catName );

        // Get Icon
        if (catIcon != NULL) {
            addCatSelectIcon->setIcon(QIcon("/usr/share/icons/hicolor/64x64/hildon/"+catIcon+".png"));
            addCatSelectIcon->setText(catIcon);
        }
        else {
            addCatSelectIcon->setIcon(QIcon());
            addCatSelectIcon->setText("Choose a icon file");
        }
    }

    void Mainmenu::editCat() {
        deleteCategory(1);
        createCategory(1);

        // rename dir
        QDir dir;
        if (dir.exists("/opt/catorise/share/"+Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex()+1 ) )) {
            dir.rename("/opt/catorise/share/"+Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex()+1 ), "/opt/catorise/share/"+Entry::listCatoriseAvailMens.at( addCatCBox->currentIndex() ) +"/"+ addCatEditName->text() );
        }

        // set old and new name from category
        oldEditName << Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex()+1 );
        newEditName << Entry::listCatoriseAvailMens.at( addCatCBox->currentIndex() ) +"/"+ addCatEditName->text();

        // set message
        showInformationBox("Category \""+ delCatCBox->currentText() +"\" was edited.\nPlease click \"Save\" to reload the menu.", 1);

        // Generate new list
        Entry *entry;
        entry->CreateList();
        putEntriesToLayout();
    }

    void Mainmenu::catList(QComboBox *&cbox, int viewNoCat) {
        for(int k=0;k<Entry::listCatoriseAvailMens.length();k++){
            if (viewNoCat == 0 && k == 0) {
                continue;
            }
            else if (viewNoCat == 1 && k == 0) {
                cbox->insertItem(k, Entry::listCatoriseAvailMens.at(k));
            }
            else {
                int j;
                if (viewNoCat == 0) {
                    j = k-1;
                }
                else {
                   j = k;
                }
                // get filename and iconname
                getSubCat( Entry::listCatoriseAvailMens.at(k) );

                if(catName.operator ==("ai_category_ovi")){
                    cbox->insertItem(j, QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/"+catIcon+".png") ,"Ovi");
                }else{
                    cbox->insertItem(j, QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/"+catIcon+".png") , ( QString::fromLocal8Bit(gettext(catName.toUtf8()) ) ).trimmed() );
                }
            }
        }
    }

    void Mainmenu::updateProgressDialog(){
        progDialog->show();
        int val = progDialog->value()+1;
        progDialog->setValue(val);
        progDialog->setLabelText(progDialog->labelText()+".");
    }

    void Mainmenu::resetProgressDialog(){
        progDialog->hide();
        progDialog->setValue(0);
        progDialog->setLabelText("Refreshing Menu...");
        proc->close();
        showInformationBox("Menu refreshed");
    }

    void Mainmenu::showInformationBox(QString information){
        showInformationBox(information, 0);
    }

    void Mainmenu::showInformationBox(QString information, int noTimeout){
        if (noTimeout == 0) {
            QMaemo5InformationBox::information(this, information,
                                                    QMaemo5InformationBox::DefaultTimeout);
        }
        else {
            QMaemo5InformationBox::information(this, information,
                                                    QMaemo5InformationBox::NoTimeout);
        }
    }

    int Mainmenu::top_application()
    {
        show();
        return 0;
    }
