#include "mainmenu.h"
#include "entry.h"
#include <QDir>
#include <libintl.h>
#include <locale.h>

QStringList Entry::listCatoriseAvailMens;

bool catNameInsensitive(const QString &s1, const QString &s2) {
    
        QString s1o = "ai_category_"+s1;
        QString s2o = "ai_category_"+s2;
        QString s1n = ( QString::fromLocal8Bit(gettext(s1o.toUtf8()) ) ).trimmed();
        QString s2n = ( QString::fromLocal8Bit(gettext(s2o.toUtf8()) ) ).trimmed();
        QString s1nn, s2nn;

        if (s1o != s1n) {
            s1nn = s1n;
        }
        else {
            s1nn = s1;
        }
        if (s2o != s2n) {
            s2nn = s2n;
        }
        else {
            s2nn = s2;
        }

        return s1nn.toLower() < s2nn.toLower();
    
}

Entry::Entry(){

}

void Entry::CreateList() {
    Entry::listCatoriseAvailMens.clear();
    Entry::listCatoriseAvailMens << "No Category";
    readCatDirs(NULL);
    // Sort
    qSort(Entry::listCatoriseAvailMens.begin()+1, Entry::listCatoriseAvailMens.end(), catNameInsensitive);
}

void Entry::readCatDirs(QString dirName) {
    QDir dir("/opt/catorise/share/"+dirName);
    dir.setFilter(QDir::Files | QDir::Dirs);
    dir.setSorting(QDir::Name);
    QString dirActName = dirName;

    if (!dir.exists()) {
        qWarning("Can't find catorise category");
    }
    else {
        QStringList list = dir.entryList();
        for (int i = 2; i < list.size(); i++) {
            if (dirActName != NULL) {
                dirActName = dirName+"/";
            }
            QDir dirTest("/opt/catorise/share/"+dirActName+list.at(i));
            if (dirTest.exists() == 1) {
                readCatDirs(dirActName+list.at(i)); // recursiv...
            }
            else {
                // get fileName without .directory and so...
                QRegExp rx("(.+)\\.directory");
                rx.indexIn(list.at(i));
                QString fileNameFound = rx.cap(1);
                Entry::listCatoriseAvailMens << dirActName+fileNameFound;
            }
        }
    }
}

void Entry::setName(QString name){
    this->name = name;
}

void Entry::setDesktopName(QString desktopName){
    this->desktopName = desktopName;
}

void Entry::setIconPath(QString iconPath){
    this->iconPath = iconPath;
}

void Entry::setTextDomain(QString textDomain){
    this->textDomain = textDomain;
}

void Entry::setActualCategory(QString category){
    this->actualCategory = category;
}

QString Entry::getName(){
    return this->name;
}

QString Entry::getDesktopName(){
    return this->desktopName;
}

QString Entry::getIconPath(){
    return this->iconPath;
}

QString Entry::getTextDomain(){
    return this->textDomain;
}

QString Entry::getActualCategory(){
    return this->actualCategory;
}

void Entry::changedCategory(int index){
    this->setActualCategory(Entry::listCatoriseAvailMens.at(index));
}
