#ifndef MAINMENU_H
#define MAINMENU_H

#include <QMainWindow>
#include <QList>
#include <QProcess>
#include <QDirIterator>
#include "entry.h"

QT_BEGIN_NAMESPACE
class QWidget;
class QGridLayout;
class QAction;
class QLabel;
class QLineEdit;
class QMenu;
class QScrollArea;
class QScrollBar;
class QStringList;
class QComboBox;
class QProgressDialog;
class QPushButton;
QT_END_NAMESPACE
//! [0]
class Mainmenu : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "com.nokia.catorisegui")
private slots:
    void showAbout();
    void saveMenuFile();
    void addCategory();
    void delCategory();
    void selectCatIcon();
    void createCategory();
    void createCategory(int noMessage);
    void deleteCategory();
    void deleteCategory(int noMessage);
    void editCategory();
    void getNameAndIcon(QString fileName);
    void selectCatEdit();
    void editCat();
    void catList(QComboBox *&cbox);
    void updateProgressDialog();
    void resetProgressDialog();
public slots:
    Q_SCRIPTABLE int top_application();
public:
    Mainmenu();

private:
    QWidget *widget;
    QScrollArea *scrollArea;
    QGridLayout *gLayout;
    QMenu *fileMenu;
    QAction *actSave;
    QAction *actAbout;
    QAction *actAddCategory;
    QAction *actDelCategory;
    QAction *actEditCategory;
    QProgressDialog *progDialog;

    // Category Variabeln
    QLineEdit *addCatEditName; // Category Name (Edit Box)
    QLineEdit *addCatEditIcon; // Category Icon (Edit Box)
    QComboBox *delCatCBox; // Category Delete (Select)
    QString catIconPath; // Category Icon (Select)
    QPushButton *addCatSelectIcon; // Category Icon (Button)
    QString catName;
    QString catIcon;

    QStringList listCatoriseMenEntries;
    QStringList listPossibleIconDirs;
    QList<QLabel *> *listLabels;
    QList<QComboBox *> *listCBoxes;
    QList<Entry *> *listEntries;
    QProcess *proc;
    QDirIterator *it;

    QString getIconPath(QString iconName);

    void createMenu();
    void readMenuFile();
    void generateEntries();
    void readDesktopFileInformation(Entry *);
    void putEntriesToLayout();

    void getPossibleIconDirs();
    void showInformationBox(QString information);
    void showInformationBox(QString information, int noTimeout);


};
//! [0]

#endif
