#include <QtGui>
#include <QtMaemo5>
#include "mainmenu.h"
#include "entry.h"
#include <libintl.h>
#include <locale.h>

bool sortNameInsensitive(Entry * s1, Entry * s2) {
    QString s1n = (QString::fromLocal8Bit(dgettext(s1->getTextDomain().toUtf8(),s1->getName().toUtf8()))).trimmed();
    if(s1n.operator ==(s1->getName())) {
        s1n = s1->getName();
    }

    QString s2n = (QString::fromLocal8Bit(dgettext(s2->getTextDomain().toUtf8(),s2->getName().toUtf8()))).trimmed();
    if(s2n.operator ==(s2->getName())) {
        s2n = s2->getName();
    }

    s1n = s1n.left(15);
    s2n = s2n.left(15);

    return s1n.toLower() < s2n.toLower();
}

Mainmenu::Mainmenu(){
        setWindowTitle("Catorise PLUS");
        readMenuFile();
        getPossibleIconDirs();

        setlocale( LC_ALL, "" );
        textdomain( "hildon-application-manager" );

        widget = new QWidget;
        scrollArea = new QScrollArea;
        gLayout = new QGridLayout(widget);

        listLabels = new QList<QLabel *>();
        listCBoxes = new QList<QComboBox *>();
        listEntries = new QList<Entry *>();

        progDialog = new QProgressDialog("Refreshing Menu...",0,0,100,this);
        progDialog->hide();

        proc = new QProcess(this);

        Entry *entry;
        entry->CreateList();
        generateEntries();
        putEntriesToLayout();

        scrollArea->setWidget(widget);
        scrollArea->setWidgetResizable(true);
        setCentralWidget(scrollArea);

        createMenu();

        connect(proc,SIGNAL(started()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(readyReadStandardOutput()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(stateChanged(QProcess::ProcessState)),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(finished(int)),this,SLOT(resetProgressDialog()));


    }

    void Mainmenu::putEntriesToLayout(){

        Entry *entry;

        for(int i=0;i<listEntries->size();i++){

            entry = listEntries->at(i);

            QLabel *label= new QLabel;

            QString rName = (QString::fromLocal8Bit(dgettext(entry->getTextDomain().toUtf8(),entry->getName().toUtf8()))).trimmed();
            if(rName.operator ==(entry->getName())) {
                rName = entry->getName();
            }

            label->setText("<img style=\"vertical-align:middle\" height=\"48\" width=\"48\" src=\""+entry->getIconPath()+"\" />&nbsp;"+rName.left(15));
            listLabels->append( label );

            QComboBox *comboBox = new QComboBox;

            catList(comboBox);
            comboBox->setCurrentIndex(Entry::listCatoriseAvailMens.indexOf(entry->getActualCategory()));

            connect(comboBox,SIGNAL(currentIndexChanged(int)),entry,SLOT(changedCategory(int)));

            listCBoxes->append( comboBox );

            gLayout->addWidget(comboBox,i,0,0);
            gLayout->addWidget(label,i,1,0);
        }

    }

    void Mainmenu::generateEntries(){
        for(int i=0;i<listCatoriseMenEntries.size();i++){
            QString tmp = QString(listCatoriseMenEntries.at(i));

            Entry *entry = new Entry();
            entry->setDesktopName(tmp.section(':',0,0).trimmed());
            entry->setActualCategory(tmp.section(":",1,1).trimmed());

            readDesktopFileInformation(entry);

            if(!entry->getDesktopName().isNull() && !entry->getDesktopName().isEmpty()
                && !entry->getActualCategory().isNull() && !entry->getActualCategory().isEmpty()){

                listEntries->append(entry);
            }
        }
        // Sort
        qSort(listEntries->begin(), listEntries->end(), sortNameInsensitive);

    }

    void Mainmenu::readDesktopFileInformation(Entry *entry){
        QFile file;

        file.setFileName("/usr/share/applications/hildon/"+entry->getDesktopName()+".desktop");

        if ( file.exists() == 0 ){
            file.setFileName("/home/user/.local/share/applications/hildon/"+entry->getDesktopName()+".desktop");
        }
        
        QString line("");
        bool name = false;
        bool icon = false;
        bool textDomain = false;


        if( entry->getDesktopName().operator==("user-guide")||entry->getDesktopName().operator ==("ovi") ){
            entry->setTextDomain( "maemo-af-desktop" );
            textDomain = !textDomain;
        }

        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            while(!in.atEnd()){
                line = in.readLine();
                if(!name && line.contains("name=",Qt::CaseInsensitive)){
                    entry->setName( line.section("=",1,1).trimmed() );
                    name = !name;
                }else if(!icon && line.contains("icon=",Qt::CaseInsensitive)){
                    entry->setIconPath( getIconPath( line.section("=",1,1).trimmed() ) );
                    icon = !icon;
                }else if(!textDomain && line.contains("x-text-domain=",Qt::CaseInsensitive)){
                    entry->setTextDomain( line.section("=",1,1).trimmed() );
                    textDomain = !textDomain;
                }
            }
        }
        file.close();
    }

    void Mainmenu::createMenu(){

        actSave = new QAction(tr("&Save"), this);
        actAbout = new QAction(tr("A&bout"),this);
        actAddCategory = new QAction(tr("&Add Category"),this);
        actDelCategory = new QAction(tr("&Delete Category"),this);
        actEditCategory = new QAction(tr("&Edit Category"),this);

        connect(actSave,SIGNAL(triggered()),this,SLOT(saveMenuFile()));
        connect(actAbout, SIGNAL(triggered()), this, SLOT(showAbout()));
        connect(actAddCategory, SIGNAL(triggered()), this, SLOT(addCategory()));
        connect(actDelCategory, SIGNAL(triggered()), this, SLOT(delCategory()));
        connect(actEditCategory, SIGNAL(triggered()), this, SLOT(editCategory()));

        fileMenu = menuBar()->addMenu(tr("&File"));
        fileMenu->addAction(actSave);
        fileMenu->addAction(actAbout);
        fileMenu->addAction(actAddCategory);
        fileMenu->addAction(actDelCategory);
        fileMenu->addAction(actEditCategory);

    }

    void Mainmenu::readMenuFile(){
        QFile file("/opt/catorise/menu");
        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            QString line;
            while(!in.atEnd()){
                line = in.readLine();
                listCatoriseMenEntries << line;                 // Complete Line of an Entry, like Programname: Category
            }
        }else{
            showInformationBox("Can't open /opt/catorise/menu");
        }
        file.close();
    }


    QString Mainmenu::getIconPath(QString iconName){
        return "icons:"+iconName+".png";
    }


    void Mainmenu::getPossibleIconDirs(){
        it = new QDirIterator("/opt/usr/share/icons/hicolor/",QStringList()<<"apps"<<"hildon",QDir::Dirs|QDir::NoDotAndDotDot, QDirIterator::Subdirectories);
        while (it->hasNext()) {
             listPossibleIconDirs << it->next();

        }

        QDir::setSearchPaths("icons", listPossibleIconDirs << "/opt/usr/share/pixmaps/");

    }

    void Mainmenu::showAbout()
    {
        QMessageBox::about(this, tr("About Catorise PLUS"),
                tr("<p><b>Catorise PLUS</b> is a extended version from catorise with a graphical user interface.<br />"
                   "It is originally based on catorise by <a href=\"http://www.bleb.org/\">Andrew Flegg</a> and Catorise GUI by Recep Karadas (<a href=\"http://www.reckdesign.de\" >Reckdesign</a>)"
                   "</p>"));
    }

    void Mainmenu::saveMenuFile(){
        // Create menufile
        QString menu;

        for(int i=0;i<listEntries->size();i++){
            menu += QString(listEntries->at(i)->getDesktopName() + ": " + listEntries->at(i)->getActualCategory());
            if(i!=listLabels->size()-1){
                menu +="\n";
            }
        }
        // Open menufile
        QFile file("/opt/catorise/menu");
        if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
            showInformationBox("Can't open /opt/catorise/menu");
            return;
        }

        // Write Menufile
        QTextStream out(&file);
        out << menu;
        out.flush();
        if(out.status() == QTextStream::Ok){
            showInformationBox("Menu file successfully updated");
        }else{
            showInformationBox("Can't write to /opt/catorise/menu");
        }
        file.close();

        // Start Catorise to refresh the menu
        proc->start("/bin/busybox sh -c \"echo /opt/catorise/catorise|root\"");

    }

    void Mainmenu::addCategory() {
        QDialog *addCatDialog = new QDialog(this);
        QGridLayout *addCatLayout = new QGridLayout(addCatDialog);

        QLabel *addCatLabelName = new QLabel("Category Name:"); // Category Name (Label)
        QLabel *addCatLabelIcon = new QLabel("Category Icon:"); // Category Icon (Label)
        QLabel *addCatLabelIconSelect = new QLabel("or select a file:"); // Category Icon (Select, Label)

        addCatEditName = new QLineEdit(); // Category Name (Edit Box)
        addCatEditIcon = new QLineEdit("app_install_"); // Category Icon (Edit Box)
        addCatSelectIcon = new QPushButton("Choose a icon file"); // Category Icon (Select)

        QPushButton *addCatButtonOK = new QPushButton(tr("&OK")); // OK Button
        QPushButton *addCatButtonAbort = new QPushButton(tr("&Abort")); // Abort Button

        addCatLayout->addWidget(addCatLabelName,0,0,0);
        addCatLayout->addWidget(addCatLabelIcon,1,0,0);
        addCatLayout->addWidget(addCatLabelIconSelect,2,0,0);
        addCatLayout->addWidget(addCatEditName,0,1,0); // Category Name
        addCatLayout->addWidget(addCatEditIcon,1,1,0); // Category Icon
        addCatLayout->addWidget(addCatSelectIcon,2,1,0); // Category Icon (Select)

        addCatLayout->addWidget(addCatButtonOK,0,2,0); // OK Button
        addCatLayout->addWidget(addCatButtonAbort,1,2,0); // Abort Button

        connect(addCatButtonOK,SIGNAL(clicked()),addCatDialog,SLOT(accept())); // If OK, than create Category
        connect(addCatButtonAbort,SIGNAL(clicked()),addCatDialog,SLOT(reject())); // Abort
        connect(addCatSelectIcon,SIGNAL(clicked()),this,SLOT( selectCatIcon() )); // Select Icon file
        connect(addCatDialog,SIGNAL(accepted()),this,SLOT(createCategory()));

        addCatDialog->exec();
    }

    void Mainmenu::selectCatIcon() {
        catIconPath = QFileDialog::getOpenFileName(this, "Choose a file", "/home/user/MyDocs/", "Images (*.png)");
        if (catIconPath != NULL) {
            addCatSelectIcon->setIcon( QIcon(catIconPath) );
            addCatSelectIcon->setText( catIconPath.mid( catIconPath.lastIndexOf("/")+1 ) );
        }
    }

    void Mainmenu::createCategory() {
        createCategory(0);
    }

    void Mainmenu::createCategory(int noMessage) {
        // Open file
        QString createCatFileName = addCatEditName->text();
        createCatFileName.replace("ai_category_", "");
        if (createCatFileName != NULL) {
            QFile file("/opt/catorise/share/"+createCatFileName+".directory");
            if (file.exists() != 1) {
                if (file.open(QIODevice::WriteOnly | QIODevice::Text)) {
                    // Icon file
                    QString catIcon;
                    if (catIconPath != NULL) {
                        QString catIconBasename = catIconPath;
                        catIconBasename = catIconBasename.mid( catIconBasename.lastIndexOf("/")+1 );
                        catIconBasename.chop(4);
                        catIconBasename = "catorise_cat_"+catIconBasename;
                        QProcess *exeApp = new QProcess(this);
                        exeApp->start("/bin/busybox sh -c \"echo cp '"+catIconPath+"' '/opt/usr/share/icons/hicolor/64x64/hildon/"+catIconBasename+".png'|root\""); // Copy file
                        catIcon = catIconBasename;
                    }
                    else {
                        catIcon = addCatEditIcon->text();
                    }

                    // Create file with info
                    QString CatInfo = QString("[Desktop Entry]\n" \
                                              "Type=Directory\n" \
                                              "Name="+addCatEditName->text()+"\n" \
                                              "Icon="+catIcon+"\n" \
                                              "X-Text-Domain=hildon-application-manager");
                    QTextStream saveCat(&file);
                    saveCat << CatInfo;
                    // Close file
                    file.close();

                    if (noMessage == 0) {
                        // set message
                        showInformationBox("Category \""+ ( QString::fromLocal8Bit(gettext(addCatEditName->text().toUtf8()) ) ).trimmed() +"\" was added.\nPlease click \"Save\" to reload the menu.", 1);
                    }

                    // Generate new list
                    Entry *entry;
                    entry->CreateList();
                    putEntriesToLayout();
    
                   // Start Catorise to refresh the menu
//                   proc->start("/bin/busybox sh -c \"echo /opt/catorise/catorise|root\"");
                }
                else {
                    showInformationBox("File /opt/catorise/share/"+createCatFileName+".directory can't be open.");
                }
            }
            else {
                showInformationBox("Category \""+ ( QString::fromLocal8Bit(gettext(addCatEditName->text().toUtf8()) ) ).trimmed() +"\" exists.");
            }
        }
        else {
            showInformationBox("Category name was empty.");
        }
    }

    void Mainmenu::delCategory() {
        QDialog *delCatDialog = new QDialog(this);
        QGridLayout *delCatLayout = new QGridLayout(delCatDialog);
        delCatCBox = new QComboBox;
        QLabel *delCatLabel;

        QPushButton *delCatButtonOK = new QPushButton(tr("&OK")); // OK Button
        delCatLabel = new QLabel("Select a category you want to delete."); // Label

        // List categories
        catList(delCatCBox);

        delCatLayout->addWidget(delCatLabel,0,0,1,0,0); // Label
        delCatLayout->addWidget(delCatCBox,1,0,1,0,0); // Select Box
        delCatLayout->addWidget(delCatButtonOK,0,3,0); // OK Button

        connect(delCatButtonOK,SIGNAL(clicked()),delCatDialog,SLOT(accept())); // If OK, than create Category
        connect(delCatDialog,SIGNAL(accepted()),this,SLOT(deleteCategory()));

        delCatDialog->exec();
    }

    void Mainmenu::deleteCategory() {
        deleteCategory(0);
    }

    void Mainmenu::deleteCategory(int noMessage) {
        QString delCatName = Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex() );
        QFile *delFileName = new QFile();
        if (delFileName->remove("/opt/catorise/share/"+delCatName+".directory") == 1) {
           if (noMessage == 0) {
               // set message
               showInformationBox("Category \""+delCatCBox->currentText()+"\" was deleted.\nPlease click \"Save\" to reload the menu.", 1);
           }

           // Generate new list
           Entry *entry;
           entry->CreateList();
           putEntriesToLayout();

           // Start Catorise to refresh the menu
//           proc->start("/bin/busybox sh -c \"echo /opt/catorise/catorise|root\"");
        }
        else {
           // Cannot delete
           showInformationBox("File /opt/catorise/share/"+delCatName+".directory not found.");
        }   
    }

    void Mainmenu::editCategory() {
        QDialog *editCatDialog = new QDialog(this);
        QGridLayout *editCatLayout = new QGridLayout(editCatDialog);
        
        QLabel *editCatLabel = new QLabel("Select a categorie that you want edit.");
        QLabel *editCatLabelName = new QLabel("Category Name:"); // Category Name (Label)
        QLabel *editCatLabelIcon = new QLabel("Category Icon:"); // Category Icon (Label)
        QLabel *editCatLabelIconSelect = new QLabel("or select a file:"); // Category Icon (Select, Label)

        // List categories
        delCatCBox = new QComboBox();
        catList(delCatCBox);

        getNameAndIcon( Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex() ) ); // Get current name and icon
        addCatEditName = new QLineEdit( catName ); // Category Name (Edit Box)
        addCatEditIcon = new QLineEdit( catIcon ); // Category Icon (Edit Box)
        addCatSelectIcon = new QPushButton("Choose a icon file"); // Category Icon (Select)

        QPushButton *editCatButtonOK = new QPushButton(tr("&OK")); // OK Button
        QPushButton *editCatButtonAbort = new QPushButton(tr("&Abort")); // Abort Button

        editCatLayout->addWidget(editCatLabel,0,0,1,2,0);
        editCatLayout->addWidget(delCatCBox,1,0,1,3,0);
        editCatLayout->addWidget(editCatLabelName,2,0,0);
        editCatLayout->addWidget(editCatLabelIcon,3,0,0);
        editCatLayout->addWidget(editCatLabelIconSelect,4,0,0);
        editCatLayout->addWidget(addCatEditName,2,1,1,3,0); // Category Name
        editCatLayout->addWidget(addCatEditIcon,3,1,1,3,0); // Category Icon
        editCatLayout->addWidget(addCatSelectIcon,4,1,1,3,0); // Category Icon (Select)

        editCatLayout->addWidget(editCatButtonOK,0,3,0); // OK Button
        editCatLayout->addWidget(editCatButtonAbort,1,3,0); // Abort Button

        connect(editCatButtonOK,SIGNAL(clicked()),editCatDialog,SLOT(accept())); // If OK, than create Category
        connect(editCatButtonAbort,SIGNAL(clicked()),editCatDialog,SLOT(reject())); // Abort
        connect(delCatCBox,SIGNAL( currentIndexChanged(int) ),this,SLOT( selectCatEdit() )); // Select a category to edit
        connect(addCatSelectIcon,SIGNAL(clicked()),this,SLOT( selectCatIcon() )); // Select Icon file
        connect(editCatDialog,SIGNAL(accepted()),this,SLOT( editCat() ));

        editCatDialog->exec();
    }

    void Mainmenu::getNameAndIcon(QString fileName) {
        QFile file("/opt/catorise/share/"+fileName+".directory");
        if (file.open(QIODevice::ReadOnly | QIODevice::Text)) {
            QTextStream fileContent(&file);
            while (!fileContent.atEnd()) {
                QRegExp lineFindName("Name=(.+)");
                QRegExp lineFindIcon("Icon=(.+)");
                QString fileC = fileContent.readLine();
                lineFindName.indexIn( fileC );
                lineFindIcon.indexIn( fileC );

                if (lineFindName.cap(1) != NULL) {
                    catName = lineFindName.cap(1);
                }
                else if (lineFindIcon.cap(1) != NULL) {
                    catIcon = lineFindIcon.cap(1);
                }
            }
            file.close();
        }
    }

    void Mainmenu::selectCatEdit() {
        getNameAndIcon( Entry::listCatoriseAvailMens.at( delCatCBox->currentIndex() ) );
        addCatEditName->setText( catName );
        addCatEditIcon->setText( catIcon );
    }

    void Mainmenu::editCat() {
        deleteCategory(1);
        createCategory(1);

        // set message
        showInformationBox("Category \""+ delCatCBox->currentText() +"\" was edited.\nPlease click \"Save\" to reload the menu.", 1);
    }

    void Mainmenu::catList(QComboBox *&cbox) {
        for(int k=0;k<Entry::listCatoriseAvailMens.length();k++){
                // get filename and iconname
                getNameAndIcon(Entry::listCatoriseAvailMens.at(k));

                if(catName.operator ==("ai_category_ovi")){
                    cbox->insertItem(k, QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/"+catIcon+".png") ,"Ovi");
                }else{
                    cbox->insertItem(k, QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/"+catIcon+".png") , ( QString::fromLocal8Bit(gettext(catName.toUtf8()) ) ).trimmed() );
                }
        }
    }

    void Mainmenu::updateProgressDialog(){
        progDialog->show();
        int val = progDialog->value()+1;
        progDialog->setValue(val);
        progDialog->setLabelText(progDialog->labelText()+".");
    }

    void Mainmenu::resetProgressDialog(){
        progDialog->hide();
        progDialog->setValue(0);
        progDialog->setLabelText("Refreshing Menu...");
        proc->close();
        showInformationBox("Menu refreshed");
    }

    void Mainmenu::showInformationBox(QString information){
        showInformationBox(information, 0);
    }

    void Mainmenu::showInformationBox(QString information, int noTimeout){
        if (noTimeout == 0) {
            QMaemo5InformationBox::information(this, information,
                                                    QMaemo5InformationBox::DefaultTimeout);
        }
        else {
            QMaemo5InformationBox::information(this, information,
                                                    QMaemo5InformationBox::NoTimeout);
        }
    }

    int Mainmenu::top_application()
    {
        show();
        return 0;
    }
