
#include <QtGui>
#include <QtMaemo5>
#include "mainmenu.h"
#include "entry.h"
#include <libintl.h>
#include <locale.h>


Mainmenu::Mainmenu(){
        setWindowTitle("Catorise GUI");
        readMenuFile();
        getPossibleIconDirs();

        setlocale( LC_ALL, "" );
        textdomain( "hildon-application-manager" );

        widget = new QWidget;
        scrollArea = new QScrollArea;
        gLayout = new QGridLayout(widget);

        listLabels = new QList<QLabel *>();
        listCBoxes = new QList<QComboBox *>();
        listEntries = new QList<Entry *>();

        progDialog = new QProgressDialog("Refreshing Menu...",0,0,100,this);
        progDialog->hide();

        proc = new QProcess(this);


        generateEntries();
        putEntriesToLayout();

        scrollArea->setWidget(widget);
        scrollArea->setWidgetResizable(true);
        setCentralWidget(scrollArea);

        createMenu();

        connect(proc,SIGNAL(started()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(readyReadStandardOutput()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(stateChanged(QProcess::ProcessState)),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(finished(int)),this,SLOT(resetProgressDialog()));


    }

    void Mainmenu::putEntriesToLayout(){

        Entry *entry;

        for(int i=0;i<listEntries->size();i++){

            entry = listEntries->at(i);

            QLabel *label= new QLabel;
			
            QString rName = (QString::fromLocal8Bit(dgettext(entry->getTextDomain().toUtf8(),entry->getName().toUtf8()))).trimmed();
            if(rName.operator ==(entry->getName())) {
                rName = entry->getName();
            }

            label->setText("<img style=\"vertical-align:middle\" height=\"48\" width=\"48\" src=\""+entry->getIconPath()+"\" />&nbsp;"+rName.left(15));
            listLabels->append( label );

            QComboBox *comboBox = new QComboBox;

            for(int j=0;j<Entry::listCatoriseAvailMens.length();j++){
                QString realCatName = "ai_category_"+Entry::listCatoriseAvailMens.at(j);
                if(realCatName.operator ==("ai_category_ovi")){
                    comboBox->insertItem(j,QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/app_install_"+Entry::listCatoriseAvailMens.at(j)+".png"),"Ovi");
                }else{
                    comboBox->insertItem(j,QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/app_install_"+Entry::listCatoriseAvailMens.at(j)+".png"), ( QString::fromLocal8Bit(gettext(realCatName.toUtf8()) ) ).trimmed()  );
                }
            }
            comboBox->setCurrentIndex(Entry::listCatoriseAvailMens.indexOf(entry->getActualCategory()));

            connect(comboBox,SIGNAL(currentIndexChanged(int)),entry,SLOT(changedCategory(int)));

            listCBoxes->append( comboBox );

            gLayout->addWidget(comboBox,i,0,0);
            gLayout->addWidget(label,i,1,0);
        }

    }

    void Mainmenu::generateEntries(){
        for(int i=0;i<listCatoriseMenEntries.size();i++){
            QString tmp = QString(listCatoriseMenEntries.at(i));

            Entry *entry = new Entry();
            entry->setDesktopName(tmp.section(':',0,0).trimmed());
            entry->setActualCategory(tmp.section(":",1,1).trimmed());

            readDesktopFileInformation(entry);

            if(!entry->getDesktopName().isNull() && !entry->getDesktopName().isEmpty()
                && !entry->getActualCategory().isNull() && !entry->getActualCategory().isEmpty()){

                listEntries->append(entry);
            }
        }

    }

    void Mainmenu::readDesktopFileInformation(Entry *entry){
        QFile file("/usr/share/applications/hildon/"+entry->getDesktopName()+".desktop");
        QString line("");
        bool name = false;
        bool icon = false;
        bool textDomain = false;


        if( entry->getDesktopName().operator==("user-guide")||entry->getDesktopName().operator ==("ovi") ){
            entry->setTextDomain( "maemo-af-desktop" );
            textDomain = !textDomain;
        }

        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            while(!in.atEnd()){
                line = in.readLine();
                if(!name && line.contains("name=",Qt::CaseInsensitive)){
                    entry->setName( line.section("=",1,1).trimmed() );
                    name = !name;
                }else if(!icon && line.contains("icon=",Qt::CaseInsensitive)){
                    entry->setIconPath( getIconPath( line.section("=",1,1).trimmed() ) );
                    icon = !icon;
                }else if(!textDomain && line.contains("x-text-domain=",Qt::CaseInsensitive)){
                    entry->setTextDomain( line.section("=",1,1).trimmed() );
                    textDomain = !textDomain;
                }
            }
        }
        file.close();
    }

    void Mainmenu::createMenu(){

        actSave = new QAction(tr("&Save"), this);
        actAbout = new QAction(tr("&About"),this);

        connect(actSave,SIGNAL(triggered()),this,SLOT(saveMenuFile()));
        connect(actAbout, SIGNAL(triggered()), this, SLOT(showAbout()));


        fileMenu = menuBar()->addMenu(tr("&File"));
        fileMenu->addAction(actSave);
        fileMenu->addAction(actAbout);

    }

    void Mainmenu::readMenuFile(){
        QFile file("/opt/catorise/menu");
        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            QString line;
            while(!in.atEnd()){
                line = in.readLine();
                listCatoriseMenEntries << line;                 // Complete Line of an Entry, like Programname: Category
            }
        }else{
            showInformationBox("Can't open /opt/catorise/menu");
        }
        file.close();
    }


    QString Mainmenu::getIconPath(QString iconName){
        return "icons:"+iconName+".png";
    }


    void Mainmenu::getPossibleIconDirs(){
        it = new QDirIterator("/opt/usr/share/icons/hicolor/",QStringList()<<"apps"<<"hildon",QDir::Dirs|QDir::NoDotAndDotDot, QDirIterator::Subdirectories);
        while (it->hasNext()) {
             listPossibleIconDirs << it->next();

        }

        QDir::setSearchPaths("icons", listPossibleIconDirs << "/opt/usr/share/pixmaps/");

    }

    void Mainmenu::showAbout()
    {
        QMessageBox::about(this, tr("About Catorise GUI"),
                tr("<p><b>Catorise GUI</b> is a graphical user interface for catorise developed by Recep Karadas<br />"
                   "Please visit <a href=\"http://www.reckdesign.de\" >Reckdesign</a>"
                   "</p>"));
    }

    void Mainmenu::saveMenuFile(){
        // Create menufile
        QString menu;

        for(int i=0;i<listEntries->size();i++){
            menu += QString(listEntries->at(i)->getDesktopName() + ": " + listEntries->at(i)->getActualCategory());
            if(i!=listLabels->size()-1){
                menu +="\n";
            }
        }
        // Open menufile
        QFile file("/opt/catorise/menu");
        if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
            showInformationBox("Can't open /opt/catorise/menu");
            return;
        }

        // Write Menufile
        QTextStream out(&file);
        out << menu;
        out.flush();
        if(out.status() == QTextStream::Ok){
            showInformationBox("Menu file successfully updated");
        }else{
            showInformationBox("Can't write to /opt/catorise/menu");
        }
        file.close();

        // Start Catorise to refresh the menu
        proc->start("/bin/busybox sh -c \"echo /opt/catorise/catorise|root\"");

    }

    void Mainmenu::updateProgressDialog(){
        progDialog->show();
        int val = progDialog->value()+1;
        progDialog->setValue(val);
        progDialog->setLabelText(progDialog->labelText()+".");
    }

    void Mainmenu::resetProgressDialog(){
        progDialog->hide();
        progDialog->setValue(0);
        progDialog->setLabelText("Refreshing Menu...");
        proc->close();
        showInformationBox("Menu refreshed");
    }

    void Mainmenu::showInformationBox(QString information){
        QMaemo5InformationBox::information(this, information,
                                                    QMaemo5InformationBox::DefaultTimeout);
    }
    int Mainmenu::top_application()
    {
        show();
        return 0;
    }