
#include <QtGui>
#include <QtMaemo5/QMaemo5InformationBox>
#include "mainmenu.h"
#include "entry.h"

Mainmenu::Mainmenu(){
        setWindowTitle("Catorise GUI");
        readMenuFile();
        getPossibleIconDirs();

// /opt/usr/share/icons/hicolor/48x48/hildon
        widget = new QWidget;
        scrollArea = new QScrollArea;
        gLayout = new QGridLayout(widget);

        listLabels = new QList<QLabel *>();
        listCBoxes = new QList<QComboBox *>();
        listEntries = new QList<Entry *>();

        listCatoriseAvailMens   << "desktop" << "development" << "education" << "games"
                                << "graphics" << "multimedia" << "navigation" << "network"
                                << "other" << "ovi" << "office" << "science" << "system" << "utilities";

        for(int i=0;i<listCatoriseMenEntries.size();i++){
            QString tmp = QString(listCatoriseMenEntries.at(i));

            Entry *entry = new Entry();
            entry->setName(tmp.section(':',0,0).trimmed());
            entry->setActualCategory(tmp.section(":",1,1).trimmed());
            if(!entry->getName().isNull() && !entry->getName().isEmpty()
                && !entry->getActualCategory().isNull() && !entry->getActualCategory().isEmpty()){

                listEntries->append(entry);

                QLabel *label= new QLabel;

                QString iconPath = getIconPath(getIconName(entry->getName()));
                label->setText("<img style=\"vertical-align:middle\" height=\"48\" width=\"48\" src=\""+iconPath+"\" />&nbsp;"+entry->getName());
                listLabels->append( label );

                QComboBox *comboBox = new QComboBox;
                for(int j=0;j<listCatoriseAvailMens.length();j++){
                    comboBox->insertItem(j,QIcon("/opt/usr/share/icons/hicolor/64x64/hildon/app_install_"+listCatoriseAvailMens.at(j)+".png"),listCatoriseAvailMens.at(j));
                }
                comboBox->setCurrentIndex(listCatoriseAvailMens.indexOf(entry->getActualCategory()));

                connect(comboBox,SIGNAL(currentIndexChanged(QString)),entry,SLOT(changedCategory(QString)));

                listCBoxes->append( comboBox );

                gLayout->addWidget(comboBox,i,0,0);
                gLayout->addWidget(label,i,1,0);
            }
        }

        scrollArea->setWidget(widget);
        scrollArea->setWidgetResizable(true);
        setCentralWidget(scrollArea);

        createMenu();

        progDialog = new QProgressDialog("Refreshing Menu...",0,0,100,this);
        progDialog->hide();

        proc = new QProcess(this);

        connect(proc,SIGNAL(started()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(readyReadStandardOutput()),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(stateChanged(QProcess::ProcessState)),this,SLOT(updateProgressDialog()));
        connect(proc,SIGNAL(finished(int)),this,SLOT(resetProgressDialog()));


    }
    void Mainmenu::createMenu(){

        actSave = new QAction(tr("&Save"), this);
        actAbout = new QAction(tr("&About"),this);

        connect(actSave,SIGNAL(triggered()),this,SLOT(saveMenuFile()));
        connect(actAbout, SIGNAL(triggered()), this, SLOT(showAbout()));


        fileMenu = menuBar()->addMenu(tr("&File"));
        fileMenu->addAction(actSave);
        fileMenu->addAction(actAbout);

    }

    void Mainmenu::readMenuFile(){
        QFile file("/opt/catorise/menu");
        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            QString line;
            while(!in.atEnd()){
                line = in.readLine();
                listCatoriseMenEntries << line;                 // Complete Line of an Entry, like Programname: Category
            }
        }else{
            showInformationBox("Can't open /opt/catorise/menu");
        }
        file.close();
    }

    QString Mainmenu::getIconName(QString desktopName){
        QFile file("/usr/share/applications/hildon/"+desktopName+".desktop");
        QString line("");

        if( file.open(QIODevice::ReadOnly|QIODevice::Text) ){
            QTextStream in(&file);
            while(!in.atEnd()){
                line = in.readLine();
                if(line.contains("icon=",Qt::CaseInsensitive)){
                    line =  line.section("=",1,1).trimmed();
                    break;
                }
            }
        }
        file.close();
        return line;
    }

    QString Mainmenu::getIconPath(QString iconName){
        return "icons:"+iconName+".png";
    }

    void Mainmenu::getPossibleIconDirs(){
        it = new QDirIterator("/opt/usr/share/icons/hicolor/",QStringList()<<"apps"<<"hildon",QDir::Dirs|QDir::NoDotAndDotDot, QDirIterator::Subdirectories);
        while (it->hasNext()) {
             listPossibleIconDirs << it->next();

        }

        QDir::setSearchPaths("icons", listPossibleIconDirs << "/opt/usr/share/pixmaps/");

    }

    void Mainmenu::showAbout()
    {
        QMessageBox::about(this, tr("About Catorise GUI"),
                tr("<p><b>Catorise GUI</b> is a graphical user interface for catorise developed by Recep Karadas<br />"
                   "Please visit <a href=\"http://www.reckdesign.de\" >Reckdesign</a>"
                   "</p>"));
    }

    void Mainmenu::saveMenuFile(){
        // Create menufile
        QString menu;

        for(int i=0;i<listLabels->size();i++){
            menu += QString(listEntries->at(i)->getName() + ": " + listEntries->at(i)->getActualCategory());
            if(i!=listLabels->size()-1){
                menu +="\n";
            }
        }
        // Open menufile
        QFile file("/opt/catorise/menu");
        if (!file.open(QIODevice::WriteOnly | QIODevice::Text)){
            showInformationBox("Can't open /opt/catorise/menu");
            return;
        }

        // Write Menufile
        QTextStream out(&file);
        out << menu;
        out.flush();
        if(out.status() == QTextStream::Ok){
            showInformationBox("Menu file successfully updated");
        }else{
            showInformationBox("Can't write to /opt/catorise/menu");
        }
        file.close();

        // Start Catorise to refresh the menu
        proc->start("/bin/busybox sh -c \"echo /opt/catorise/catorise|root\"");

    }
    void Mainmenu::updateProgressDialog(){
        progDialog->show();
        int val = progDialog->value()+1;
        progDialog->setValue(val);
        progDialog->setLabelText(progDialog->labelText()+".");
    }

    void Mainmenu::resetProgressDialog(){
        progDialog->hide();
        progDialog->setValue(0);
        progDialog->setLabelText("Refreshing Menu...");
        proc->close();
        showInformationBox("Menu refreshed");
    }

    void Mainmenu::showInformationBox(QString information){
        QMaemo5InformationBox::information(this, information,
                                                    QMaemo5InformationBox::DefaultTimeout);
    }
