/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologiaa
 *
 *  This file is part of carmand.
 *
 *  carmand is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  carmand is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with carmand.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __TRIP__H__
#define __TRIP__H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define RPM_PID 12
#define SPEED_PID 13

/* defines used also by carman-python/ui/main/trip.c
 */
#define TRIP_LAT_LON	1 << 0
#define TRIP_ALTITUDE	1 << 1
#define TRIP_RPM		1 << 2
#define TRIP_SPEED		1 << 3
#define TRIP_DISTANCE	1 << 4

#define PACKED __attribute__((packed))

/* struct trip_header used also by carman-python/ui/main/trip.c
 */
struct trip_header {
	char file_header[4];			/* Carman File Header */
	int app_version;				/* Carman App Version */
	int file_version;				/* Carman File Version */
	time_t start_time, end_time; 	/* Seconds since 1970-01-01 00:00:00 */
	int precision;					/* Milseconds */
};

/* struct trip_data used also by carman-python/ui/main/trip.c
 */
struct trip_data {
	double lat;
	double lon;
	double alt;
	double distance;
	unsigned short rpm;
	unsigned char speed;
	char flag;
} PACKED;

char *trip_init(const char *folder, int precision);
int trip_restart(const char *folder, const char *trips_folder);
int trip_set_precision(char *folder, int precision);
int trip_reset(char *folder, int precision);
int trip_exit(void);
int trip_flush_fds(void);
const char *trip_actual_folder(void);
#endif
