#!/usr/bin/python
#
#   Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
# 
#   This file is part of carmand.
#   
#   carmand is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   carmand is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 

import gobject

import dbus, sys
import dbus.mainloop.glib

import datetime

def data_available(pid, val1, val2, val3, val4):
    a = datetime.datetime.now()
    print "%02d:%02d:%02d.%06ld pid[0x%02x/%02d]: %lf/%lf %lf/%lf" % (a.hour, a.minute, a.second, a.microsecond, pid, pid, val1, val3,val2, val4)

if __name__ == '__main__':

        # FireFly: 00:A0:96:12:B1:8B
        #  CarPal: 00:80:98:C4:81:FF

        bt = "00:A0:96:12:B1:8B"
        if len(sys.argv) == 2:
            bt = sys.argv[1]

        print "Connecting to: ", bt

        dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)

        _dbus_address = "unix:path=/var/run/carmand-dbus-path"
        bus = dbus.bus.BusConnection(_dbus_address)
        # bus = dbus.SystemBus()
        carman = bus.get_object("org.indt.carmand", "/org/indt/carmand")

        config = dbus.Interface(carman, "org.indt.carmand.Configuration")
        config.SetOBDDevice("00:A0:96:12:B1:8B")

        obd = dbus.Interface(carman, "org.indt.carmand.OBD")
        obd.ConnectBT()

        bus.add_signal_receiver(data_available,
        bus_name = "org.indt.carmand",
        path = "/org/indt/carmand",
        dbus_interface = "org.indt.carmand.OBD",
        signal_name = "DataAvailable")

        print "AddRoundSensor(17, 1, 0)"
        print "AddRoundSensor(12, 1, 0)"
        print "AddRoundSensor(13, 1, 0)"
        print "AddRoundSensor(4, 1, 0)"

        obd.AddRoundSensor(17, 1, 0)
        obd.AddRoundSensor(12, 1, 0)
        obd.AddRoundSensor(13, 1, 0)
        obd.AddRoundSensor(14, 1, 0)

        mainloop = gobject.MainLoop()
        mainloop.run()
