#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

import logging

from terra.core.terra_object import TerraObject
from terra.core.manager import Manager

class OnTheGoHook(TerraObject):
    terra_type = "Hook/Abstract/OnTheGo"

    def __init__(self):
        TerraObject.__init__(self)

    def setup(self):
        pass

    def delete(self):
        pass

    def playlist_saved(self, identifier):
        pass

    def playlist_cleared(self):
        pass


class OnTheGoAudioHooklist(TerraObject):
    terra_type = "OnTheGo/Audio/Hooklist"
    hooks_type = "Hook/OnTheGo"

    def __init__(self):
        TerraObject.__init__(self)
        self._hooks = []
        self.log = logging.getLogger("canola.plugins.audio.onthego")
        self._get_hooks()

    def _get_hooks(self):
        try:
            hooks_cls = Manager().get_classes(self.hooks_type)
        except ValueError, e:
            self.log.debug("no OTG hooks with type %r", self.hooks_type)
            return

        self.log.debug("found %d OTG hooks", len(hooks_cls))
        for cls in hooks_cls:
            self.add(cls())

    def add(self, hook):
        self.log.debug("adding OTG hook '%s'", hook)
        hook.setup()
        self._hooks.append(hook)

    def remove(self, hook):
        self.log.debug("removing OTG hook '%s'", hook)
        hook.delete()
        self._hooks.remove(hook)

    def delete(self):
        self.log.debug("wiping '%d' OTG hooks", len(self._hooks))
        for h in self._hooks:
            h.delete()
        self._hooks = []

    def _call_hooks(self, methname, *args):
        self.log.debug("calling method '%s' from %d OTG hooks",
                       methname, len(self._hooks))
        for h in self._hooks:
            meth = getattr(h, methname)
            meth(*args)

    def inform_playlist_saved(self, identifier):
        self._call_hooks("playlist_saved", identifier)

    def inform_playlist_cleared(self):
        self._call_hooks("playlist_cleared")
