import gtk
import gobject
import hildondesktop
import sqlite3
import time
import dbus
import osso
import atexit
from dbus.mainloop.glib import DBusGMainLoop


class CallNotify(hildondesktop.StatusMenuItem):
    def __init__(self):
		hildondesktop.StatusMenuItem.__init__(self)
		
		self.path = "/home/user/.rtcom-eventlogger/el.db"
		
		# Prevent multiple timers to refresh the status icon
		self.stop = False
		
		# Load images
		self.loadImages()
		self.msgType = ""		
		self.toShow = True
		self.missed = self.getMissedCallsCount(False)
		self.missedSMS = self.getMissedCallsCount(True)
		self.missedLastCall = self.missed
		self.missedLastSMS = self.missedSMS
		self.mainLoop = None		
		# Register to handle screen off/on events
		osso_c = osso.Context("osso_test_device_on", "0.0.1", False)
		device = osso.DeviceState(osso_c)
		device.set_display_event_cb(self.state_cb)

		self.tmr_main = gobject.timeout_add(5000, self.handleMissedCall) 
		
		# add d-bus listener for removing notification after viewing missed call
		# Doing timeout_add with return False instead of explicitly raising a thread
		gobject.timeout_add(500, self.startDbusListeners)
		atexit.register(self.cleanup)

    def cleanup():
		gobject.source_remove(self.tmr_main)                           
                gobject.source_remove(self.tmr_ptr) 		
		self.mainLoop.quit()

    def loadImages(self):
		# Load phone image
		#self.pixbuf = gtk.gdk.pixbuf_new_from_file_at_size("/home/user/phone.png",18,18)
		icon_theme = gtk.icon_theme_get_default()
		self.callPicture = icon_theme.load_icon("general_call", 18, gtk.ICON_LOOKUP_NO_SVG)
		self.smsPicture = gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/sms.png",18,18)
		
		# Load 5 numbers and the "+5" 
		self.imgList = []
		#self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/home/user/1.png",18,18))
		self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/1.png",18,18))
		self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/2.png",18,18))
		self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/3.png",18,18))
		self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/4.png",18,18))
		self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/5.png",18,18))
		self.imgList.append(gtk.gdk.pixbuf_new_from_file_at_size("/usr/share/CallNotify/more.png",18,18))
		
	# Screen off event-handler
    def state_cb(self, state):
	if state == osso.device_state.OSSO_DISPLAY_OFF:
		gobject.source_remove(self.tmr_main)
		gobject.source_remove(self.tmr_ptr)
	elif state == osso.device_state.OSSO_DISPLAY_ON:
		self.tmr_main = gobject.timeout_add(5000, self.handleMissedCall)
		self.show()
	return False
		
	# Method to define the way to add dbus signal receiver

    def smsrec(self):
	self.stop_notification(self)

    def startDbusListeners(self):
		DBusGMainLoop(set_as_default=True)                             
                bus = dbus.SessionBus()                                        
                #bus.add_signal_receiver(self.stop_notification, "NotificationClosed", "org.freedesktop.Notifications", "org.freedesktop.Notifications", "/org/freedesktop/Notifications") 
		#bus.add_signal_receiver(self.handleMissedCall, "Notify", None, None, None)
		#bus.add_signal_receiver(self.handleMissedCall, "MembersChanged", None, None, None)
		bus.add_signal_receiver(self.smsReceived, "MessageReceived", None, None, None)
		bus.add_signal_receiver(self.smsRead, "NotificationClosed", "org.freedesktop.Notifications", None, "/org/freedesktop/Notifications")
		bus.add_signal_receiver(self.smsrec, "Closed", None, None, None)

                self.mainLoop = gobject.MainLoop()
		self.mainLoop.run()                                       
		return False
    
    def smsReceived(self, a):
	if a[0].has_key('message-type'):
		if self.missedLastSMS == self.getMissedCallsCount(True):
			if self.msgType == "Call":
				self.msgType = "Both"
			else:
				self.msgType = "SMS"
			self.show()
		self.missedLastSMS = self.getMissedCallsCount(True)
	
    def smsRead(self, a):
	self.stop_notification(a)
	
    def handleMissedCall(self):	
		if self.missedLastCall != self.getMissedCallsCount(False):
			if self.msgType == "SMS":
				self.msgType = "Both"
			else:
				self.msgType = "Call"
			self.show()
			self.missedLastCall = self.getMissedCallsCount(False)
		return True
	
    def stop_notification(self, a):
		self.set_status_area_icon(None)
		gobject.source_remove(self.tmr_ptr)
		self.set_status_area_icon(None)
		# Reset the notification (get recent missed call count)
		self.missed = self.getMissedCallsCount(False)
		self.missedSMS = self.getMissedCallsCount(True)
		self.missedLastCall = self.missed
		self.missedLastSMS = self.missedSMS
		self.stop = False
		self.msgType = ""

    def theLoop(self):
		missedCalls = self.getMissedCallsCount(False)
		if self.missedLastCall != missedCalls:
			self.show()
			self.missedLastCall  = missedCalls
		return True

    def getMissedCallsCount(self, isSms):
		eType = 3
		if isSms:
			eType=7
		conn = sqlite3.connect(self.path)
		cur = conn.cursor()
		cur.execute("select count(id) from Events where event_type_id = " + str(eType))
		return cur.fetchone()[0]

    def show(self):
		# blink the icon every 1 second
		if not(self.stop):
			self.tmr_ptr = gobject.timeout_add(1000, self.blinkIcon)
			self.stop = True
			
    def blinkIcon(self):
		if self.toShow:
			self.toShow = False
			img = self.callPicture
			if self.msgType == "SMS":
				img = self.smsPicture
			self.set_status_area_icon(img)
			return True
		else:
			img = self.smsPicture
			isSMS = False
			counter = self.missed
			if self.msgType == "SMS":
				counter = self.missedSMS
				isSMS = True
			index = self.getMissedCallsCount(isSMS) - counter - 1
			if index >= 5:
				index = 5
				if index < 0:
					index = 0
			if self.msgType != "Both":
				img = self.imgList[index]
			self.toShow = True
			self.set_status_area_icon(img)
			return True
		
hd_plugin_type = CallNotify

