/*
 * callforwarding - Call forwarding control panel applet for N900
 * Copyright (C) 2009  Mikko Mehtonen <mikko.mehtonen@vincit.fi>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#include <stdio.h>
#include <hildon/hildon.h>
#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "maindialog.h"

static void destroy (GtkWidget* widget);

int main(int argc, char *argv[])
{
  setlocale(LC_ALL, "");
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);

  HildonProgram *hildon_program;
  GtkWidget *window;

  hildon_gtk_init (&argc, &argv);
  hildon_program = hildon_program_get_instance ();
  window = hildon_window_new ();
  hildon_program_add_window (hildon_program, HILDON_WINDOW(window));
  g_signal_connect (G_OBJECT(window), "destroy", G_CALLBACK(destroy), NULL);

  maindialog_show (GTK_WINDOW(window));

  gtk_main();
  return 0;
}

static void destroy (GtkWidget *widget)
{
  gtk_main_quit();
}
