/*
 * callforwarding - Call forwarding control panel applet for N900
 * Copyright (C) 2009  Mikko Mehtonen <mikko.mehtonen@vincit.fi>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef _CALLFORWARDING_H__
#define _CALLFORWARDING_H__

#include <gtk/gtk.h>
#include <dbus/dbus-glib.h>

enum callforwardings {
  CALLFORWARDING_ALL, /* set only */
  CALLFORWARDING_UNCONDITIONAL, 
  CALLFORWARDING_BUSY,
  CALLFORWARDING_NO_ANSWER,
  CALLFORWARDING_NO_REACH,
  CALLFORWARDING_NO_AVAIL /* sets all busy, no reply & no reach */
};


/* Callback for call forwarding status query */
typedef void (*callforwarding_status_cb)(GError *error, gboolean status, gchar *number);

/* Query call forwarding status */
void callforwarding_get_status (gint type, callforwarding_status_cb cb);


/* Callback for cancel call forwarding */
typedef void (*callforwarding_cancel_cb)(GError *error);

/* Cancel call forwarding */
void callforwarding_cancel (gint type, callforwarding_cancel_cb cb);


/* Callback for activate call forwarding */
typedef void (*callforwarding_activate_cb)(GError *error);

/* Activate call forwarding */
void callforwarding_activate (gint type, const gchar *number, gint time, callforwarding_activate_cb cb);


/* Callback for net status */
typedef void (*callforwarding_net_status_cb)(gboolean status);
void callforwarding_register_net_status (callforwarding_net_status_cb cb);
void callforwarding_close_net_status ();

void callforwarding_cancel_pending_call (void);

#endif
