/*
 * callforwarding - Call forwarding control panel applet for N900
 * Copyright (C) 2009  Mikko Mehtonen <mikko.mehtonen@vincit.fi>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#include "callforwarding.h"

/* Callback functions */
static void callforwarding_status_int_cb (DBusGProxy *proxy,
                                          DBusGProxyCall *call,
                                          void *user_data);
static void callforwarding_cancel_int_cb (DBusGProxy *proxy,
                                         DBusGProxyCall *call,
                                         void *user_data);
static void callforwarding_activate_int_reply (DBusGProxy *proxy,
                                               DBusGProxyCall *call,
                                               void *user_data);

static DBusGConnection *connection = NULL;
static DBusGProxy *csd_proxy = NULL;
static DBusGProxy *net_proxy = NULL;
static DBusGProxyCall *proxy_call = NULL;

static DBusGProxy *get_csd_proxy (void)
{
  if (csd_proxy == NULL)
  {
    connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, NULL);
    csd_proxy = dbus_g_proxy_new_for_name (connection, 
                                           "com.nokia.csd", 
                                           "/com/nokia/csd/ss", 
                                           "com.nokia.csd.SS");
  }
  return csd_proxy;
}

static DBusGProxy *get_net_proxy (void)
{
  if (net_proxy == NULL)
  {
    connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, NULL);
    net_proxy = dbus_g_proxy_new_for_name (connection, 
                                           "com.nokia.phone.net", 
                                           "/com/nokia/phone/net", 
                                           "Phone.Net");
    dbus_g_proxy_add_signal (net_proxy, "cellular_system_state_change",
                             G_TYPE_UCHAR, G_TYPE_UCHAR, G_TYPE_UCHAR, G_TYPE_INVALID);
  }
  return net_proxy;
}

void callforwarding_get_status (gint type, callforwarding_status_cb cb)
{
  DBusGProxy* proxy = get_csd_proxy ();
  proxy_call = dbus_g_proxy_begin_call_with_timeout(proxy, "DivertCheck",
                                                    callforwarding_status_int_cb, cb, NULL,
                                                    10000,
                                                    G_TYPE_UINT, type,
                                                    G_TYPE_INVALID);
}

static void callforwarding_status_int_cb (DBusGProxy *proxy,
                                          DBusGProxyCall *call,
                                          void *user_data)
{
  GError *error = NULL;
  gboolean state = FALSE;
  gchar *number = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_BOOLEAN, &state,
                         G_TYPE_STRING, &number,
                         G_TYPE_INVALID);
  proxy_call = NULL;

  callforwarding_status_cb cb = (callforwarding_status_cb)user_data;
  cb (error, state, number);
}

void callforwarding_cancel (gint type, callforwarding_cancel_cb cb)
{
  DBusGProxy* proxy = get_csd_proxy ();
  dbus_g_proxy_begin_call_with_timeout(proxy, "DivertCancel",
                                       callforwarding_cancel_int_cb, cb, NULL,
                                       10000,
                                       G_TYPE_UINT, type,
                                       G_TYPE_INVALID);
}

static void callforwarding_cancel_int_cb (DBusGProxy *proxy,
                                         DBusGProxyCall *call,
                                         void *user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_INVALID);
  callforwarding_cancel_cb cb = (callforwarding_cancel_cb)user_data;
  cb (error);
}


void callforwarding_activate (gint type, const gchar *number, gint time, callforwarding_activate_cb cb)
{
  DBusGProxy* proxy = get_csd_proxy ();
  dbus_g_proxy_begin_call_with_timeout(proxy, "DivertActivate",
                                       callforwarding_activate_int_reply, cb, NULL,
                                       10000,
                                       G_TYPE_UINT, type,
                                       G_TYPE_STRING, number,
                                       G_TYPE_UINT, time,
                                       G_TYPE_INVALID);
}

static void callforwarding_activate_int_reply (DBusGProxy *proxy,
                                               DBusGProxyCall *call,
                                               void *user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_INVALID);
  callforwarding_activate_cb cb = (callforwarding_activate_cb)user_data;
  cb (error);
}

void callforwarding_cancel_pending_call (void)
{
  if (proxy_call != NULL) 
  {
    dbus_g_proxy_cancel_call (get_csd_proxy(), proxy_call);
  }
}

static void callforwarding_net_status_reply (DBusGProxy *proxy,
                                             DBusGProxyCall *call,
                                             gpointer data)
{
  callforwarding_net_status_cb callback = (callforwarding_net_status_cb)data;

  guchar state = 0;
  guchar unused1 = 0;
  guchar unused2 = 0;
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_UCHAR, &state,
                         G_TYPE_UCHAR, &unused1,
                         G_TYPE_UCHAR, &unused2,
                         G_TYPE_INVALID);

  if (callback != NULL)
  {
    callback (state == 1);
  }
}

void callforwarding_register_net_status (callforwarding_net_status_cb cb)
{
  dbus_g_proxy_begin_call_with_timeout(get_net_proxy (), "get_cs_state",
                                       callforwarding_net_status_reply, cb, NULL,
                                       10000,
                                       G_TYPE_INVALID);
}

void callforwarding_close_net_status ()
{
  dbus_g_proxy_disconnect_signal (get_net_proxy (),
                                  "cellular_system_state_change",
                                  G_CALLBACK(callforwarding_net_status_reply),
                                  NULL);

  /* release proxies */
  if (csd_proxy != NULL)
  {
    g_object_unref (csd_proxy);
    csd_proxy = NULL;
  }
  if (net_proxy != NULL) 
  {
    g_object_unref (net_proxy);
    net_proxy = NULL;
  }
}
