/*
 * callforwarding - Call forwarding control panel applet for N900
 * Copyright (C) 2009  Mikko Mehtonen <mikko.mehtonen@vincit.fi>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#include <hildon/hildon.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "callforwarding.h"
#include "maindialog.h"

#define _(String) gettext (String)

static gpointer parent = NULL;

static void net_status_cb (gboolean active)
{
  if (!active)
  {
    hildon_banner_show_information (GTK_WIDGET(parent), NULL, _("No network connection"));
    gtk_main_quit ();
  } else {
    maindialog_show (GTK_WINDOW(parent));
  }
}

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
  //~ setlocale(LC_ALL, "");
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);

  parent = data;
  callforwarding_register_net_status (net_status_cb);

  gtk_main ();

  callforwarding_close_net_status ();

  return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
  return OSSO_OK;
}
