#include <stdio.h>
#include <hildon/hildon.h>
#include <locale.h>
#include <config.h>
#include <glib/gi18n.h>

#include "maindialog.h"

static void destroy (GtkWidget* widget);

int main(int argc, char *argv[])
{
  setlocale(LC_ALL, "");
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);

  HildonProgram *hildon_program;
  GtkWidget *window;

  hildon_gtk_init (&argc, &argv);
  hildon_program = hildon_program_get_instance ();
  window = hildon_window_new ();
  hildon_program_add_window (hildon_program, HILDON_WINDOW(window));
  g_signal_connect (G_OBJECT(window), "destroy", G_CALLBACK(destroy), NULL);

  maindialog_show (GTK_WINDOW(window));

  gtk_main();
  return 0;
}

static void destroy (GtkWidget *widget)
{
  gtk_main_quit();
}
