#include <stdio.h>

#include "callforwarding.h"


/* Callback functions */
static void callforwarding_status_int_cb(DBusGProxy *proxy,
                                         DBusGProxyCall *call,
                                         void *user_data);
static void callforwarding_cancel_int_cb (DBusGProxy *proxy,
                                         DBusGProxyCall *call,
                                         void *user_data);
static void callforwarding_activate_int_reply (DBusGProxy *proxy,
                                               DBusGProxyCall *call,
                                               void *user_data);


static DBusGConnection *connection = NULL;
static DBusGProxy *csd_proxy = NULL;
static DBusGProxyCall *proxy_call = NULL;


static DBusGProxy *get_proxy (void)
{
  if (csd_proxy == NULL)
  {
    connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, NULL);
    csd_proxy = dbus_g_proxy_new_for_name (connection, "com.nokia.csd", "/com/nokia/csd/ss", "com.nokia.csd.SS");
  }
  return csd_proxy;
}

void callforwarding_get_status (gint type, callforwarding_status_cb cb)
{
  printf("get_status, type=%i\n", type);
  DBusGProxy* proxy = get_proxy ();
  proxy_call = dbus_g_proxy_begin_call_with_timeout(proxy, "DivertCheck",
                                                    callforwarding_status_int_cb, cb, NULL,
                                                    10000,
                                                    G_TYPE_UINT, type,
                                                    G_TYPE_INVALID);
}

static void callforwarding_status_int_cb(DBusGProxy *proxy,
                                         DBusGProxyCall *call,
                                         void *user_data)
{
  GError *error = NULL;
  gboolean state = FALSE;
  gchar *number = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_BOOLEAN, &state,
                         G_TYPE_STRING, &number,
                         G_TYPE_INVALID);
  proxy_call = NULL;

  callforwarding_status_cb cb = (callforwarding_status_cb)user_data;
  cb (error, state, number);
}

void callforwarding_cancel (gint type, callforwarding_cancel_cb cb)
{
  DBusGProxy* proxy = get_proxy ();
  dbus_g_proxy_begin_call_with_timeout(proxy, "DivertCancel",
                                       callforwarding_cancel_int_cb, cb, NULL,
                                       10000,
                                       G_TYPE_UINT, type,
                                       G_TYPE_INVALID);
}

static void callforwarding_cancel_int_cb (DBusGProxy *proxy,
                                         DBusGProxyCall *call,
                                         void *user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_INVALID);
  callforwarding_cancel_cb cb = (callforwarding_cancel_cb)user_data;
  cb (error);
}


void callforwarding_activate (gint type, const gchar *number, gint time, callforwarding_activate_cb cb)
{
  DBusGProxy* proxy = get_proxy ();
  dbus_g_proxy_begin_call_with_timeout(proxy, "DivertActivate",
                                       callforwarding_activate_int_reply, cb, NULL,
                                       10000,
                                       G_TYPE_UINT, type,
                                       G_TYPE_STRING, number,
                                       G_TYPE_UINT, time,
                                       G_TYPE_INVALID);
}

static void callforwarding_activate_int_reply (DBusGProxy *proxy,
                                               DBusGProxyCall *call,
                                               void *user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy,
                         call,
                         &error,
                         G_TYPE_INVALID);
  callforwarding_activate_cb cb = (callforwarding_activate_cb)user_data;
  cb (error);
}

void callforwarding_cancel_pending_call (void)
{
  if (proxy_call != NULL) 
  {
    dbus_g_proxy_cancel_call (get_proxy(), proxy_call);
  }
}
