
#include <libintl.h>
#include <locale.h>
#include <ctime>
#include <clockd/libtime.h>
#include <hildon/hildon.h>
#include <CMulticalendar.h>
#include "cal-home-calendar-util.h"



static time_t 
cal_home_advance_date_by_time_period(struct tm* start,
				     const CalTimePeriod& ctp)
{
  switch(ctp)
  {
  case CAL_TIME_PERIOD_WEEK:
    start->tm_mday+=7;
    break;
  case CAL_TIME_PERIOD_2WEEK:
    start->tm_mday+=2*7;
    break;
  case CAL_TIME_PERIOD_3WEEK:
    start->tm_mday+=3*7;
    break;
  case CAL_TIME_PERIOD_MONTH:
    start->tm_mon+=1;
    break;
  case CAL_TIME_PERIOD_2MONTH:
    start->tm_mon+=2;
    break;
  case CAL_TIME_PERIOD_3MONTH:
    start->tm_mon+=3;
    break;
  case CAL_TIME_PERIOD_6MONTH:
    start->tm_mon+=6;
    break;
  case CAL_TIME_PERIOD_12MONTH:
    start->tm_year+=1;
    break;
  default:
   start->tm_year+=1; 
  }
  return mktime(start);
}

static void
cal_home_time_today_midnight(struct tm* today)
{
  time_get_local(today);
  today->tm_hour = today->tm_min = today->tm_sec = 0;
}

static int
cal_row_count_for_cal_size(const CalSize& cal_size)
{
  switch(cal_size)
  {
  case CAL_SIZE_AUTO:
  case CAL_SIZE_LARGE:
    return LARGE_ROW_COUNT;
  case CAL_SIZE_MEDIUM:
    return MEDIUM_ROW_COUNT;
  case CAL_SIZE_SMALL:
    return SMALL_ROW_COUNT;
  }
}

static GdkPixbuf* 
get_calendar_pixbuf(CComponent* component)
{
  int error = 0;
  //(*event_iter)->getCalendarId(), (*event_iter)->getType());  
  int eventType = component->getType();
  CCalendar* cal = CMulticalendar::MCInstance()->getCalendarById(component->getCalendarId(), error);

  GdkPixbuf* pixbuf = NULL;
  switch(cal->getCalendarColor())
  {
  case COLOUR_DARKBLUE:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_darkblue", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_DARKGREEN:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_darkgreen", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_DARKRED:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_darkred", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_ORANGE:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_orange", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_VIOLET:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_violet", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_YELLOW:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_yellow", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_BLUE:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_blue", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_RED:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_red", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  case COLOUR_GREEN:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_green", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
    break;
  default:
    pixbuf = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
				      "calendar_colors_white", 26,GTK_ICON_LOOKUP_NO_SVG, NULL);
  }
  delete cal;
  if(eventType == 4 || component->getAlarm())
    {
      cairo_t* cr;
      cairo_surface_t* surface = cairo_image_surface_create_for_data(gdk_pixbuf_get_pixels(pixbuf),
								     CAIRO_FORMAT_RGB24,
								     26, 26,
								     gdk_pixbuf_get_rowstride(pixbuf));
      GdkPixbuf* birthday;
      if(eventType==4)
	birthday = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
					   "calendar_birthday", 16, GTK_ICON_LOOKUP_NO_SVG, NULL);
      else
	birthday = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), 
					   "calendar_alarm", 16, GTK_ICON_LOOKUP_NO_SVG, NULL);
      cr = cairo_create(surface);
      gdk_cairo_set_source_pixbuf(cr, birthday, 5, 5);
      cairo_set_operator(cr, CAIRO_OPERATOR_OVER);
      cairo_paint(cr);
      cairo_surface_destroy(surface);
      cairo_destroy(cr);
      g_object_unref(birthday);
    }
    
  return pixbuf;
}

static void
cal_fill_event_list_ui(CalHomePlugin* desktop_plugin)
{
  GtkTreeIter iter;
  gtk_container_foreach (GTK_CONTAINER (desktop_plugin->event_list_container), (GtkCallback) gtk_widget_destroy, NULL);
  if(gtk_tree_model_get_iter_first(GTK_TREE_MODEL(desktop_plugin->event_list),
				   &iter))
  {
    do
    {
      gchar* time;
      gchar* summary;
      GdkPixbuf *pixbuf;
      gtk_tree_model_get(GTK_TREE_MODEL(desktop_plugin->event_list),
			 &iter,
			 0, &time,
			 1, &summary,
			 2, &pixbuf,
			 -1);
      GtkWidget* line = gtk_hbox_new(FALSE, 0);

      GtkWidget* time_label = gtk_label_new(time);
      GtkWidget* cal_image = gtk_image_new_from_pixbuf(pixbuf);

      hildon_helper_set_logical_font(time_label,
				     "HomeSystemFont");
      hildon_helper_set_logical_color(time_label,
				      GTK_RC_FG,
				      GTK_STATE_NORMAL,
				      "ActiveTextColor");
      GtkWidget* summary_label = gtk_label_new(summary);
      hildon_helper_set_logical_font(summary_label,
				     "HomeSystemFont");
      hildon_helper_set_logical_color(summary_label,
				      GTK_RC_FG,
				      GTK_STATE_NORMAL,
				      "DefaultTextColor");
      gtk_misc_set_alignment (GTK_MISC (time_label), 0, 0); 
      gtk_misc_set_alignment (GTK_MISC (summary_label), 0, 0);
      gtk_misc_set_alignment (GTK_MISC (cal_image), 1, 0);

      gtk_box_pack_start(GTK_BOX(line), time_label, FALSE, FALSE, 8);
      gtk_box_pack_start(GTK_BOX(line), summary_label, TRUE, TRUE, 0);
      gtk_box_pack_start(GTK_BOX(line), cal_image, TRUE, TRUE, 8);
      gtk_box_pack_start(GTK_BOX(desktop_plugin->event_list_container), line, TRUE, FALSE, 4);
      
      g_free(time);
      g_free(summary);
    }while(gtk_tree_model_iter_next(GTK_TREE_MODEL(desktop_plugin->event_list),
				    &iter));
  }
}

static void
cal_delete_ccomponentset_items(SortedCComponentSet& ccomponent_set)
{
  
  for(SortedCComponentSet::const_iterator iter = ccomponent_set.begin();
      iter!=ccomponent_set.end();
      ++iter)
  {
    delete (*iter);
  }
}

static void
cal_condense_ccomponents_set_to_list_store(const SortedCComponentSet& ccomponent_set,
					   GtkListStore* list_store,
					   CalHomePlugin* desktop_plugin,
					   gsize up_to)
{
  struct tm end_date;
  cal_home_time_today_midnight(&end_date);
  time_t end_time = cal_home_advance_date_by_time_period(&end_date,
							 desktop_plugin->cal_time_period);

  GtkTreeIter iter;
  
  for(SortedCComponentSet::const_iterator event_iter = ccomponent_set.begin();
      event_iter != ccomponent_set.end() && up_to>0;
      ++event_iter)
  {
    gtk_list_store_append(list_store,
			  &iter);

    string summary = (*event_iter)->getSummary();
    string component = (*event_iter)->toString();
    time_t start = (*event_iter)->getDateStart();

    struct tm* time = localtime(&start);
    char buf[255];
    if(time->tm_year == desktop_plugin->date_today.tm_year &&
       time->tm_mon == desktop_plugin->date_today.tm_mon &&
       time->tm_mday== desktop_plugin->date_today.tm_mday)
    {
      if((*event_iter)->getAllDay())
      {      
	gtk_list_store_set(list_store, &iter,
			   0, dgettext("calendar", "cal_va_allday_home"),
			   -1);
      }
      else
      {
	if(desktop_plugin->has_24_time_format)
	  strftime(buf, 255,dgettext("hildon-libs","wdgt_va_24h_time"), time);
	else
	{
	  if(time->tm_hour>11)
	  {
	    strftime(buf, 255,dgettext("hildon-libs","wdgt_va_12h_time_pm"), time);
	  }
	  else
	  {
	    strftime(buf, 255,dgettext("hildon-libs","wdgt_va_12h_time_am"), time);
	  }
	}
	gtk_list_store_set(list_store, &iter,
			   0, buf,
			   -1);
      }
    }
    else
    {
      strftime(buf, 255,dgettext("hildon-libs","wdgt_va_date_short"), time);
      gtk_list_store_set(list_store, &iter,
			 0, buf,
			 -1);
    }
    GdkPixbuf *pixbuf = get_calendar_pixbuf(*event_iter);

    gtk_list_store_set(list_store, &iter,
		       1, summary.c_str(), 
		       2, pixbuf,
		       -1);
    
    g_object_unref(pixbuf);
    --up_to;
  }
}

static void
cal_read_ccomponents_all_visible(SortedCComponentSet& all_components,
				 CalHomePlugin* desktop_plugin)
{
  time_t start_time = mktime(&desktop_plugin->date_today);
  struct tm end_date = desktop_plugin->date_today;
  time_t end_time = cal_home_advance_date_by_time_period(&end_date,
							 desktop_plugin->cal_time_period);

  vector<CComponent*> calendars_components[desktop_plugin->number_visible_cals];
  for(int i=0;i<desktop_plugin->number_visible_cals;++i)
  {
    int error = 0;
    CCalendar* cal = CMulticalendar::MCInstance()->getCalendarById(desktop_plugin->visible_cals[i], error);
    calendars_components[i] = cal->getComponents((cal->getCalendarType()==1) ? 4 : 1,
						 start_time,
						 end_time,
						 35,
						 0,
						 error);

    time_t last_start_date = start_time;
    for(int k = 0;k<calendars_components[i].size();++k)
    {
      time_t x = calendars_components[i][k]->getDateStart();
      CComponent* component = calendars_components[i][k];
      vector<time_t> instance_times =
	component->getInstanceTimes(last_start_date, 
				    end_time);
      if(instance_times.empty())
	all_components.insert(component);
      else
      {
	for(vector<time_t>::const_iterator iter = instance_times.begin();
	    iter!=instance_times.end();
	    ++iter)
	{
	  CComponent* c = new CComponent(*component);
	  c->setDateStart(*iter);
	  all_components.insert(c);
	}
      }
    }
    delete cal;
  }
}

void 
cal_home_load_db_events(CalHomePlugin* desktop_plugin)
{
  cal_home_time_today_midnight(&desktop_plugin->date_today);
  gtk_list_store_clear(desktop_plugin->event_list);
  SortedCComponentSet all_components;
  cal_read_ccomponents_all_visible(all_components,
				   desktop_plugin);
  cal_condense_ccomponents_set_to_list_store(all_components,
					     desktop_plugin->event_list,
					     desktop_plugin,
					     cal_row_count_for_cal_size(desktop_plugin->cal_size));
  cal_delete_ccomponentset_items(all_components);
  cal_fill_event_list_ui(desktop_plugin);
  desktop_plugin->update_view = FALSE;
  gtk_widget_show_all(desktop_plugin->event_list_container);
  cal_widget_resize_for_cal_size(desktop_plugin);
}
