// Filename: logwindow.cpp

#include <QDebug>

#include <QVBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QScrollArea>
#include <QPushButton>
#include <QDesktopServices>
#include <QUrl>

#include "htmlview.h"
#include "logwindow.h"
#include "iconlabel.h"

#ifdef FLICKCHARM
#include "flickcharm.h"
#endif

class LogWidget : public QGroupBox {
public:
  LogWidget(IconLoader *loader, const Log &log,
	    QWidget *parent = 0) : QGroupBox(parent) {

    QString foundByMessage("(" + log.type().toString() + ") " +
        log.date().toString() + " " + tr("by") + " " + log.finder());

    QVBoxLayout *layout = new QVBoxLayout;
    layout->setContentsMargins(0,0,0,0);

    layout->addWidget(new IconLabel(loader, log.type().iconFile(),
				    foundByMessage));

    layout->addWidget(new FixHtmlView(log.description(), this));
    setLayout(layout);
  }
};

LogWindow::LogWindow(const QString &name, const QList<Log> &logs, 
	     QWidget *parent) : CustomWindow("LogWindow", parent),
	     m_logs(logs), m_iconLoader(24), m_name(name) {

  setWindowTitle(tr("Logs"));

  QScrollArea *scrollArea = new QScrollArea(this);
  scrollArea->setWidgetResizable(true);
  scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

#ifdef FLICKCHARM
  new FlickCharm(scrollArea, this);
#endif

  QWidget *scrollWidget = new QWidget;
  QVBoxLayout *scrollvbox = new QVBoxLayout;
  scrollvbox->setContentsMargins(0,0,0,0);

  QPushButton *button = new QPushButton(tr("Create new log"));
  connect(button, SIGNAL(clicked()), this, SLOT(openLogUrl()));
  scrollvbox->addWidget(button,0,0);

  foreach(Log log, logs) {
    LogWidget *tlog = new LogWidget(&m_iconLoader, log, this);
    scrollvbox->addWidget(tlog,0,0);
  }

  scrollvbox->addStretch(1);
  scrollWidget->setLayout(scrollvbox);
  scrollArea->setWidget(scrollWidget);

  setCentralWidget(scrollArea);
}

LogWindow::~LogWindow() {
  qDebug() << __FUNCTION__;
}

void LogWindow::openLogUrl() {
  qDebug() << __FUNCTION__;
 
  QUrl url("http://www.geocaching.com/seek/log.aspx?wp=" + m_name);
  QDesktopServices::openUrl(url);
}
