#ifndef NAVIGATIONWINDOW_H
#define NAVIGATIONWINDOW_H

#include "locationprovider.h"
#include "customwindow.h"
#include "coordinatetool.h"
#include "cache.h"

class QLabel;
class InfoWidget;

class NavigationWindow : public CustomWindow {
  Q_OBJECT;

 public:
  NavigationWindow(const Cache &, LocationProvider *, QWidget * = 0);
  ~NavigationWindow();
  QString distanceString(qreal distance);
  QString latitudeString(const QGeoCoordinate &);
  QString longitudeString(const QGeoCoordinate &);
  QString zeroCut(qreal, int, int);

 public slots:
  void setPosition(const QGeoPositionInfo &);

 private:
  Cache m_cache;
  CoordinateTool *m_coordinateTool;
  InfoWidget *m_latitude, *m_longitude;
  QLabel *m_distance;
};

#endif
