#ifndef COORDINATE_TOOL_H
#define COORDINATE_TOOL_H

#include <QDialog>
#include <QLabel>

#include <QGeoCoordinate>
#include "iconloader.h"
#include "pickermanager.h"
#include "cache.h"

QTM_USE_NAMESPACE

class CoordinateTool : public QDialog {
  Q_OBJECT;

 public:
  CoordinateTool(const Cache &, QWidget * = 0);
  ~CoordinateTool();

  QWidget *createWidget(const QString & = NULL);

  static QString latitudeString(const QGeoCoordinate &);
  static QString longitudeString(const QGeoCoordinate &);
  static QString zeroCut(qreal, int, int);

 signals:
  void coordinateChanged(const QGeoCoordinate &);

 private slots:
  void editCoordinate();
  void acceptCoordinate();
  void selectWaypoint(const QString &);

 private:
  Cache m_cache;
  IconLoader *m_iconLoader;
  QLabel *m_latitudeLabel, *m_longitudeLabel;

  PickerManager *m_latManager, *m_lonManager;
};

#endif // COORDINATE_TOOL_H
