#ifndef CACHELIST_H
#define CACHELIST_H

#include "cache.h"

class CacheList : QList<Cache> {
 public:
  CacheList();
  CacheList(const QString &);
  ~CacheList();
  void append(Cache);
  int size() const;
  Cache at(int);
  void setName(const QString &);
  QString name();
  QList<Cache>::const_iterator begin() const;
  QList<Cache>::const_iterator end() const;
  QList<Cache>::const_iterator;
  QList<Cache>::iterator begin();
  QList<Cache>::iterator end();
  void clear();
  void setDate(const QDate &);
  QDate date() const;
  void sort(qreal *, int, int);
  void sort(const QGeoCoordinate &);
  void clip(const QGeoBoundingBox &);

 private:
  QString m_name;
  QDate m_date;
};

#endif // CACHELIST_H
