#ifndef NONE_H
#define NONE_H

#include <QObject>

#include "cachelist.h"
#include "cacheproviderplugin.h"

class None : public QObject, public CacheProviderPlugin {
 Q_OBJECT
 Q_INTERFACES(CacheProviderPlugin)
    
public:
  None();
  ~None();

  QString name();
  QString license();
  bool canBeDefault();
  QObject *object();

  void init(QWidget * = 0);
  void createConfig(QDialog *, QVBoxLayout*);

  bool busy();
  void processRequestOverview(const QGeoBoundingBox &, const int, const int);
  void processRequestInfo(const QString &);
  void processRequestDetail(const QString &);

 signals:
  void replyOverview(const CacheList &);
  void reload();
  void done();
  void next();
};

#endif // NONE_H
