#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QGraphicsView>
#include <QGeoServiceProvider>
#include <QMenu>
#include <QMenuBar>

#include "customwindow.h"
#include "locationprovider.h"
#include "mapwidget.h"
#include "cache.h"
#include "cacheprovider.h"
#include "waypointdb.h"
#include "tool.h"

class MainWindow : public CustomWindow {
  Q_OBJECT;

 public:
  MainWindow(LocationProvider *, QWidget *parent = 0);
  ~MainWindow();

 protected:
  void resizeEvent(QResizeEvent* event);
  
 public slots:
  void statusMessage(const QString &);
  // called from map widget whenever the viewport changed
  void reloadCaches();
  void reloadCaches(const int);
  // called from cacheprovider
  void updateCaches(const CacheList &);
  void displayError(const QString &);
  // called from map whenever the user clicked a cache icon
  void selectCache(const QString &);
  void detailCache(const QString &);
  void setBusy(bool on);
  void aboutBox(QWidget *, const QString &, const QString &);
  void enableToolProjection(bool);

 private slots:
  void about();
  void settingsdialog();
  void helpButtonClicked();
  void showDetail(const Cache &);
  void launchToolRot13();
  void launchToolProjection();

 signals:
  void activated(bool);

 private:
  void createMenu();
  bool event(QEvent *);

  QGeoServiceProvider *m_serviceProvider;
  MapWidget *m_mapWidget;
  CacheProvider *m_cacheProvider;
  LocationProvider *m_locationProvider;
  QString m_message;   
  QGraphicsView *m_view;

  WaypointDb *m_wptDb;
  int m_lastFlags;

  QAction *m_ActionToolProjection;
};

#endif
