#ifndef LOCATIONPROVIDER_H
#define LOCATIONPROVIDER_H

#include <QGeoPositionInfoSource>

#ifndef Q_WS_WIN
#include <QCompass>
#endif

QTM_USE_NAMESPACE

class LocationProvider : public QObject {
  Q_OBJECT;

 public:
  LocationProvider();
  ~LocationProvider();

 private slots:
  void positionHasBeenUpdated(const QGeoPositionInfo &);
#ifndef Q_WS_WIN
  void checkCompassReading();
#endif

 signals:
  void positionUpdated(const QGeoPositionInfo &);
#ifndef Q_WS_WIN
  void positionUpdated(const QCompassReading *);
#endif

 private:
  QGeoPositionInfoSource *m_location;
#ifndef Q_WS_WIN
  QCompass *m_compass;
#endif
};

#endif // LOCATIONPROVIDER_H
