#ifndef ICON_LOADER_H
#define ICON_LOADER_H

#include <QList>
#include <QPixmap>
#include <QString>
#include <QStringList>
#include <QSvgRenderer>

#include "cache.h"

class IconLoader {
public:
  IconLoader(int);
  ~IconLoader();
  QPixmap *load(const QString &, int = 0);
  QPixmap *load(const QStringList &, int = 0);
  QPixmap *load(const Cache &, int = 0);
  QPixmap *load(const Container &, int = 0);
  int size() const;
  QWidget *newWidget(const QString &, int = 0);
  QWidget *newWidget(const QStringList &, int = 0);
  QWidget *newWidget(const Cache &, int = 0);

private:
  QSvgRenderer *m_renderer;
  int m_size;
  
  class Pixmap {
  public:
    Pixmap(QSvgRenderer *, const QStringList &, int = 0);
    ~Pixmap();
    QPixmap *pixmap();
    bool is(const QString &);
    bool load(QSvgRenderer *, const QString &);

  private:
    QPixmap *m_pixmap;
    QString m_name;
  };

  QList <Pixmap*> pixmapList;
};

#endif // ICON_LOADER_H
