#ifndef CACHEPROVIDERPLUGIN_H
#define CACHEPROVIDERPLUGIN_H

#include <QNetworkReply>
#include <QMenu>
#include <QVBoxLayout>
#include <QGeoBoundingBox>
QTM_USE_NAMESPACE

#include "cache.h"
class CacheProvider;

class CacheProviderPlugin {

 public:
  virtual void init() = 0;
  virtual QString name() = 0;
  virtual bool busy() = 0;
  virtual void processRequestOverview(const QGeoBoundingBox &) = 0;
  virtual void processRequestInfo(const QString &) = 0;
  virtual void processRequestDetail(const QString &) = 0;
  virtual void createConfig(QDialog *, QVBoxLayout*) = 0;
  virtual QObject *getObject() = 0;

  public slots:
  virtual void replyFinished(QNetworkReply*) = 0;
};

Q_DECLARE_INTERFACE(CacheProviderPlugin,
      "org.harbaum.cacheme.cacheproviderplugin/1.0");

#endif // CACHEPROVIDERPLUGIN_H
