#ifndef COMPASS_H
#define COMPASS_H

#include <QGraphicsView>

#include "cache.h"
#include "graphicscompass.h"

class Compass : public QGraphicsView {
  Q_OBJECT;

 public:
  Compass(const Cache &, QWidget * = 0);
  ~Compass();
  void resizeEvent(QResizeEvent*);
  
 public slots:
  void setPosition(const QGeoPositionInfo &);
  
 signals:
  void positionUpdated(const QGeoPositionInfo &);

 private:
  GraphicsCompass *m_graphicsCompass;
  Cache m_cache;
};

#endif // COMPASS_H
