#include <QGraphicsWidget>
#include <QSvgRenderer>
#include <QStringList>
#include <QTimer>
#include <QList>

#include "cache.h"

#include <QGeoPositionInfo>
QTM_USE_NAMESPACE

class GraphicsCompass : public QGraphicsWidget {
  Q_OBJECT;
 public:
  GraphicsCompass(const Cache &, QGraphicsItem * = 0, Qt::WindowFlags = 0);
  ~GraphicsCompass();
  void paint(QPainter *, const QStyleOptionGraphicsItem *, QWidget * = 0);
  QString assembleFilename(const QStringList &);
  bool load(QSvgRenderer *, const QString &);

 public slots:
  void timerExpired();
  void setPosition(const QGeoPositionInfo &);
 
 private:
  QSvgRenderer *m_roseRenderer, *m_needleRenderer;
  QSvgRenderer *m_backgroundRenderer, *m_cacheRenderer;
  QTimer *m_timer;
  qreal m_roseAngle, m_needleAngle;
  qreal m_roseSpeed, m_roseVAngle;
  Cache m_cache;
  static const qreal RATE=10;
  QPixmap *m_bgPix;
};

