#include <QDebug>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QLabel>
#include <QSettings>

#include "gcdialog.h"

void GcDialog::applyChanges() {
  qDebug() << __FUNCTION__;

  QSettings settings;
  settings.beginGroup("GcLive");
  settings.setValue("Name", m_name->text());
  settings.setValue("Password", m_password->text());
  settings.endGroup();

  // (re-)login in now
  m_plugin->login(m_name->text(), m_password->text());
}

GcDialog::GcDialog(GcLive *plugin, QWidget *parent) :
  QDialog(parent) {

  this->m_plugin = plugin;

  setWindowTitle(tr("GcLive login"));

  QVBoxLayout *mainLayout = new QVBoxLayout;

  QSettings settings;
  settings.beginGroup("GcLive");

  /* -------------- user name entry --------------- */
  mainLayout->addWidget(new QLabel(tr("Username") + ":", this));
  m_name = new QLineEdit(settings.value("Name", "").toString());
  mainLayout->addWidget(m_name);

  /* -------------- password entry --------------- */
  mainLayout->addWidget(new QLabel(tr("Password") + ":", this));
  m_password = new QLineEdit(settings.value("Password", "").toString());
  m_password->setEchoMode(QLineEdit::PasswordEchoOnEdit);
  mainLayout->addWidget(m_password);

  mainLayout->addStretch(1);

  settings.endGroup();

  QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok
				     | QDialogButtonBox::Cancel);

  connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
  connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

  mainLayout->addWidget(buttonBox);
  setLayout(mainLayout);

  connect(this, SIGNAL(accepted()), this, SLOT(applyChanges()));
}
