#ifndef MAP_OVERLAY_H
#define MAP_OVERLAY_H

#include <QPainter>
#include <QStyleOptionGraphicsItem>
#include <QGeoMapOverlay>
#include <QList>

#include "mapbuttonmanager.h"

class MapWidget;

class MapOverlay : public QGeoMapOverlay {
 public:
  MapOverlay(MapWidget *x);
  ~MapOverlay();
  void paint(QPainter *, const QStyleOptionGraphicsItem *);
  void enableZoomButtons(bool, bool);
  void enableGpsButton(bool);
  void enableForwardButton(bool);
  void changeGpsButton(bool);

  bool mousePress(const QPointF &);
  bool mouseMove(const QPointF &);
  bool mouseRelease(const QPointF &);
  bool isInside(const QPointF &);

 private:
  MapButtonManager *m_mapButtonManager;
};

#endif // MAP_OVERLAY_H
