#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QGraphicsView>
#include <QGeoServiceProvider>
#include <QMenu>
#include <QMenuBar>

#include "locationprovider.h"
#include "mapwidget.h"
#include "cache.h"
#include "gcprovider.h"

class MainWindow : public QMainWindow {
  Q_OBJECT;

 public:
  MainWindow(LocationProvider *, QWidget *parent = 0);
  ~MainWindow();

 protected:
  void resizeEvent(QResizeEvent* event);
  void keyPressEvent(QKeyEvent* event);
  
 signals:
  void increasePressed();
  void decreasePressed();
  
 public slots:
  void statusMessage(const QString &, int = 5000);
  // called from map widget whenever the viewport changed
  void reloadCaches();
  // called from cacheprovider
  void updateCaches(const CacheList &);
  void displayError(const QString &);
  // called from map whenever the user clicked a cache icon
  void selectCache(const QString &);
  
 private slots:
  void about();
  void mapdialog();
    
 private:
    void createMenu();
    
  QGeoServiceProvider *m_serviceProvider;
  MapWidget *m_mapWidget;
  GcProvider m_cacheProvider;
  LocationProvider *m_locationProvider;
  QString m_message;   
  QGraphicsView *m_view;
};

#endif
