#ifndef MAP_BUTTON_MANAGER_H
#define MAP_BUTTON_MANAGER_H

#include <QPainter>

#include "mapbutton.h"
#include "iconloader.h"

class MapButtonManager : public QList <MapButton*>  {
    
 public:
  MapButtonManager(int);
  ~MapButtonManager();
  MapButton* create(const QString &, int, int, MapButton::State = MapButton::Normal);
  void setState(const QString &, MapButton::State = MapButton::Normal);
  void paint(QPainter *);
  bool mousePress(const QPointF &);
  bool mouseMove(const QPointF &);
  bool mouseRelease(const QPointF &);
  bool isInside(const QPointF &) const;
  void change(const QString &, const QString &);

 private:
  IconLoader *m_iconLoader;
  int m_size;
};

#endif // MAP_BUTTON_MANAGER_H
